/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.service.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.ObjectContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Conversion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StrSubstitutor;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.vorto.service.mapping.DataInput;
import org.eclipse.vorto.service.mapping.IDataMapper;
import org.eclipse.vorto.service.mapping.MappingContext;
import org.eclipse.vorto.service.mapping.MappingException;
import org.eclipse.vorto.service.mapping.internal.JxPathFactory;
import org.eclipse.vorto.service.mapping.internal.converter.Arrays;
import org.eclipse.vorto.service.mapping.internal.converter.Base64;
import org.eclipse.vorto.service.mapping.internal.converter.ConvertUtils;
import org.eclipse.vorto.service.mapping.internal.converter.DateUtils;
import org.eclipse.vorto.service.mapping.internal.converter.Jxpath;
import org.eclipse.vorto.service.mapping.normalized.FunctionblockData;
import org.eclipse.vorto.service.mapping.normalized.InfomodelData;
import org.eclipse.vorto.service.mapping.spec.IMappingSpecification;

public abstract class AbstractDataMapper<Result>
implements IDataMapper<Result> {
    private IMappingSpecification specification;
    private JxPathFactory jxpathHelper = null;
    private static final JexlEngine JEXL = AbstractDataMapper.createJexlEngine();
    private static final String STEREOTYPE = "source";
    private static final String ATTRIBUTE_XPATH = "xpath";
    private static final Object ATTRIBUTE_CONDITION = "condition";

    public AbstractDataMapper(IMappingSpecification mappingSpecification) {
        this.specification = mappingSpecification;
        this.jxpathHelper = new JxPathFactory(mappingSpecification.getCustomFunctions());
    }

    private static JexlEngine createJexlEngine() {
        JexlEngine jexl = new JexlEngine();
        HashMap<String, Class<Arrays>> funcs = new HashMap<String, Class<Arrays>>();
        funcs.put("conversion", Conversion.class);
        funcs.put("string", StringUtils.class);
        funcs.put("number", NumberUtils.class);
        funcs.put("date", DateUtils.class);
        funcs.put("type", ConvertUtils.class);
        funcs.put("boolean", BooleanUtils.class);
        funcs.put("base64", Base64.class);
        funcs.put("binaryString", DatatypeConverter.class);
        funcs.put(ATTRIBUTE_XPATH, Jxpath.class);
        funcs.put("endian", EndianUtils.class);
        funcs.put("array", Arrays.class);
        jexl.setFunctions(funcs);
        return jexl;
    }

    @Override
    public Result map(DataInput input, MappingContext mappingContext) {
        JXPathContext context = this.jxpathHelper.newContext(input.getValue());
        InfomodelData normalized = new InfomodelData();
        Infomodel deviceInfoModel = this.specification.getInfoModel();
        for (ModelProperty fbProperty : deviceInfoModel.getFunctionblocks()) {
            FunctionblockData mappedFb;
            if (!mappingContext.isIncluded(fbProperty.getName()) || (mappedFb = this.mapFunctionBlock(fbProperty, context)) == null) continue;
            normalized.withFunctionblock(mappedFb);
        }
        return this.doMap(normalized, mappingContext);
    }

    private FunctionblockData mapFunctionBlock(ModelProperty fbProperty, JXPathContext context) {
        Object mapped;
        FunctionblockModel fbModel = this.specification.getFunctionBlock(fbProperty.getName());
        FunctionblockData fbData = new FunctionblockData(fbProperty.getName());
        for (ModelProperty statusProperty : fbModel.getStatusProperties()) {
            try {
                mapped = this.mapProperty(statusProperty, context);
                if (mapped == null) continue;
                fbData.withStatusProperty(statusProperty.getName(), mapped);
            }
            catch (JXPathNotFoundException ex) {
                if (!statusProperty.isMandatory()) continue;
                return null;
            }
            catch (JXPathInvalidAccessException ex) {
                if (ex.getCause() instanceof JXPathNotFoundException && statusProperty.isMandatory()) {
                    return null;
                }
                throw new MappingException("A problem occured during mapping", ex);
            }
        }
        for (ModelProperty configProperty : fbModel.getConfigurationProperties()) {
            try {
                mapped = this.mapProperty(configProperty, context);
                if (mapped == null) continue;
                fbData.withConfigurationProperty(configProperty.getName(), mapped);
            }
            catch (JXPathNotFoundException ex) {
                if (!configProperty.isMandatory()) continue;
                return null;
            }
            catch (JXPathInvalidAccessException ex) {
                if (ex.getCause() instanceof JXPathNotFoundException && configProperty.isMandatory()) {
                    return null;
                }
                throw new MappingException("A problem occured during mapping", ex);
            }
        }
        return this.onlyReturnIfPopulated(fbData);
    }

    private FunctionblockData onlyReturnIfPopulated(FunctionblockData fbData) {
        if (!fbData.getConfiguration().isEmpty() || !fbData.getStatus().isEmpty()) {
            return fbData;
        }
        return null;
    }

    protected abstract Result doMap(InfomodelData var1, MappingContext var2);

    private Object mapProperty(ModelProperty property, JXPathContext input) {
        Optional sourceStereotype = property.getStereotype(STEREOTYPE);
        if (sourceStereotype.isPresent() && this.hasXpath(((Stereotype)sourceStereotype.get()).getAttributes())) {
            String expression = this.replacePlaceHolders((String)((Stereotype)sourceStereotype.get()).getAttributes().get(ATTRIBUTE_XPATH), ((Stereotype)sourceStereotype.get()).getAttributes());
            if (this.matchesCondition(((Stereotype)sourceStereotype.get()).getAttributes(), input)) {
                return input.getValue(expression);
            }
        }
        return null;
    }

    private boolean matchesCondition(Map<String, String> attributes, JXPathContext context) {
        if (attributes.containsKey(ATTRIBUTE_CONDITION) && !attributes.get(ATTRIBUTE_CONDITION).equals("")) {
            Expression e = JEXL.createExpression(this.normalizeCondition(attributes.get(ATTRIBUTE_CONDITION)));
            ObjectContext jc = new ObjectContext(JEXL, context.getContextBean());
            jc.set("this", context.getContextBean());
            return (Boolean)e.evaluate((JexlContext)jc);
        }
        return true;
    }

    private String normalizeCondition(String expression) {
        return expression.replaceAll("/", "\\.");
    }

    private boolean hasXpath(Map<String, String> stereotypeAttributes) {
        return stereotypeAttributes.containsKey(ATTRIBUTE_XPATH) && !stereotypeAttributes.get(ATTRIBUTE_XPATH).equals("");
    }

    private String replacePlaceHolders(String expression, Map<String, String> mappedAttributes) {
        StrSubstitutor sub = new StrSubstitutor(mappedAttributes);
        return sub.replace(expression);
    }
}

