/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine;

import java.io.InputStream;
import org.eclipse.vorto.mapping.engine.DataInput;
import org.eclipse.vorto.mapping.engine.IDataMapper;
import org.eclipse.vorto.mapping.engine.MappingContext;
import org.eclipse.vorto.mapping.engine.converter.JavascriptEvalProvider;
import org.eclipse.vorto.mapping.engine.functions.IScriptEvalProvider;
import org.eclipse.vorto.mapping.engine.normalized.InfomodelData;
import org.eclipse.vorto.mapping.engine.spec.IMappingSpecification;

public final class MappingEngine {
    private IDataMapper mapper;

    private MappingEngine(IMappingSpecification specification) {
        this.mapper = IDataMapper.newBuilder().registerScriptEvalProvider((IScriptEvalProvider)new JavascriptEvalProvider()).withSpecification(specification).build();
    }

    public static MappingEngine create(IMappingSpecification specification) {
        return new MappingEngine(specification);
    }

    public static MappingEngine createFromInputStream(InputStream inputStream) {
        IMappingSpecification spec = IMappingSpecification.newBuilder().fromInputStream(inputStream).build();
        return new MappingEngine(spec);
    }

    public InfomodelData map(DataInput deviceData) {
        return this.mapper.map(deviceData, MappingContext.empty());
    }
}

