/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java.service.hono;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HonoDataService
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"HonoDataService.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append((Object)_javaPackageBasePath, "");
        _builder.append((Object)"/service/hono");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)".service.hono;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.HashMap;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Map;");
        _builder.newLine();
        _builder.append((Object)"import java.util.Objects;");
        _builder.newLine();
        _builder.newLine();
        EList _references = element.getReferences();
        for (ModelReference reference : _references) {
            ModelId modelId = ModelIdFactory.newInstance((ModelType)ModelType.Functionblock, (ModelReference)reference);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"import ");
            String _javaPackage_1 = Utils.getJavaPackage(element);
            _builder.append((Object)_javaPackage_1, "");
            _builder.append((Object)".model.");
            String _name = modelId.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"import ");
        String _javaPackage_2 = Utils.getJavaPackage(element);
        _builder.append((Object)_javaPackage_2, "");
        _builder.append((Object)".service.IDataService;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data Service Implementation that sends device data to Eclipse Hono MQTT Endpoint");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class HonoDataService implements IDataService {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String mqttHostUrl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String honoTenant;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String dittoNamespace;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String authId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String deviceId;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String password;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Map<String, HonoMqttClient> deviceClients = new HashMap<String, HonoMqttClient>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Gson gson = new Gson();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public HonoDataService(String mqttHostUrl, String honoTenant, String dittoNamespace, String deviceId, String authId, String password) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.mqttHostUrl = Objects.requireNonNull(mqttHostUrl);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.honoTenant = Objects.requireNonNull(honoTenant);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.dittoNamespace = Objects.requireNonNull(dittoNamespace);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.deviceId = Objects.requireNonNull(deviceId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.authId = Objects.requireNonNull(authId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.password = Objects.requireNonNull(password);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public void publish");
            String _name_1 = fbProperty.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)"(String resourceId, ");
            FunctionblockModel _type = fbProperty.getType();
            String _name_2 = _type.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" ");
            String _name_3 = fbProperty.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"getConnectedHonoClient(resourceId).send(\"telemetry/\" + honoTenant + \"/\" + resourceId, gson.toJson(wrap(");
            String _name_4 = fbProperty.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)".getStatusProperties(),");
            String _name_5 = fbProperty.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)".getConfigurationProperties(),\"");
            String _name_6 = fbProperty.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\")));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private <T> Map<String, Object> wrap(T StatusProperties, T ConfigurationProperties, String featureName) {\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Object> headers = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"headers.put(\"response-required\", Boolean.FALSE);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Object> wrapper = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"wrapper.put(\"topic\", dittoNamespace + \"/\" + deviceId + \"/things/twin/commands/modify\");");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"wrapper.put(\"path\", \"/features/\"+featureName);");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"wrapper.put(\"value\", createValue(StatusProperties,ConfigurationProperties));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"wrapper.put(\"headers\", headers);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return wrapper; ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private <T> Map<String, Object> createValue(T StatusProperties, T ConfigurationProperties) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Object> value = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Map<String, Object> properties = new HashMap<String, Object>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"properties.put(\"status\",StatusProperties);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"properties.put(\"configuration\",ConfigurationProperties);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"value.put(\"properties\", properties);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return value;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private HonoMqttClient getConnectedHonoClient(String resourceId) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"HonoMqttClient client = deviceClients.get(resourceId);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (client == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"client = new HonoMqttClient(mqttHostUrl, resourceId, authId, password);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"deviceClients.put(resourceId, client);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!client.isConnected()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"client.connect();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return client;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

