/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.java.TypeMapper;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class AppTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append(_name);
        _builder.append("App.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append(_javaPackageBasePath);
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append(_javaPackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.apache.log4j.Logger;");
        _builder.newLine();
        _builder.newLine();
        EList _references = element.getReferences();
        for (ModelReference reference : _references) {
            ModelId modelId = ModelIdFactory.newInstance((ModelType)ModelType.Functionblock, (ModelReference)reference);
            _builder.newLineIfNotEmpty();
            _builder.append("import ");
            String _javaPackage_1 = Utils.getJavaPackage(element);
            _builder.append(_javaPackage_1);
            _builder.append(".model.");
            String _name = modelId.getName();
            _builder.append(_name);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("import ");
        String _javaPackage_2 = Utils.getJavaPackage(element);
        _builder.append(_javaPackage_2);
        _builder.append(".service.hono.HonoDataService;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Example App that uses the Hono Data Service by sending random data to Eclipse Hono MQTT Connector");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _name_1 = element.getName();
        _builder.append(_name_1);
        _builder.append("App {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final Logger LOGGER = Logger.getLogger(");
        String _name_2 = element.getName();
        _builder.append(_name_2, "\t");
        _builder.append("App.class);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Configuration Section */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Adjust according to your Endpoint Configuration*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Hono MQTT Endpoint");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String MQTT_ENDPOINT = \"");
        String _orDefault = context.getConfigurationProperties().getOrDefault("hono_endpoint", "<INSERT HONO MQTT ENDPOINT HERE>");
        _builder.append(_orDefault, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Your Tenant");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String HONO_TENANT = \"");
        String _orDefault_1 = context.getConfigurationProperties().getOrDefault("hono_tenant", "DEFAULT_TENANT");
        _builder.append(_orDefault_1, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Your DeviceId");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String DEVICE_ID = \"");
        String _orDefault_2 = context.getConfigurationProperties().getOrDefault("deviceId", "<INSERT DEVICE ID HERE>");
        _builder.append(_orDefault_2, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Device authentication ID");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String AUTH_ID = \"");
        String _orDefault_3 = context.getConfigurationProperties().getOrDefault("hono_user", "<INSERT DEVICE AUTH ID HERE>");
        _builder.append(_orDefault_3, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Ditto topic , e.g. com.mycompany/4711");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String DITTO_TOPIC = \"");
        String _orDefault_4 = context.getConfigurationProperties().getOrDefault("ditto_topic", "com.mycompany/1234");
        _builder.append(_orDefault_4, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Device authentication Password");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final String PASSWORD = \"ENTER_DEVICE_PASSWORD\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static final long SEND_INTERVAL_IN_SECONDS = 2;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static void main(final String... args) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("HonoDataService honoDataService = new HonoDataService(MQTT_ENDPOINT, HONO_TENANT, DITTO_TOPIC, ");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("DEVICE_ID, AUTH_ID,PASSWORD);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (true) {");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append("\t\t\t");
            _builder.append("honoDataService.publish");
            String _firstUpper = StringExtensions.toFirstUpper((String)fbProperty.getName());
            _builder.append(_firstUpper, "\t\t\t");
            _builder.append("(DEVICE_ID,read");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)fbProperty.getName());
            _builder.append(_firstUpper_1, "\t\t\t");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Thread.sleep(SEND_INTERVAL_IN_SECONDS * 1000);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("LOGGER.error(e);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        EList _properties_1 = element.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            Configuration _configuration;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            _builder.append("\t");
            _builder.append("/**");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("* Reads the ");
            String _name_3 = fbProperty_1.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" from the device");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private static ");
            String _name_4 = fbProperty_1.getType().getName();
            _builder.append(_name_4, "\t");
            _builder.append(" read");
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)fbProperty_1.getName());
            _builder.append(_firstUpper_2, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _name_5 = fbProperty_1.getType().getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(" ");
            String _name_6 = fbProperty_1.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(" = new ");
            String _name_7 = fbProperty_1.getType().getName();
            _builder.append(_name_7, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            Status _status = fbProperty_1.getType().getFunctionblock().getStatus();
            boolean bl = _tripleNotEquals = _status != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//Status properties");
                _builder.newLine();
                EList _properties_2 = fbProperty_1.getType().getFunctionblock().getStatus().getProperties();
                for (Property statusProperty : _properties_2) {
                    _builder.append("\t");
                    _builder.append("\t");
                    String _name_8 = fbProperty_1.getName();
                    _builder.append(_name_8, "\t\t");
                    _builder.append(".set");
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)TypeMapper.checkKeyword(statusProperty.getName()));
                    _builder.append(_firstUpper_3, "\t\t");
                    _builder.append("(");
                    String _randomValue = TypeMapper.getRandomValue(statusProperty.getType());
                    _builder.append(_randomValue, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
            boolean bl2 = _tripleNotEquals_1 = (_configuration = fbProperty_1.getType().getFunctionblock().getConfiguration()) != null;
            if (_tripleNotEquals_1) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("//Configuration properties");
                _builder.newLine();
                EList _properties_3 = fbProperty_1.getType().getFunctionblock().getConfiguration().getProperties();
                for (Property configurationProperty : _properties_3) {
                    _builder.append("\t");
                    _builder.append("\t");
                    String _name_9 = fbProperty_1.getName();
                    _builder.append(_name_9, "\t\t");
                    _builder.append(".set");
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)TypeMapper.checkKeyword(configurationProperty.getName()));
                    _builder.append(_firstUpper_4, "\t\t");
                    _builder.append("(");
                    String _randomValue_1 = TypeMapper.getRandomValue(configurationProperty.getType());
                    _builder.append(_randomValue_1, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _name_10 = fbProperty_1.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

