/*
 * Decompiled with CFR 0.152.
 */
package copied.org.apache.maven.plugin;

import copied.org.apache.maven.plugin.CompilationFailureException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCompilerMojo
extends AbstractMojo {
    public static final String DEFAULT_SOURCE_VERSION = "11";
    public static final String DEFAULT_TARGET_VERSION = "11";
    @Parameter(property="maven.compiler.debug", defaultValue="true")
    private boolean debug;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="maven.compiler.showDeprecation", defaultValue="false")
    private boolean showDeprecation;
    @Parameter(property="maven.compiler.optimize", defaultValue="false")
    private boolean optimize;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="false")
    private boolean showWarnings;
    @Parameter(property="maven.compiler.failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="maven.compiler.source")
    protected String source;
    @Parameter(property="maven.compiler.target")
    protected String target;
    @Parameter(property="maven.compiler.release")
    protected String release;
    @Parameter(property="maven.compiler.encoding", readonly=true)
    private String mavenCompilerEncoding;
    @Parameter(property="project.build.sourceEncoding")
    private String encoding;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(property="maven.compiler.compilerId", defaultValue="jdt")
    private String compilerId;
    @Parameter(property="maven.compiler.compilerVersion")
    private String compilerVersion;
    @Parameter(defaultValue="false")
    private boolean fork;
    @Parameter(property="maven.compiler.meminitial")
    private String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    private String maxmem;
    @Parameter(property="maven.compiler.executable")
    private String executable;
    @Parameter
    private String proc;
    @Parameter
    private String[] annotationProcessors;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    private File generatedSourcesDirectory;
    @Parameter
    private Map<String, String> compilerArguments;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private String compilerArgument;
    @Parameter(property="project.build.finalName")
    private String outputFileName;
    @Parameter(property="basedir", required=true, readonly=true)
    private File basedir;
    @Parameter(property="project.build.directory", readonly=true, required=true)
    private File buildDirectory;
    @Component
    private CompilerManager compilerManager;

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected abstract SourceInclusionScanner getSourceInclusionScanner(String var1);

    protected abstract List<String> getClasspathElements() throws MojoExecutionException;

    protected abstract List<String> getCompileSourceRoots() throws MojoExecutionException;

    protected abstract List<String> getCompileSourceExcludePaths() throws MojoExecutionException;

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        CompilerResult result;
        Set<File> staleSources;
        Compiler compiler;
        this.getLog().debug((CharSequence)("Using compiler '" + this.compilerId + "'."));
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
        }
        catch (NoSuchCompilerException e) {
            throw new MojoExecutionException("No such compiler '" + e.getCompilerId() + "'.");
        }
        List<String> compileSourceRoots = AbstractCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots());
        if (compileSourceRoots.isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source directories: " + compileSourceRoots.toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Classpath: " + this.getClasspathElements().toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Output directory: " + this.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration = this.getCompilerConfiguration(compileSourceRoots, this.getCompileSourceExcludePaths());
        try {
            staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
            boolean canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
            if (compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget) {
                this.getLog().info((CharSequence)"RESCANNING!");
                String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
                Set<File> sources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(inputFileEnding));
                compilerConfiguration.setSourceFiles(sources);
            } else {
                compilerConfiguration.setSourceFiles(staleSources);
            }
        }
        catch (CompilerException e) {
            throw new MojoExecutionException("Error while computing stale sources.", (Exception)((Object)e));
        }
        if (staleSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                this.getLog().debug((CharSequence)(" " + s));
            }
            this.getLog().debug((CharSequence)"Source roots:");
            for (String root : this.getCompileSourceRoots()) {
                this.getLog().debug((CharSequence)(" " + root));
            }
            if (this.fork) {
                try {
                    String[] cl;
                    if (compilerConfiguration.getExecutable() != null) {
                        this.getLog().debug((CharSequence)"Excutable: ");
                        this.getLog().debug((CharSequence)(" " + compilerConfiguration.getExecutable()));
                    }
                    if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(cl[0]);
                        for (int i = 1; i < cl.length; ++i) {
                            sb.append(" ");
                            sb.append(cl[i]);
                        }
                        this.getLog().debug((CharSequence)"Command line options:");
                        this.getLog().debug((CharSequence)sb);
                    }
                }
                catch (CompilerException ce) {
                    this.getLog().debug((Throwable)ce);
                }
            }
        }
        try {
            result = compiler.performCompile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fatal error compiling", e);
        }
        List messages = result.getCompilerMessages();
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            CompilerMessage message = (CompilerMessage)i.next();
            if (message.isError()) continue;
            this.getLog().warn((CharSequence)message.toString());
            i.remove();
        }
        if (!result.isSuccess()) {
            throw new CompilationFailureException(messages);
        }
    }

    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots, List<String> compileSourceExcludes) throws MojoExecutionException, MojoFailureException {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.getOutputDirectory().getAbsolutePath());
        compilerConfiguration.setClasspathEntries(this.getClasspathElements());
        compilerConfiguration.setSourceLocations(compileSourceRoots);
        compilerConfiguration.setOptimize(this.optimize);
        compilerConfiguration.setDebug(this.debug);
        compilerConfiguration.setVerbose(this.verbose);
        compilerConfiguration.setShowWarnings(this.showWarnings);
        compilerConfiguration.setShowDeprecation(this.showDeprecation);
        compilerConfiguration.setProc(this.proc);
        compilerConfiguration.setFailOnWarning(this.failOnWarning);
        compilerConfiguration.setAnnotationProcessors(this.annotationProcessors);
        compilerConfiguration.setGeneratedSourcesDirectory(this.generatedSourcesDirectory);
        compilerConfiguration.setSourceVersion(this.source != null ? this.source : "11");
        compilerConfiguration.setTargetVersion(this.target != null ? this.target : "11");
        if (this.release != null) {
            compilerConfiguration.setReleaseVersion(this.release);
        }
        compilerConfiguration.setSourceEncoding(this.getEncoding());
        if (this.compilerArguments != null || this.compilerArgument != null || this.compilerArgs != null) {
            if (this.compilerArguments != null) {
                for (Map.Entry<String, String> me : this.compilerArguments.entrySet()) {
                    Object key = me.getKey();
                    String value = me.getValue();
                    if (!((String)key).startsWith("-")) {
                        key = "-" + (String)key;
                    }
                    if (((String)key).startsWith("-A") && StringUtils.isNotEmpty((String)value)) {
                        compilerConfiguration.addCompilerCustomArgument((String)key + "=" + value, null);
                        continue;
                    }
                    compilerConfiguration.addCompilerCustomArgument((String)key, value);
                }
            }
            if (!StringUtils.isEmpty((String)this.compilerArgument)) {
                compilerConfiguration.addCompilerCustomArgument(this.compilerArgument, null);
            }
            if (this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    compilerConfiguration.addCompilerCustomArgument(arg, null);
                }
            }
        }
        compilerConfiguration.setFork(this.fork);
        if (this.fork) {
            String value;
            if (!StringUtils.isEmpty((String)this.meminitial)) {
                value = this.getMemoryValue(this.meminitial);
                if (value != null) {
                    compilerConfiguration.setMeminitial(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for meminitial '" + this.meminitial + "'. Ignoring this option."));
                }
            }
            if (!StringUtils.isEmpty((String)this.maxmem)) {
                value = this.getMemoryValue(this.maxmem);
                if (value != null) {
                    compilerConfiguration.setMaxmem(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for maxmem '" + this.maxmem + "'. Ignoring this option."));
                }
            }
        }
        compilerConfiguration.setExecutable(this.executable);
        compilerConfiguration.setWorkingDirectory(this.basedir);
        compilerConfiguration.setCompilerVersion(this.compilerVersion);
        compilerConfiguration.setBuildDirectory(this.buildDirectory);
        compilerConfiguration.setOutputFileName(this.outputFileName);
        for (String exclude : compileSourceExcludes) {
            compilerConfiguration.addExclude(exclude);
        }
        return compilerConfiguration;
    }

    private String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return this.mavenCompilerEncoding;
    }

    private String getMemoryValue(String setting) {
        Object value = null;
        if (this.isDigits(setting)) {
            value = setting + "m";
        } else if (this.isDigits(setting.substring(0, setting.length() - 1)) && setting.toLowerCase().endsWith("m")) {
            value = setting;
        }
        return value;
    }

    private boolean isDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, Compiler compiler, SourceInclusionScanner scanner) throws MojoExecutionException, CompilerException {
        File outputDirectory;
        SuffixMapping mapping;
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            mapping = new SuffixMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFileEnding(compilerConfiguration));
            outputDirectory = this.getOutputDirectory();
        } else if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            mapping = new SingleTargetSourceMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFile(compilerConfiguration));
            outputDirectory = this.buildDirectory;
        } else {
            throw new MojoExecutionException("Unknown compiler output style: '" + outputStyle + "'.");
        }
        scanner.addSourceMapping((SourceMapping)mapping);
        HashSet<File> staleSources = new HashSet<File>();
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    protected static List<String> removeEmptyCompileSourceRoots(List<String> compileSourceRootsList) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                if (newCompileSourceRootsList.contains(srcDir) || !new File(srcDir).exists()) continue;
                newCompileSourceRootsList.add(srcDir);
            }
        }
        return newCompileSourceRootsList;
    }
}

