/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverImpl;
import org.eclipse.rdf4j.repository.DelegatingRepository;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.config.DelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionListener;
import org.eclipse.rdf4j.repository.event.base.RepositoryConnectionListenerAdapter;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.manager.SystemRepository;
import org.eclipse.rdf4j.repository.manager.SystemRepositoryConfig;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;

public class LocalRepositoryManager
extends RepositoryManager {
    public static final String REPOSITORIES_DIR = "repositories";
    private final File baseDir;
    private volatile SharedHttpClientSessionManager client;
    private volatile FederatedServiceResolverImpl serviceResolver;

    public LocalRepositoryManager(File baseDir) {
        this.baseDir = baseDir;
    }

    protected SystemRepository createSystemRepository() throws RepositoryException {
        File systemDir = this.getRepositoryDir("SYSTEM");
        SystemRepository systemRepos = new SystemRepository(systemDir);
        systemRepos.initialize();
        systemRepos.addRepositoryConnectionListener((RepositoryConnectionListener)new ConfigChangeListener());
        return systemRepos;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return this.baseDir.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedHttpClientSessionManager getSesameClient() {
        SharedHttpClientSessionManager result = this.client;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.client;
                if (result == null) {
                    result = this.client = new SharedHttpClientSessionManager();
                }
            }
        }
        return result;
    }

    @Override
    public HttpClient getHttpClient() {
        SharedHttpClientSessionManager nextClient = this.client;
        if (nextClient == null) {
            return null;
        }
        return nextClient.getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.getSesameClient().setHttpClient(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FederatedServiceResolver getFederatedServiceResolver() {
        FederatedServiceResolverImpl result = this.serviceResolver;
        if (result == null) {
            LocalRepositoryManager localRepositoryManager = this;
            synchronized (localRepositoryManager) {
                result = this.serviceResolver;
                if (result == null) {
                    result = this.serviceResolver = new FederatedServiceResolverImpl();
                    result.setHttpClientSessionManager((HttpClientSessionManager)this.getSesameClient());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            super.shutDown();
        }
        finally {
            try {
                FederatedServiceResolverImpl toCloseServiceResolver = this.serviceResolver;
                this.serviceResolver = null;
                if (toCloseServiceResolver != null) {
                    toCloseServiceResolver.shutDown();
                }
            }
            finally {
                SharedHttpClientSessionManager toCloseClient = this.client;
                this.client = null;
                if (toCloseClient != null) {
                    toCloseClient.shutDown();
                }
            }
        }
    }

    public File resolvePath(String path) {
        return new File(this.getBaseDir(), path);
    }

    public File getRepositoryDir(String repositoryID) {
        File repositoriesDir = this.resolvePath(REPOSITORIES_DIR);
        return new File(repositoriesDir, repositoryID);
    }

    @Deprecated
    public SystemRepository getSystemRepository() {
        return (SystemRepository)super.getSystemRepository();
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        Repository repository = null;
        RepositoryConfig repConfig = this.getRepositoryConfig(id);
        if (repConfig != null) {
            repConfig.validate();
            repository = this.createRepositoryStack(repConfig.getRepositoryImplConfig());
            repository.setDataDir(this.getRepositoryDir(id));
            repository.initialize();
        }
        return repository;
    }

    private Repository createRepositoryStack(RepositoryImplConfig config) throws RepositoryConfigException {
        RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get((Object)config.getType()).orElseThrow(() -> new RepositoryConfigException("Unsupported repository type: " + config.getType()));
        Repository repository = factory.getRepository(config);
        if (repository instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)repository).setRepositoryResolver((RepositoryResolver)this);
        }
        if (repository instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)repository).setFederatedServiceResolver(this.getFederatedServiceResolver());
        }
        if (repository instanceof SessionManagerDependent) {
            ((SessionManagerDependent)repository).setHttpClientSessionManager((HttpClientSessionManager)this.client);
        } else if (repository instanceof HttpClientDependent) {
            ((HttpClientDependent)repository).setHttpClient(this.getHttpClient());
        }
        if (config instanceof DelegatingRepositoryImplConfig) {
            RepositoryImplConfig delegateConfig = ((DelegatingRepositoryImplConfig)config).getDelegate();
            Repository delegate = this.createRepositoryStack(delegateConfig);
            try {
                ((DelegatingRepository)repository).setDelegate(delegate);
            }
            catch (ClassCastException e) {
                throw new RepositoryConfigException("Delegate specified for repository that is not a DelegatingRepository: " + delegate.getClass(), (Throwable)e);
            }
        }
        return repository;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        try {
            RepositoryConfig config = null;
            config = id.equals("SYSTEM") ? new RepositoryConfig(id, (RepositoryImplConfig)new SystemRepositoryConfig()) : this.getRepositoryConfig(id);
            RepositoryInfo repInfo = new RepositoryInfo();
            repInfo.setId(id);
            repInfo.setDescription(config.getTitle());
            try {
                repInfo.setLocation(this.getRepositoryDir(id).toURI().toURL());
            }
            catch (MalformedURLException mue) {
                throw new RepositoryException("Location of repository does not resolve to a valid URL", (Throwable)mue);
            }
            repInfo.setReadable(true);
            repInfo.setWritable(true);
            return repInfo;
        }
        catch (RepositoryConfigException e) {
            throw new RepositoryException("Unable to read repository configuration", (Throwable)e);
        }
    }

    @Override
    public Set<String> getRepositoryIDs() throws RepositoryException {
        return RepositoryConfigUtil.getRepositoryIDs((Repository)this.getSystemRepository());
    }

    public List<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (String id : this.getRepositoryIDs()) {
            if (skipSystemRepo && id.equals("SYSTEM")) continue;
            result.add(this.getRepositoryInfo(id));
        }
        return result;
    }

    @Override
    protected void cleanUpRepository(String repositoryID) throws IOException {
        File dataDir = this.getRepositoryDir(repositoryID);
        if (dataDir.isDirectory()) {
            this.logger.debug("Cleaning up data dir {} for repository {}", (Object)dataDir.getAbsolutePath(), (Object)repositoryID);
            FileUtil.deleteDir((File)dataDir);
        }
    }

    class ConfigChangeListener
    extends RepositoryConnectionListenerAdapter {
        private final Map<RepositoryConnection, Set<Resource>> modifiedContextsByConnection = new HashMap<RepositoryConnection, Set<Resource>>();
        private final Map<RepositoryConnection, Boolean> modifiedAllContextsByConnection = new HashMap<RepositoryConnection, Boolean>();
        private final Map<RepositoryConnection, Set<Resource>> removedContextsByConnection = new HashMap<RepositoryConnection, Set<Resource>>();

        ConfigChangeListener() {
        }

        private Set<Resource> getModifiedContexts(RepositoryConnection conn) {
            Set<Resource> result = this.modifiedContextsByConnection.get(conn);
            if (result == null) {
                result = new HashSet<Resource>();
                this.modifiedContextsByConnection.put(conn, result);
            }
            return result;
        }

        private Set<Resource> getRemovedContexts(RepositoryConnection conn) {
            Set<Resource> result = this.removedContextsByConnection.get(conn);
            if (result == null) {
                result = new HashSet<Resource>();
                this.removedContextsByConnection.put(conn, result);
            }
            return result;
        }

        private void registerModifiedContexts(RepositoryConnection conn, Resource ... contexts) {
            Set<Resource> modifiedContexts = this.getModifiedContexts(conn);
            if (contexts == null) {
                this.modifiedAllContextsByConnection.put(conn, true);
            } else {
                for (Resource context : contexts) {
                    modifiedContexts.add(context);
                }
            }
        }

        public void add(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
            this.registerModifiedContexts(conn, contexts);
        }

        public void clear(RepositoryConnection conn, Resource ... contexts) {
            this.registerModifiedContexts(conn, contexts);
        }

        public void remove(RepositoryConnection conn, Resource subject, IRI predicate, Value object, Resource ... contexts) {
            if (object != null && object.equals(RepositoryConfigSchema.REPOSITORY_CONTEXT)) {
                if (subject == null) {
                    this.modifiedAllContextsByConnection.put(conn, true);
                } else {
                    Set<Resource> removedContexts = this.getRemovedContexts(conn);
                    removedContexts.add(subject);
                }
            }
            this.registerModifiedContexts(conn, contexts);
        }

        public void rollback(RepositoryConnection conn) {
            this.modifiedContextsByConnection.remove(conn);
            this.modifiedAllContextsByConnection.remove(conn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(RepositoryConnection con) {
            Boolean fullRefreshNeeded = this.modifiedAllContextsByConnection.remove(con);
            if (fullRefreshNeeded != null && fullRefreshNeeded.booleanValue()) {
                LocalRepositoryManager.this.logger.debug("Reacting to commit on SystemRepository for all contexts");
                LocalRepositoryManager.this.refresh();
            } else {
                Set<Resource> modifiedContexts = this.modifiedContextsByConnection.remove(con);
                Set<Resource> removedContexts = this.removedContextsByConnection.remove(con);
                if (removedContexts != null && !removedContexts.isEmpty()) {
                    modifiedContexts.removeAll(removedContexts);
                }
                if (modifiedContexts != null) {
                    LocalRepositoryManager.this.logger.debug("React to commit on SystemRepository for contexts {}", modifiedContexts);
                    try (NotifyingRepositoryConnection cleanupCon = LocalRepositoryManager.this.getSystemRepository().getConnection();){
                        for (Resource context : modifiedContexts) {
                            LocalRepositoryManager.this.logger.debug("Processing modified context {}.", (Object)context);
                            try {
                                if (this.isRepositoryConfigContext((RepositoryConnection)cleanupCon, context)) {
                                    String repositoryID = this.getRepositoryID((RepositoryConnection)cleanupCon, context);
                                    LocalRepositoryManager.this.logger.debug("Reacting to modified repository config for {}", (Object)repositoryID);
                                    Repository repository = LocalRepositoryManager.this.removeInitializedRepository(repositoryID);
                                    if (repository != null) {
                                        LocalRepositoryManager.this.logger.debug("Modified repository {} has been initialized, refreshing...", (Object)repositoryID);
                                        LocalRepositoryManager.this.refreshRepository(repositoryID, repository);
                                        continue;
                                    }
                                    LocalRepositoryManager.this.logger.debug("Modified repository {} has not been initialized, skipping...", (Object)repositoryID);
                                    continue;
                                }
                                LocalRepositoryManager.this.logger.debug("Context {} doesn't contain repository config information.", (Object)context);
                            }
                            catch (RepositoryException re) {
                                LocalRepositoryManager.this.logger.error("Failed to process repository configuration changes", (Throwable)re);
                            }
                        }
                    }
                    catch (RepositoryException re) {
                        LocalRepositoryManager.this.logger.error("Failed to process repository configuration changes", (Throwable)re);
                    }
                }
            }
        }

        private boolean isRepositoryConfigContext(RepositoryConnection con, Resource context) throws RepositoryException {
            LocalRepositoryManager.this.logger.debug("Is {} a repository config context?", (Object)context);
            return con.hasStatement(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, true, new Resource[]{null});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getRepositoryID(RepositoryConnection con, Resource context) throws RepositoryException {
            String result = null;
            try (RepositoryResult idStatements = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, null, true, new Resource[]{context});){
                if (idStatements.hasNext()) {
                    Statement idStatement = (Statement)idStatements.next();
                    result = idStatement.getObject().stringValue();
                }
            }
            return result;
        }
    }
}

