/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.rio.RDFHandler;

public final class Repositories {
    public static void consume(Repository repository, Consumer<RepositoryConnection> processFunction) throws RepositoryException, UnknownTransactionStateException {
        Repositories.get(repository, conn -> {
            processFunction.accept((RepositoryConnection)conn);
            return null;
        });
    }

    public static void consume(Repository repository, Consumer<RepositoryConnection> processFunction, Consumer<RepositoryException> exceptionHandler) throws RepositoryException, UnknownTransactionStateException {
        try {
            Repositories.consume(repository, processFunction);
        }
        catch (RepositoryException e) {
            exceptionHandler.accept(e);
        }
    }

    public static void consumeSilent(Repository repository, Consumer<RepositoryConnection> processFunction) {
        Repositories.consume(repository, processFunction, e -> {});
    }

    public static <T> T get(Repository repository, Function<RepositoryConnection, T> processFunction) throws RepositoryException, UnknownTransactionStateException {
        RepositoryConnection conn = null;
        try {
            conn = repository.getConnection();
            conn.begin();
            T result = processFunction.apply(conn);
            conn.commit();
            T t = result;
            return t;
        }
        catch (RepositoryException e) {
            if (conn != null && conn.isActive()) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
    }

    public static <T> T get(Repository repository, Function<RepositoryConnection, T> processFunction, Consumer<RepositoryException> exceptionHandler) throws RepositoryException, UnknownTransactionStateException {
        try {
            return Repositories.get(repository, processFunction);
        }
        catch (RepositoryException e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public static <T> T getSilent(Repository repository, Function<RepositoryConnection, T> processFunction) {
        return Repositories.get(repository, processFunction, e -> {});
    }

    public static <T> T tupleQuery(Repository repository, String query, Function<TupleQueryResult, T> processFunction) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        return (T)Repositories.get(repository, conn -> {
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            try (TupleQueryResult queryResult = preparedQuery.evaluate();){
                Object r = processFunction.apply(queryResult);
                return r;
            }
        });
    }

    public static void tupleQuery(Repository repository, String query, TupleQueryResultHandler handler) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        Repositories.consume(repository, conn -> {
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            preparedQuery.evaluate(handler);
        });
    }

    public static <T> T graphQuery(Repository repository, String query, Function<GraphQueryResult, T> processFunction) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        return (T)Repositories.get(repository, conn -> {
            GraphQuery preparedQuery = conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
            try (GraphQueryResult queryResult = preparedQuery.evaluate();){
                Object r = processFunction.apply(queryResult);
                return r;
            }
        });
    }

    public static void graphQuery(Repository repository, String query, RDFHandler handler) throws RepositoryException, UnknownTransactionStateException, MalformedQueryException, QueryEvaluationException {
        Repositories.consume(repository, conn -> {
            GraphQuery preparedQuery = conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
            preparedQuery.evaluate(handler);
        });
    }

    public static Supplier<RepositoryException> repositoryException(String message) {
        return () -> new RepositoryException(message);
    }

    private Repositories() {
    }
}

