/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoListRecord;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoOperation;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecord;

public class MongoInteraction
implements Interaction {
    protected MongoConnection connection;

    public MongoInteraction(MongoConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        if (!(spec instanceof MongoInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(input instanceof MongoRecord) || !(output instanceof MongoRecord)) {
            throw EISException.invalidRecordType();
        }
        MongoInteractionSpec mongoSpec = (MongoInteractionSpec)spec;
        MongoRecord record = (MongoRecord)input;
        MongoRecord translationRecord = (MongoRecord)output;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            throw new ResourceException("Mongo operation must be set");
        }
        if (collectionName == null) {
            throw new ResourceException("DB Collection name must be set");
        }
        try {
            DBCollection collection = this.connection.getDB().getCollection(collectionName);
            DBObject object = this.buildDBObject(record);
            DBObject translation = this.buildDBObject(translationRecord);
            if (operation == MongoOperation.UPDATE) {
                WriteResult result = collection.update(translation, object, mongoSpec.isUpsert(), mongoSpec.isMulti());
                return result.getN() > 0;
            }
            throw new ResourceException("Invalid operation: " + (Object)((Object)operation));
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        if (!(spec instanceof MongoInteractionSpec)) {
            throw EISException.invalidInteractionSpecType();
        }
        if (!(record instanceof MongoRecord)) {
            throw EISException.invalidRecordType();
        }
        MongoInteractionSpec mongoSpec = (MongoInteractionSpec)spec;
        MongoRecord input = (MongoRecord)record;
        MongoOperation operation = mongoSpec.getOperation();
        String collectionName = mongoSpec.getCollection();
        if (operation == null) {
            ResourceException resourceException = new ResourceException("Mongo operation must be set");
            throw resourceException;
        }
        if (operation == MongoOperation.EVAL) {
            Object result = this.connection.getDB().eval(mongoSpec.getCode(), new Object[0]);
            return this.buildRecordFromDBObject((DBObject)result);
        }
        if (collectionName == null) {
            ResourceException resourceException = new ResourceException("DB Collection name must be set");
            throw resourceException;
        }
        try {
            DBCollection collection = this.connection.getDB().getCollection(collectionName);
            if (mongoSpec.getOptions() > 0) {
                collection.setOptions(mongoSpec.getOptions());
            }
            if (mongoSpec.getReadPreference() != null) {
                collection.setReadPreference(mongoSpec.getReadPreference());
            }
            if (mongoSpec.getWriteConcern() != null) {
                collection.setWriteConcern(mongoSpec.getWriteConcern());
            }
            if (operation == MongoOperation.INSERT) {
                DBObject object = this.buildDBObject(input);
                collection.insert(new DBObject[]{object});
                return null;
            }
            if (operation == MongoOperation.REMOVE) {
                DBObject object = this.buildDBObject(input);
                collection.remove(object);
                return null;
            }
            if (operation != MongoOperation.FIND) throw new ResourceException("Invalid operation: " + (Object)((Object)operation));
            DBObject sort = null;
            if (input.containsKey("$sort")) {
                sort = this.buildDBObject((MongoRecord)input.get("$sort"));
                input.remove("$sort");
            }
            DBObject select = null;
            if (input.containsKey("$select")) {
                select = this.buildDBObject((MongoRecord)input.get("$select"));
                input.remove("$select");
            }
            DBObject object = this.buildDBObject(input);
            DBCursor cursor = collection.find(object, select);
            if (sort != null) {
                cursor.sort(sort);
            }
            try {
                if (mongoSpec.getSkip() > 0) {
                    cursor.skip(mongoSpec.getSkip());
                }
                if (mongoSpec.getLimit() != 0) {
                    cursor.limit(mongoSpec.getLimit());
                }
                if (mongoSpec.getBatchSize() != 0) {
                    cursor.batchSize(mongoSpec.getBatchSize());
                }
                if (!cursor.hasNext()) {
                    return null;
                }
                MongoListRecord results = new MongoListRecord();
                while (true) {
                    if (!cursor.hasNext()) {
                        MongoListRecord mongoListRecord = results;
                        return mongoListRecord;
                    }
                    DBObject result = cursor.next();
                    results.add(this.buildRecordFromDBObject(result));
                }
            }
            finally {
                cursor.close();
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
    }

    public DBObject buildDBObject(MongoRecord record) {
        BasicDBObject object = new BasicDBObject();
        for (Map.Entry entry : record.entrySet()) {
            if (entry.getValue() instanceof MongoRecord) {
                object.put((String)entry.getKey(), (Object)this.buildDBObject((MongoRecord)entry.getValue()));
                continue;
            }
            object.put((String)entry.getKey(), entry.getValue());
        }
        return object;
    }

    public MongoRecord buildRecordFromDBObject(DBObject object) {
        MongoRecord record = new MongoRecord();
        for (Map.Entry entry : object.toMap().entrySet()) {
            if (entry.getValue() instanceof BasicDBList) {
                ArrayList<MongoRecord> values = new ArrayList<MongoRecord>();
                for (Object value : (BasicDBList)entry.getValue()) {
                    if (value instanceof DBObject) {
                        values.add(this.buildRecordFromDBObject((DBObject)value));
                        continue;
                    }
                    values.add((MongoRecord)value);
                }
                record.put((String)entry.getKey(), values);
                continue;
            }
            if (entry.getValue() instanceof DBObject) {
                MongoRecord nestedRecord = this.buildRecordFromDBObject((DBObject)entry.getValue());
                record.put((String)entry.getKey(), nestedRecord);
                continue;
            }
            record.put((String)entry.getKey(), entry.getValue());
        }
        return record;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }
}

