/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.rs.DynamicRestClassLoader;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;

public class PersistenceFactoryBase
implements PersistenceContextFactory {
    protected final Map<String, Set<PersistenceContext>> dynamicPersistenceContexts = new HashMap<String, Set<PersistenceContext>>();

    public PersistenceContext bootstrapPersistenceContext(String name, EntityManagerFactory emf, URI baseURI, String version, boolean replace) {
        PersistenceContext persistenceContext = new PersistenceContext(name, emf, baseURI, ServiceVersion.fromCode(version));
        if (replace) {
            this.addReplacePersistenceContext(persistenceContext);
        }
        return persistenceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            for (Set<PersistenceContext> contextSet : this.dynamicPersistenceContexts.values()) {
                if (contextSet == null) continue;
                for (PersistenceContext context : contextSet) {
                    context.stop();
                }
            }
            this.dynamicPersistenceContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePersistenceContext(String name) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            Set<PersistenceContext> contextSet = this.dynamicPersistenceContexts.get(name);
            if (contextSet != null) {
                for (PersistenceContext context : contextSet) {
                    context.stop();
                }
            }
            this.dynamicPersistenceContexts.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePersistenceContext(String name, String version) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            Set<PersistenceContext> contextSet = this.dynamicPersistenceContexts.get(name);
            if (contextSet != null) {
                Iterator<PersistenceContext> iter = contextSet.iterator();
                while (iter.hasNext()) {
                    PersistenceContext context = iter.next();
                    if (!context.getVersion().equals(version)) continue;
                    context.stop();
                    iter.remove();
                    break;
                }
                if (contextSet.isEmpty()) {
                    this.dynamicPersistenceContexts.remove(name);
                } else {
                    this.dynamicPersistenceContexts.put(name, contextSet);
                }
            }
        }
    }

    protected static Map<String, Object> createProperties(DynamicClassLoader dcl, Map<String, ?> originalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", dcl);
        properties.put("eclipselink.weaving", "static");
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            if (!entry.getKey().startsWith("javax") && !entry.getKey().startsWith("eclipselink.log") && !entry.getKey().startsWith("eclipselink.target-server")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.putIfAbsent("eclipselink.weaving.rest", "true");
        return properties;
    }

    @Override
    public PersistenceContext get(String persistenceUnitName, URI defaultURI, String version, Map<String, Object> initializationProperties) {
        PersistenceContext persistenceContext = this.getDynamicPersistenceContext(persistenceUnitName, version);
        if (persistenceContext == null) {
            try {
                DynamicRestClassLoader dcl = new DynamicRestClassLoader(Thread.currentThread().getContextClassLoader());
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("eclipselink.classloader", (Object)dcl);
                if (initializationProperties != null) {
                    properties.putAll(initializationProperties);
                }
                properties.putIfAbsent("eclipselink.weaving.rest", "true");
                EntityManagerFactoryImpl factory = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)persistenceUnitName, properties);
                ClassLoader sessionLoader = factory.getServerSession().getLoader();
                if (!DynamicClassLoader.class.isAssignableFrom(sessionLoader.getClass())) {
                    properties = new HashMap();
                    dcl = new DynamicRestClassLoader(sessionLoader);
                    properties.put("eclipselink.classloader", (Object)dcl);
                    if (initializationProperties != null) {
                        properties.putAll(initializationProperties);
                    }
                    properties.putIfAbsent("eclipselink.weaving.rest", "true");
                    factory.refreshMetadata(properties);
                }
                persistenceContext = this.bootstrapPersistenceContext(persistenceUnitName, (EntityManagerFactory)factory, defaultURI, version, true);
            }
            catch (Exception e) {
                JPARSLogger.DEFAULT_LOGGER.exception(null, "exception_creating_persistence_context", new Object[]{persistenceUnitName, e.toString()}, e);
            }
        }
        if (persistenceContext != null && !persistenceContext.isWeavingEnabled()) {
            persistenceContext.getLogger().error(persistenceContext.getSessionId(), "weaving_required_for_relationships", new Object[0]);
            throw JPARSException.invalidConfiguration();
        }
        return persistenceContext;
    }

    @Override
    public Set<String> getPersistenceContextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        try {
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            for (Archive archive : archives) {
                List infos = PersistenceUnitProcessor.processPersistenceArchive((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo info : infos) {
                    if (info.getPersistenceUnitName().equals("jpa-rs") || EntityManagerSetupImpl.mustBeCompositeMember((PersistenceUnitInfo)info)) continue;
                    contextNames.add(info.getPersistenceUnitName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        contextNames.addAll(this.dynamicPersistenceContexts.keySet());
        return contextNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext getDynamicPersistenceContext(String name, String version) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            Set<PersistenceContext> persistenceContextSet = this.dynamicPersistenceContexts.get(name);
            if (persistenceContextSet != null) {
                for (PersistenceContext persistenceContext : persistenceContextSet) {
                    if (name != null && version != null) {
                        if (!name.equals(persistenceContext.getName()) || !version.equals(persistenceContext.getVersion())) continue;
                        return persistenceContext;
                    }
                    if (version != null || persistenceContext.getVersion() != null || name == null || !name.equals(persistenceContext.getName())) continue;
                    return persistenceContext;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplacePersistenceContext(PersistenceContext persistenceContext) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            PersistenceContext existingContext = this.getDynamicPersistenceContext(persistenceContext.getName(), persistenceContext.getVersion());
            Set<PersistenceContext> persistenceContextSet = this.dynamicPersistenceContexts.get(persistenceContext.getName());
            if (persistenceContextSet == null) {
                persistenceContextSet = new HashSet<PersistenceContext>();
            }
            if (existingContext != null) {
                persistenceContextSet.remove(existingContext);
            }
            persistenceContextSet.add(persistenceContext);
            this.dynamicPersistenceContexts.put(persistenceContext.getName(), persistenceContextSet);
        }
    }
}

