/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features;

import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.jpa.rs.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultList;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;
import org.eclipse.persistence.jpa.rs.util.list.SimpleHomogeneousList;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryList;

public class FeatureResponseBuilderImpl
implements FeatureResponseBuilder {
    @Override
    public Object buildReadAllQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object> items, UriInfo uriInfo) {
        return items;
    }

    @Override
    public Object buildReportQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> items, UriInfo uriInfo) {
        if (results != null && !results.isEmpty()) {
            ReportQueryResultList list = this.populateReportQueryResultList(results, items);
            return list;
        }
        return results;
    }

    @Override
    public Object buildAttributeResponse(PersistenceContext context, Map<String, Object> queryParams, String attribute, Object result, UriInfo uriInfo) {
        if (result instanceof Collection) {
            if (this.containsDomainObjects(result)) {
                return result;
            }
            return this.populateSimpleHomogeneousList((Collection)result, attribute);
        }
        return result;
    }

    @Override
    public Object buildSingleResultQueryResponse(PersistenceContext context, Map<String, Object> queryParams, Object result, List<ReportItem> items, UriInfo uriInfo) {
        SingleResultQueryList response = new SingleResultQueryList();
        List<JAXBElement<?>> fields = new FeatureResponseBuilderImpl().createShellJAXBElementList(items, result);
        response.setFields(fields);
        return response;
    }

    @Override
    public Object buildSingleEntityResponse(PersistenceContext context, Map<String, Object> queryParams, Object result, UriInfo uriInfo) {
        return result;
    }

    private ReportQueryResultList populateReportQueryResultList(List<Object[]> results, List<ReportItem> reportItems) {
        ReportQueryResultList response = new ReportQueryResultList();
        for (Object[] result : results) {
            ReportQueryResultListItem queryResultListItem = new ReportQueryResultListItem();
            List<JAXBElement<?>> jaxbFields = this.createShellJAXBElementList(reportItems, result);
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        return response;
    }

    public List<JAXBElement<?>> createShellJAXBElementList(List<ReportItem> reportItems, Object record) {
        if (reportItems == null || reportItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList jaxbElements = new ArrayList(reportItems.size());
        for (int index = 0; index < reportItems.size(); ++index) {
            ReportItem reportItem = reportItems.get(index);
            Object reportItemValue = record;
            if (record instanceof Object[]) {
                reportItemValue = ((Object[])record)[index];
            }
            if (reportItemValue == null) continue;
            JAXBElement element = new JAXBElement(new QName(reportItem.getName()), reportItemValue.getClass(), reportItemValue);
            jaxbElements.add(reportItem.getResultIndex(), element);
        }
        return jaxbElements;
    }

    private SimpleHomogeneousList populateSimpleHomogeneousList(Collection collection, String attributeName) {
        SimpleHomogeneousList simpleList = new SimpleHomogeneousList();
        ArrayList<JAXBElement> items = new ArrayList<JAXBElement>();
        for (Object collectionItem : collection) {
            if (PersistenceWeavedRest.class.isAssignableFrom(collectionItem.getClass())) continue;
            JAXBElement jaxbElement = new JAXBElement(new QName(attributeName), collectionItem.getClass(), collectionItem);
            items.add(jaxbElement);
        }
        simpleList.setItems(items);
        return simpleList;
    }

    private boolean containsDomainObjects(Object object) {
        Collection collection = (Collection)object;
        for (Object collectionItem : collection) {
            if (!PersistenceWeavedRest.class.isAssignableFrom(collectionItem.getClass())) continue;
            return true;
        }
        return false;
    }
}

