/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.URLArchive;

public class InMemoryArchive
extends URLArchive {
    private InputStream stream = null;

    private InMemoryArchive() {
        super(null, null);
        String persistenceFactoryResource = InMemoryArchive.class.getName().replace('.', '/') + ".class";
        URL myURL = InMemoryArchive.class.getClassLoader().getResource(persistenceFactoryResource);
        try {
            myURL = PersistenceUnitProcessor.computePURootURL((URL)myURL, (String)persistenceFactoryResource);
        }
        catch (IOException | URISyntaxException | ValidationException e) {
            e.printStackTrace();
        }
        this.rootURL = myURL;
    }

    public InMemoryArchive(InputStream stream) {
        this();
        this.stream = stream;
    }

    public InputStream getDescriptorStream() throws IOException {
        return this.stream;
    }

    public void close() {
        super.close();
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stream = null;
    }
}

