/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.registry.ConfigurationElementAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionPointAdapter;
import org.eclipse.pde.internal.runtime.registry.IBundleFolder;
import org.eclipse.pde.internal.runtime.registry.IBundleLibrary;
import org.eclipse.pde.internal.runtime.registry.IBundlePrerequisite;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class RegistryBrowserContentProvider
implements ITreeContentProvider {
    private Hashtable fPluginMap = new Hashtable();
    private boolean fShowRunning;
    public boolean isInExtensionSet;
    private TreeViewer fViewer;
    private int fPluginsTotal;

    public RegistryBrowserContentProvider(TreeViewer viewer, boolean showRunning) {
        this.fViewer = viewer;
        this.fShowRunning = showRunning;
        this.fPluginsTotal = 0;
    }

    protected PluginObjectAdapter createAdapter(Object object, int id) {
        if (id == 1) {
            return new ExtensionAdapter(object);
        }
        if (id == 2) {
            return new ExtensionPointAdapter(object);
        }
        return new PluginObjectAdapter(object);
    }

    protected Object[] createPluginFolders(Bundle bundle) {
        Object[] array = new Object[]{new BundleFolder(bundle, 0), new BundleFolder(bundle, 3), new BundleFolder(bundle, 4), new BundleFolder(bundle, 2), new BundleFolder(bundle, 1)};
        return array;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ExtensionAdapter) {
            return ((ExtensionAdapter)((Object)element)).getChildren();
        }
        this.isInExtensionSet = false;
        if (element instanceof ExtensionPointAdapter) {
            return ((ExtensionPointAdapter)((Object)element)).getChildren();
        }
        if (element instanceof ConfigurationElementAdapter) {
            return ((ConfigurationElementAdapter)((Object)element)).getChildren();
        }
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof Bundle) {
            Bundle bundle = (Bundle)element;
            Object[] folders = (Object[])this.fPluginMap.get(bundle.getSymbolicName());
            if (folders == null) {
                folders = this.createPluginFolders(bundle);
                this.fPluginMap.put(bundle.getSymbolicName(), folders);
            } else {
                ArrayList<Object> folderList = new ArrayList<Object>();
                int i = 0;
                while (i < folders.length) {
                    if (folders[i] != null && ((IBundleFolder)folders[i]).getChildren() != null || ((IBundleFolder)folders[i]).getFolderId() == 0) {
                        folderList.add(folders[i]);
                    }
                    ++i;
                }
                folders = folderList.toArray(new Object[folderList.size()]);
            }
            return folders;
        }
        if (element instanceof IBundleFolder) {
            IBundleFolder folder = (IBundleFolder)element;
            this.isInExtensionSet = folder.getFolderId() == 1;
            return ((IBundleFolder)element).getChildren();
        }
        if (element instanceof IConfigurationElement) {
            return ((IConfigurationElement)element).getChildren();
        }
        if (element instanceof Bundle[]) {
            PluginObjectAdapter[] bundles = this.getPlugins((Bundle[])element);
            this.fPluginsTotal = bundles.length;
            if (this.fShowRunning) {
                ArrayList<PluginObjectAdapter> resultList = new ArrayList<PluginObjectAdapter>();
                int i = 0;
                while (i < bundles.length) {
                    if (bundles[i].getObject() instanceof Bundle && ((Bundle)bundles[i].getObject()).getState() == 32) {
                        resultList.add(bundles[i]);
                    }
                    ++i;
                }
                return resultList.toArray(new Object[resultList.size()]);
            }
            return bundles;
        }
        return null;
    }

    public PluginObjectAdapter[] getPlugins(Bundle[] bundles) {
        ArrayList<PluginObjectAdapter> list = new ArrayList<PluginObjectAdapter>();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getHeaders().get("Fragment-Host") == null) {
                list.add(new PluginObjectAdapter(bundles[i]));
            }
            ++i;
        }
        return list.toArray(new PluginObjectAdapter[list.size()]);
    }

    private Object[] getFolderChildren(Bundle bundle, int id) {
        Object[] array = null;
        String bundleId = bundle.getSymbolicName();
        switch (id) {
            case 1: {
                array = Platform.getExtensionRegistry().getExtensions(bundleId);
                break;
            }
            case 2: {
                array = Platform.getExtensionRegistry().getExtensionPoints(bundleId);
                break;
            }
            case 3: {
                array = this.getManifestHeaderArray(bundle, "Require-Bundle");
                break;
            }
            case 4: {
                array = this.getManifestHeaderArray(bundle, "Bundle-ClassPath");
            }
        }
        Object[] result = null;
        if (array != null && array.length > 0) {
            result = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = this.createAdapter(array[i], id);
                ++i;
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setShowRunning(boolean showRunning) {
        this.fShowRunning = showRunning;
    }

    public boolean isShowRunning() {
        return this.fShowRunning;
    }

    public String getTitleSummary() {
        if (this.fViewer == null || this.fViewer.getTree() == null) {
            return NLS.bind((String)PDERuntimeMessages.RegistryView_titleSummary, (Object[])new String[]{"0", "0"});
        }
        return NLS.bind((String)PDERuntimeMessages.RegistryView_titleSummary, (Object[])new String[]{new Integer(this.fViewer.getTree().getItemCount()).toString(), new Integer(this.fPluginsTotal).toString()});
    }

    private Object[] getManifestHeaderArray(Bundle bundle, String headerKey) {
        ManifestElement[] elements;
        block7: {
            String libraries = (String)bundle.getHeaders().get(headerKey);
            elements = ManifestElement.parseHeader((String)headerKey, (String)libraries);
            if (elements != null) break block7;
            return null;
        }
        try {
            if (headerKey.equals("Bundle-ClassPath")) {
                Object[] array = new IBundleLibrary[elements.length];
                int i = 0;
                while (i < elements.length) {
                    array[i] = new BundleLibrary(elements[i]);
                    ++i;
                }
                return array;
            }
            if (headerKey.equals("Require-Bundle")) {
                Object[] array = new IBundlePrerequisite[elements.length];
                int i = 0;
                while (i < elements.length) {
                    array[i] = new BundlePrerequisite(elements[i]);
                    ++i;
                }
                return array;
            }
        }
        catch (BundleException bundleException) {}
        return null;
    }

    class BundleFolder
    implements IBundleFolder {
        private int id;
        private Bundle bundle;

        public BundleFolder(Bundle pd, int id) {
            this.bundle = pd;
            this.id = id;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public Object[] getChildren() {
            return RegistryBrowserContentProvider.this.getFolderChildren(this.bundle, this.id);
        }

        public int getFolderId() {
            return this.id;
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    class BundleLibrary
    implements IBundleLibrary {
        private ManifestElement underlyingElement;

        public BundleLibrary(ManifestElement element) {
            this.underlyingElement = element;
        }

        public String getLibrary() {
            return this.underlyingElement.getValue();
        }
    }

    class BundlePrerequisite
    implements IBundlePrerequisite {
        private ManifestElement underlyingElement;

        public BundlePrerequisite(ManifestElement element) {
            this.underlyingElement = element;
        }

        public ManifestElement getPrerequisite() {
            return this.underlyingElement;
        }

        public boolean isExported() {
            String visibility = this.underlyingElement.getDirective("visibility");
            return "reexport".equals(visibility);
        }

        public String getLabel() {
            String version = this.underlyingElement.getAttribute("bundle-version");
            String value = this.underlyingElement.getValue();
            if (version == null) {
                return value;
            }
            if (Character.isDigit(version.charAt(0))) {
                version = String.valueOf('(') + version + ')';
            }
            return String.valueOf(value) + ' ' + version;
        }
    }
}

