/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.sqltools.common.ui.util.TableLayoutComposite;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoDialog;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilesConnectionInfoDialog
extends ConnectionInfoDialog {
    private IFile[] _files = null;
    private Object[] _results = null;
    private CheckboxTableViewer fTableViewer = null;
    private ViewerSorter nameSorter = new FileConnectionInfoSorter(1);
    private ViewerSorter nameSorterReverse = new FileConnectionInfoSorter(-1);
    private ViewerSorter vendorSorter = new FileConnectionInfoSorter(2);
    private ViewerSorter vendorSorterReverse = new FileConnectionInfoSorter(-2);
    private ViewerSorter profileSorter = new FileConnectionInfoSorter(3);
    private ViewerSorter profileSorterReverse = new FileConnectionInfoSorter(-3);
    private ViewerSorter dbSorter = new FileConnectionInfoSorter(4);
    private ViewerSorter dbSorterReverse = new FileConnectionInfoSorter(-4);
    private Button _upButton;
    private Button _downButton;

    public FilesConnectionInfoDialog(Shell parentShell, ISQLEditorConnectionInfo connInfo, boolean overridePrompt, IFile[] files, String title) {
        super(parentShell, connInfo, overridePrompt, title);
        this._files = files;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createOuterArea(parent);
        this.createFilesArea(composite);
        this.createConnectionArea(composite);
        return composite;
    }

    private void setSortColumn(SelectionEvent e, boolean sortType) {
        TableColumn sortColumn = (TableColumn)e.getSource();
        this.fTableViewer.getTable().setSortColumn(sortColumn);
        this.fTableViewer.getTable().setSortDirection(sortType ? 128 : 1024);
        this.fTableViewer.getTable().redraw();
        this.setOrderedFiles();
        this.checkUpDownStatus();
    }

    private void setOrderedFiles() {
        IFile[] newFiles = new IFile[this._files.length];
        Table table = this.fTableViewer.getTable();
        TableItem[] allItems = table.getItems();
        int count = 0;
        if (allItems != null && allItems.length > 0) {
            block0: for (int i = 0; i < allItems.length; ++i) {
                String fileName = ((IFile)allItems[i].getData()).getFullPath().toString();
                for (int j = 0; j < this._files.length; ++j) {
                    String tmpFileName = this._files[j].getFullPath().toString();
                    if (!fileName.equals(tmpFileName)) continue;
                    newFiles[count] = this._files[j];
                    ++count;
                    continue block0;
                }
            }
        }
        this._files = newFiles;
        this.fTableViewer.setInput((Object)this._files);
        this.fTableViewer.refresh();
    }

    protected void createFilesArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.ConnectionInfoDialog_file_conn_info);
        TableLayoutComposite tableComposite = new TableLayoutComposite(composite, 0);
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = this.convertHeightInCharsToPixels(15);
        tableComposite.setLayoutData((Object)data);
        Table table = new Table((Composite)tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.FilesConnectionInfoDialog_column_name);
        int minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_name);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean sortType = true;

            public void widgetSelected(SelectionEvent e) {
                this.sortType = !this.sortType;
                FilesConnectionInfoDialog.this.fTableViewer.setSorter(this.sortType ? FilesConnectionInfoDialog.this.nameSorter : FilesConnectionInfoDialog.this.nameSorterReverse);
                FilesConnectionInfoDialog.this.setSortColumn(e, this.sortType);
            }
        });
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.FilesConnectionInfoDialog_column_type);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_type);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean sortType = true;

            public void widgetSelected(SelectionEvent e) {
                this.sortType = !this.sortType;
                FilesConnectionInfoDialog.this.fTableViewer.setSorter(this.sortType ? FilesConnectionInfoDialog.this.vendorSorter : FilesConnectionInfoDialog.this.vendorSorterReverse);
                FilesConnectionInfoDialog.this.setSortColumn(e, this.sortType);
            }
        });
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.FilesConnectionInfoDialog_column_profile);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_profile);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        column3.addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean sortType = true;

            public void widgetSelected(SelectionEvent e) {
                this.sortType = !this.sortType;
                FilesConnectionInfoDialog.this.fTableViewer.setSorter(this.sortType ? FilesConnectionInfoDialog.this.profileSorter : FilesConnectionInfoDialog.this.profileSorterReverse);
                FilesConnectionInfoDialog.this.setSortColumn(e, this.sortType);
            }
        });
        TableColumn column4 = new TableColumn(table, 0);
        column4.setAlignment(0x1000000);
        column4.setText(Messages.FilesConnectionInfoDialog_column_database);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_database);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        column4.addSelectionListener((SelectionListener)new SelectionAdapter(){
            boolean sortType = true;

            public void widgetSelected(SelectionEvent e) {
                this.sortType = !this.sortType;
                FilesConnectionInfoDialog.this.fTableViewer.setSorter(this.sortType ? FilesConnectionInfoDialog.this.dbSorter : FilesConnectionInfoDialog.this.dbSorterReverse);
                FilesConnectionInfoDialog.this.setSortColumn(e, this.sortType);
            }
        });
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FileConnectionInfoLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new FileConnectionInfoContentProvider());
        this.fTableViewer.setComparator(null);
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilesConnectionInfoDialog.this.checkOK();
            }
        });
        this.fTableViewer.setInput((Object)this._files);
        this.fTableViewer.setAllChecked(true);
        this.fTableViewer.getControl().addMouseTrackListener((MouseTrackListener)new TooltipPresenter());
        this.addSelectionButtons(composite);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.fTableViewer.setAllChecked(true);
                FilesConnectionInfoDialog.this.checkOK();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.fTableViewer.setAllChecked(false);
                FilesConnectionInfoDialog.this.checkOK();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        this._upButton = this.createButton(buttonComposite, 1024, Messages.UP_TITLE, false);
        this._downButton = this.createButton(buttonComposite, 1024, Messages.DOWN_TITLE, false);
        this._upButton.setEnabled(false);
        this._downButton.setEnabled(false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.moveButtonAction(true);
                FilesConnectionInfoDialog.this.checkOK();
                FilesConnectionInfoDialog.this.checkUpDownStatus();
            }
        };
        this._upButton.addSelectionListener((SelectionListener)listener);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.moveButtonAction(false);
                FilesConnectionInfoDialog.this.checkOK();
                FilesConnectionInfoDialog.this.checkUpDownStatus();
            }
        };
        this._downButton.addSelectionListener((SelectionListener)listener);
        this.fTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.checkUpDownStatus();
            }
        });
    }

    protected void checkUpDownStatus() {
        int selectionCount = this.fTableViewer.getTable().getSelectionCount();
        if (selectionCount > 0) {
            if (this.getSelectionStartIndex() > 0) {
                this._upButton.setEnabled(true);
            } else {
                this._upButton.setEnabled(false);
            }
            if (this.getSelectionEndIndex() < this._files.length - 1) {
                this._downButton.setEnabled(true);
            } else {
                this._downButton.setEnabled(false);
            }
        } else {
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(false);
        }
    }

    private int getSelectionStartIndex() {
        Table table = this.fTableViewer.getTable();
        int start = 0;
        TableItem[] selectionItems = table.getSelection();
        if (selectionItems != null && selectionItems.length > 0) {
            for (int i = 0; i < this._files.length; ++i) {
                String firstSelectedFileName;
                String fileName = this._files[i].getFullPath().toString();
                if (!fileName.equals(firstSelectedFileName = ((IFile)selectionItems[0].getData()).getFullPath().toString())) continue;
                start = i;
                break;
            }
        }
        return start;
    }

    private int getSelectionEndIndex() {
        Table table = this.fTableViewer.getTable();
        int end = this._files.length - 1;
        TableItem[] selectionItems = table.getSelection();
        if (selectionItems != null && selectionItems.length > 0) {
            for (int i = 0; i < this._files.length; ++i) {
                String lastSelectedFileName;
                String fileName = this._files[i].getFullPath().toString();
                if (!fileName.equals(lastSelectedFileName = ((IFile)selectionItems[selectionItems.length - 1].getData()).getFullPath().toString())) continue;
                end = i;
                break;
            }
        }
        return end;
    }

    private void moveButtonAction(boolean isOrderUp) {
        this.fTableViewer.getTable().setSortColumn(null);
        this.fTableViewer.getTable().setSortDirection(0);
        this.fTableViewer.setSorter(null);
        IFile[] newFiles = new IFile[this._files.length];
        int start = this.getSelectionStartIndex();
        int end = this.getSelectionEndIndex();
        int count = 0;
        if (isOrderUp) {
            int i;
            if (start == 0) {
                return;
            }
            for (i = 0; i < start - 1; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
            for (i = start; i <= end; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
            newFiles[count] = this._files[start - 1];
            ++count;
            for (i = end + 1; i < this._files.length; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
        } else {
            int i;
            if (end == this._files.length - 1) {
                return;
            }
            for (i = 0; i < start; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
            newFiles[count] = this._files[end + 1];
            ++count;
            for (i = start; i <= end; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
            for (i = end + 2; i < this._files.length; ++i) {
                newFiles[count] = this._files[i];
                ++count;
            }
        }
        this._files = newFiles;
        this.fTableViewer.setInput((Object)this._files);
        this.fTableViewer.refresh();
    }

    protected boolean checkOK() {
        boolean enabled;
        boolean bl = enabled = this._group.canFinish() && this.fTableViewer.getCheckedElements() != null && this.fTableViewer.getCheckedElements().length > 0;
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
        return enabled;
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    protected void okPressed() {
        this._results = this.fTableViewer.getCheckedElements();
        super.okPressed();
    }

    public Object[] getCheckedFiles() {
        return this._results;
    }

    private class TooltipPresenter
    extends MouseTrackAdapter {
        private TooltipPresenter() {
        }

        public void mouseHover(MouseEvent e) {
            if (FilesConnectionInfoDialog.this.fTableViewer != null && !FilesConnectionInfoDialog.this.fTableViewer.getControl().isDisposed()) {
                Table table = (Table)e.widget;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null && item.getData() != null) {
                    String tooltip = ((IFile)item.getData()).getFullPath().makeRelative().toString();
                    table.setToolTipText(tooltip);
                } else {
                    table.setToolTipText(null);
                }
            }
        }
    }

    private class FileConnectionInfoContentProvider
    implements IStructuredContentProvider {
        private FileConnectionInfoContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (Object[])input;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class FileConnectionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileConnectionInfoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFile file = (IFile)element;
            ISQLEditorConnectionInfo connInfo = SQLFileUtil.getConnectionInfo(file);
            switch (columnIndex) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return connInfo.getDatabaseVendorDefinitionId().toString();
                }
                case 2: {
                    return connInfo.getConnectionProfileName();
                }
                case 3: {
                    return connInfo.getDatabaseName();
                }
            }
            return "";
        }
    }

    private class FileConnectionInfoSorter
    extends ViewerSorter {
        public static final int NAME = 1;
        public static final int VENDOR = 2;
        public static final int PROFILE_NAME = 3;
        public static final int DATABASE_NAME = 4;
        public static final String EMPTY_STRING = "";
        private int sortType;

        public FileConnectionInfoSorter(int sortOrder) {
            this.sortType = sortOrder;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IFile f1 = (IFile)e1;
            IFile f2 = (IFile)e2;
            ISQLEditorConnectionInfo connInfo1 = SQLFileUtil.getConnectionInfo(f1);
            ISQLEditorConnectionInfo connInfo2 = SQLFileUtil.getConnectionInfo(f2);
            if (connInfo1 == null || connInfo2 == null) {
                return 0;
            }
            switch (this.sortType) {
                case 1: {
                    String fName2;
                    String fName1 = f1.getName();
                    if (fName1 == null) {
                        fName1 = EMPTY_STRING;
                    }
                    if ((fName2 = f2.getName()) == null) {
                        fName2 = EMPTY_STRING;
                    }
                    return fName1.compareTo(fName2);
                }
                case -1: {
                    String fName2;
                    String fName1 = f1.getName();
                    if (fName1 == null) {
                        fName1 = EMPTY_STRING;
                    }
                    if ((fName2 = f2.getName()) == null) {
                        fName2 = EMPTY_STRING;
                    }
                    return fName2.compareTo(fName1);
                }
                case 2: {
                    String vender1 = EMPTY_STRING;
                    if (connInfo1.getDatabaseVendorDefinitionId() != null) {
                        vender1 = connInfo1.getDatabaseVendorDefinitionId().toString();
                    }
                    String vender2 = EMPTY_STRING;
                    if (connInfo2.getDatabaseVendorDefinitionId() != null) {
                        vender2 = connInfo2.getDatabaseVendorDefinitionId().toString();
                    }
                    return vender1.compareTo(vender2);
                }
                case -2: {
                    String vender1 = EMPTY_STRING;
                    if (connInfo1.getDatabaseVendorDefinitionId() != null) {
                        vender1 = connInfo1.getDatabaseVendorDefinitionId().toString();
                    }
                    String vender2 = EMPTY_STRING;
                    if (connInfo2.getDatabaseVendorDefinitionId() != null) {
                        vender2 = connInfo2.getDatabaseVendorDefinitionId().toString();
                    }
                    return vender2.compareTo(vender1);
                }
                case 3: {
                    String profile2;
                    String profile1 = connInfo1.getConnectionProfileName();
                    if (profile1 == null) {
                        profile1 = EMPTY_STRING;
                    }
                    if ((profile2 = connInfo2.getConnectionProfileName()) == null) {
                        profile2 = EMPTY_STRING;
                    }
                    return profile1.compareTo(profile2);
                }
                case -3: {
                    String profile2;
                    String profile1 = connInfo1.getConnectionProfileName();
                    if (profile1 == null) {
                        profile1 = EMPTY_STRING;
                    }
                    if ((profile2 = connInfo2.getConnectionProfileName()) == null) {
                        profile2 = EMPTY_STRING;
                    }
                    return profile2.compareTo(profile1);
                }
                case 4: {
                    String dbName2;
                    String dbName1 = connInfo1.getDatabaseName();
                    if (dbName1 == null) {
                        dbName1 = EMPTY_STRING;
                    }
                    if ((dbName2 = connInfo2.getDatabaseName()) == null) {
                        dbName2 = EMPTY_STRING;
                    }
                    return dbName1.compareTo(dbName2);
                }
                case -4: {
                    String dbName2;
                    String dbName1 = connInfo1.getDatabaseName();
                    if (dbName1 == null) {
                        dbName1 = EMPTY_STRING;
                    }
                    if ((dbName2 = connInfo2.getDatabaseName()) == null) {
                        dbName2 = EMPTY_STRING;
                    }
                    return dbName2.compareTo(dbName1);
                }
            }
            return 0;
        }
    }
}

