/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.config;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.InsecureCertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class UaTcpStackClientConfigBuilder {
    private String endpointUrl;
    private EndpointDescription endpoint;
    private KeyPair keyPair;
    private X509Certificate certificate;
    private X509Certificate[] certificateChain;
    private CertificateValidator certificateValidator = new InsecureCertificateValidator();
    private LocalizedText applicationName = LocalizedText.english((String)"client application name not configured");
    private String applicationUri = "client application uri not configured";
    private String productUri = "client product uri not configured";
    private ChannelConfig channelConfig = ChannelConfig.DEFAULT;
    private UInteger channelLifetime = Unsigned.uint((int)3600000);
    private ExecutorService executor;
    private NioEventLoopGroup eventLoop;
    private HashedWheelTimer wheelTimer;
    private UInteger acknowledgeTimeout = Unsigned.uint((int)5000);

    public UaTcpStackClientConfigBuilder setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    public UaTcpStackClientConfigBuilder setEndpoint(EndpointDescription endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public UaTcpStackClientConfigBuilder setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public UaTcpStackClientConfigBuilder setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public UaTcpStackClientConfigBuilder setCertificateChain(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public UaTcpStackClientConfigBuilder setCertificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public UaTcpStackClientConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public UaTcpStackClientConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public UaTcpStackClientConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public UaTcpStackClientConfigBuilder setChannelConfig(ChannelConfig channelConfig) {
        this.channelConfig = channelConfig;
        return this;
    }

    public UaTcpStackClientConfigBuilder setChannelLifetime(UInteger channelLifetime) {
        this.channelLifetime = channelLifetime;
        return this;
    }

    public UaTcpStackClientConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public UaTcpStackClientConfigBuilder setEventLoop(NioEventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public UaTcpStackClientConfigBuilder setWheelTimer(HashedWheelTimer wheelTimer) {
        this.wheelTimer = wheelTimer;
        return this;
    }

    public UaTcpStackClientConfigBuilder setAcknowledgeTimeout(UInteger acknowledgeTimeout) {
        this.acknowledgeTimeout = acknowledgeTimeout;
        return this;
    }

    public UaTcpStackClientConfig build() {
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        if (this.eventLoop == null) {
            this.eventLoop = Stack.sharedEventLoop();
        }
        if (this.wheelTimer == null) {
            this.wheelTimer = Stack.sharedWheelTimer();
        }
        return new UaTcpStackClientConfigImpl(this.endpointUrl, this.endpoint, this.keyPair, this.certificate, this.certificateChain, this.certificateValidator, this.applicationName, this.applicationUri, this.productUri, this.channelConfig, this.channelLifetime, this.executor, this.eventLoop, this.wheelTimer, this.acknowledgeTimeout);
    }

    public static class UaTcpStackClientConfigImpl
    implements UaTcpStackClientConfig {
        private final String endpointUrl;
        private final EndpointDescription endpoint;
        private final KeyPair keyPair;
        private final X509Certificate certificate;
        private final X509Certificate[] certificateChain;
        private final CertificateValidator certificateValidator;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final ChannelConfig channelConfig;
        private final UInteger channelLifetime;
        private final ExecutorService executor;
        private final NioEventLoopGroup eventLoop;
        private final HashedWheelTimer wheelTimer;
        private final UInteger acknowledgeTimeout;

        public UaTcpStackClientConfigImpl(@Nullable String endpointUrl, @Nullable EndpointDescription endpoint, @Nullable KeyPair keyPair, @Nullable X509Certificate certificate, @Nullable X509Certificate[] certificateChain, CertificateValidator certificateValidator, LocalizedText applicationName, String applicationUri, String productUri, ChannelConfig channelConfig, UInteger channelLifetime, ExecutorService executor, NioEventLoopGroup eventLoop, HashedWheelTimer wheelTimer, UInteger acknowledgeTimeout) {
            this.endpointUrl = endpointUrl;
            this.endpoint = endpoint;
            this.keyPair = keyPair;
            this.certificate = certificate;
            this.certificateChain = certificateChain;
            this.certificateValidator = certificateValidator;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.channelConfig = channelConfig;
            this.channelLifetime = channelLifetime;
            this.executor = executor;
            this.eventLoop = eventLoop;
            this.wheelTimer = wheelTimer;
            this.acknowledgeTimeout = acknowledgeTimeout;
        }

        @Override
        public Optional<String> getEndpointUrl() {
            return Optional.ofNullable(this.endpointUrl);
        }

        @Override
        public Optional<EndpointDescription> getEndpoint() {
            return Optional.ofNullable(this.endpoint);
        }

        @Override
        public Optional<KeyPair> getKeyPair() {
            return Optional.ofNullable(this.keyPair);
        }

        @Override
        public Optional<X509Certificate> getCertificate() {
            return Optional.ofNullable(this.certificate);
        }

        @Override
        public Optional<X509Certificate[]> getCertificateChain() {
            if (this.certificateChain != null) {
                return Optional.of(this.certificateChain);
            }
            if (this.certificate != null) {
                return Optional.of(new X509Certificate[]{this.certificate});
            }
            return Optional.empty();
        }

        @Override
        public CertificateValidator getCertificateValidator() {
            return this.certificateValidator;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public ChannelConfig getChannelConfig() {
            return this.channelConfig;
        }

        @Override
        public UInteger getChannelLifetime() {
            return this.channelLifetime;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public NioEventLoopGroup getEventLoop() {
            return this.eventLoop;
        }

        @Override
        public HashedWheelTimer getWheelTimer() {
            return this.wheelTimer;
        }

        @Override
        public UInteger getAcknowledgeTimeout() {
            return this.acknowledgeTimeout;
        }
    }
}

