/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.ChannelInactiveEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.events.InitializeSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ServiceFaultEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Closing;
import org.eclipse.milo.opcua.sdk.client.session.states.Initializing;
import org.eclipse.milo.opcua.sdk.client.session.states.Reactivating;
import org.eclipse.milo.opcua.sdk.client.session.states.Reinitializing;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Active
extends AbstractSessionState
implements SessionState {
    private OpcUaSession session;
    private CompletableFuture<OpcUaSession> sessionFuture;

    public OpcUaSession getSession() {
        return this.session;
    }

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onExternalTransition(Fsm fsm, SessionState prev, Event event) {
        fsm.getClient().getStackClient().getChannelFuture().thenAccept(secureChannel -> {
            Channel channel = secureChannel.getChannel();
            if (channel.pipeline().get(InactivityHandler.class) == null) {
                channel.pipeline().addLast(new ChannelHandler[]{new InactivityHandler(fsm)});
            }
        });
        if (prev instanceof Initializing || prev instanceof Reinitializing) {
            if (event instanceof InitializeSuccessEvent) {
                InitializeSuccessEvent e = (InitializeSuccessEvent)event;
                this.session = e.getSession();
                this.sessionFuture = e.getSessionFuture();
            }
        } else if (prev instanceof Reactivating && event instanceof ReactivateSuccessEvent) {
            ReactivateSuccessEvent e = (ReactivateSuccessEvent)event;
            this.session = e.getSession();
            this.sessionFuture = e.getSessionFuture();
        }
        fsm.getClient().getSubscriptionManager().startPublishing();
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            FutureUtils.complete(e.getSessionFuture()).with(this.sessionFuture);
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event e) {
        if (e instanceof CloseSessionEvent) {
            CompletableFuture<Unit> closeFuture = ((CloseSessionEvent)e).getCloseFuture();
            Active.closeSessionAsync(fsm, this.session, closeFuture, this.sessionFuture);
            return new Closing();
        }
        if (e instanceof ChannelInactiveEvent) {
            Reactivating reactivating = new Reactivating();
            Active.reactivateSessionAsync(fsm, this.session, reactivating.getSessionFuture());
            return reactivating;
        }
        if (e instanceof ServiceFaultEvent) {
            CompletableFuture disconnected = new CompletableFuture();
            fsm.getClient().getStackClient().getChannelFuture().whenComplete((c, ex) -> {
                if (c != null) {
                    Channel channel = c.getChannel();
                    channel.pipeline().remove(InactivityHandler.class);
                    channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> disconnected.complete(Unit.VALUE)));
                } else {
                    disconnected.complete(Unit.VALUE);
                }
            });
            Reactivating reactivating = new Reactivating();
            disconnected.whenComplete((u, ex) -> Active.reactivateSessionAsync(fsm, this.session, reactivating.getSessionFuture()));
            return reactivating;
        }
        return this;
    }

    private static class InactivityHandler
    extends ChannelInboundHandlerAdapter {
        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private final Fsm fsm;

        InactivityHandler(Fsm fsm) {
            this.fsm = fsm;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.logger.debug("[local={}, remote={}] channelInactive()", (Object)ctx.channel().localAddress(), (Object)ctx.channel().remoteAddress());
            this.fsm.getClient().getConfig().getExecutor().execute(() -> this.fsm.fireEvent(new ChannelInactiveEvent()));
            super.channelInactive(ctx);
        }
    }
}

