/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelConstructionTest
extends Arquillian {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @Test
    public void componentsTest() {
        Components c = this.processConstructible(Components.class);
        String callbackKey = "myCallback";
        Callback callbackValue = this.createConstructibleInstance(Callback.class);
        this.checkSameObject(c, c.addCallback("myCallback", callbackValue));
        this.checkMapEntry(c.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)c.getCallbacks().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeCallback("myCallback");
        Assert.assertEquals((int)c.getCallbacks().size(), (int)0, (String)"The map is expected to be empty.");
        String callbackKey2 = "myCallbackKey2";
        Callback callbackValue2 = this.createConstructibleInstance(Callback.class);
        c.setCallbacks(Collections.singletonMap("myCallbackKey2", callbackValue2));
        this.checkMapEntry(c.getCallbacks(), "myCallbackKey2", callbackValue2);
        Assert.assertEquals((int)c.getCallbacks().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addCallback("myCallback", callbackValue));
        this.checkMapEntry(c.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)c.getCallbacks().size(), (int)2, (String)"The map is expected to contain two entries.");
        Callback otherCallbackValue = this.createConstructibleInstance(Callback.class);
        this.checkMapImmutable(c, Components::getCallbacks, "otherCallback", otherCallbackValue);
        this.checkNullValueInAdd(() -> ((Components)c).getCallbacks(), (arg_0, arg_1) -> ((Components)c).addCallback(arg_0, arg_1), "someCallback", callbackValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(c, c.addExample("myExample", exampleValue));
        this.checkMapEntry(c.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)c.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeExample("myExample");
        Assert.assertEquals((int)c.getExamples().size(), (int)0, (String)"The map is expected to be empty.");
        Example otherExampleValue = this.createConstructibleInstance(Example.class);
        String exampleKey2 = "myExampleKey2";
        Example exampleValue2 = this.createConstructibleInstance(Example.class);
        c.setExamples(Collections.singletonMap("myExampleKey2", exampleValue2));
        this.checkMapEntry(c.getExamples(), "myExampleKey2", exampleValue2);
        Assert.assertEquals((int)c.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addExample("myExample", exampleValue));
        this.checkMapEntry(c.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)c.getExamples().size(), (int)2, (String)"The map is expected to contain two entries.");
        this.checkMapImmutable(c, Components::getExamples, "otherExample", otherExampleValue);
        this.checkNullValueInAdd(() -> ((Components)c).getExamples(), (arg_0, arg_1) -> ((Components)c).addExample(arg_0, arg_1), "someExample", exampleValue);
        String headerKey = "myHeader";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(c, c.addHeader("myHeader", headerValue));
        this.checkMapEntry(c.getHeaders(), "myHeader", headerValue);
        Assert.assertEquals((int)c.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeHeader("myHeader");
        Assert.assertEquals((int)c.getHeaders().size(), (int)0, (String)"The map is expected to be empty.");
        Header otherHeaderValue = this.createConstructibleInstance(Header.class);
        String headerKey2 = "myHeaderKey2";
        Header headerValue2 = this.createConstructibleInstance(Header.class);
        c.setHeaders(Collections.singletonMap("myHeaderKey2", headerValue2));
        this.checkMapEntry(c.getHeaders(), "myHeaderKey2", headerValue2);
        Assert.assertEquals((int)c.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addHeader("myHeader", headerValue));
        this.checkMapEntry(c.getHeaders(), "myHeader", headerValue);
        Assert.assertEquals((int)c.getHeaders().size(), (int)2, (String)"The map is expected to contain two entries.");
        this.checkMapImmutable(c, Components::getHeaders, "otherHeader", otherHeaderValue);
        this.checkNullValueInAdd(() -> ((Components)c).getHeaders(), (arg_0, arg_1) -> ((Components)c).addHeader(arg_0, arg_1), "some-header", headerValue);
        String linkKey = "myLink";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(c, c.addLink("myLink", linkValue));
        this.checkMapEntry(c.getLinks(), "myLink", linkValue);
        Assert.assertEquals((int)c.getLinks().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeLink("myLink");
        Assert.assertEquals((int)c.getLinks().size(), (int)0, (String)"The map is expected to be empty.");
        Link otherLinkValue = this.createConstructibleInstance(Link.class);
        String linkKey2 = "myLinkKey2";
        Link linkValue2 = this.createConstructibleInstance(Link.class);
        c.setLinks(Collections.singletonMap("myLinkKey2", linkValue2));
        this.checkMapEntry(c.getLinks(), "myLinkKey2", linkValue2);
        Assert.assertEquals((int)c.getLinks().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addLink("myLink", linkValue));
        this.checkMapEntry(c.getLinks(), "myLink", linkValue);
        Assert.assertEquals((int)c.getLinks().size(), (int)2, (String)"The map is expected to contain two entries.");
        this.checkMapImmutable(c, Components::getLinks, "otherLink", otherLinkValue);
        this.checkNullValueInAdd(() -> ((Components)c).getLinks(), (arg_0, arg_1) -> ((Components)c).addLink(arg_0, arg_1), "someLink", linkValue);
        String parameterKey = "myParameter";
        Parameter parameterValue = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(c, c.addParameter("myParameter", parameterValue));
        this.checkMapEntry(c.getParameters(), "myParameter", parameterValue);
        Assert.assertEquals((int)c.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        c.removeParameter("myParameter");
        Assert.assertEquals((int)c.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        this.checkNullValueInAdd(() -> ((Components)c).getParameters(), (arg_0, arg_1) -> ((Components)c).addParameter(arg_0, arg_1), "someParameter", parameterValue);
        String parameterKey2 = "myParameterKey2";
        Parameter parameterValue2 = this.createConstructibleInstance(Parameter.class);
        c.setParameters(Collections.singletonMap("myParameterKey2", parameterValue2));
        this.checkMapEntry(c.getParameters(), "myParameterKey2", parameterValue2);
        Assert.assertEquals((int)c.getParameters().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addParameter("myParameter", parameterValue));
        this.checkMapEntry(c.getParameters(), "myParameter", parameterValue);
        Assert.assertEquals((int)c.getParameters().size(), (int)2, (String)"The map is expected to contain two entries.");
        Parameter otherParameterValue = this.createConstructibleInstance(Parameter.class);
        this.checkMapImmutable(c, Components::getParameters, "otherParameter", otherParameterValue);
        String requestBodyKey = "myRequestBody";
        RequestBody requestBodyValue = this.createConstructibleInstance(RequestBody.class);
        this.checkSameObject(c, c.addRequestBody("myRequestBody", requestBodyValue));
        this.checkMapEntry(c.getRequestBodies(), "myRequestBody", requestBodyValue);
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeRequestBody("myRequestBody");
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)0, (String)"The map is expected to be empty.");
        String requestBodyKey2 = "myRequestBodyKey2";
        RequestBody requestBodyValue2 = this.createConstructibleInstance(RequestBody.class);
        c.setRequestBodies(Collections.singletonMap("myRequestBodyKey2", requestBodyValue2));
        this.checkMapEntry(c.getRequestBodies(), "myRequestBodyKey2", requestBodyValue2);
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addRequestBody("myRequestBody", requestBodyValue));
        this.checkMapEntry(c.getRequestBodies(), "myRequestBody", requestBodyValue);
        Assert.assertEquals((int)c.getRequestBodies().size(), (int)2, (String)"The map is expected to contain two entries.");
        RequestBody otherRequestBodyValue = this.createConstructibleInstance(RequestBody.class);
        this.checkMapImmutable(c, Components::getRequestBodies, "otherRequestBody", otherRequestBodyValue);
        this.checkNullValueInAdd(() -> ((Components)c).getRequestBodies(), (arg_0, arg_1) -> ((Components)c).addRequestBody(arg_0, arg_1), "someRequestBody", requestBodyValue);
        String responseKey = "myResponse";
        APIResponse responseValue = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(c, c.addResponse("myResponse", responseValue));
        this.checkMapEntry(c.getResponses(), "myResponse", responseValue);
        Assert.assertEquals((int)c.getResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeResponse("myResponse");
        Assert.assertEquals((int)c.getResponses().size(), (int)0, (String)"The map is expected to be empty.");
        String responseKey2 = "myResponseKey2";
        APIResponse responseValue2 = this.createConstructibleInstance(APIResponse.class);
        c.setResponses(Collections.singletonMap("myResponseKey2", responseValue2));
        this.checkMapEntry(c.getResponses(), "myResponseKey2", responseValue2);
        Assert.assertEquals((int)c.getResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addResponse("myResponse", responseValue));
        this.checkMapEntry(c.getResponses(), "myResponse", responseValue);
        Assert.assertEquals((int)c.getResponses().size(), (int)2, (String)"The map is expected to contain two entries.");
        APIResponse otherAPIResponseValue = this.createConstructibleInstance(APIResponse.class);
        this.checkMapImmutable(c, Components::getResponses, "otherAPIResponse", otherAPIResponseValue);
        this.checkNullValueInAdd(() -> ((Components)c).getResponses(), (arg_0, arg_1) -> ((Components)c).addResponse(arg_0, arg_1), "someResponse", responseValue);
        String schemaKey = "mySchema";
        Schema schemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(c, c.addSchema("mySchema", schemaValue));
        this.checkMapEntry(c.getSchemas(), "mySchema", schemaValue);
        Assert.assertEquals((int)c.getSchemas().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeSchema("mySchema");
        Assert.assertEquals((int)c.getSchemas().size(), (int)0, (String)"The map is expected to be empty.");
        String schemaKey2 = "mySchemaKey2";
        Schema schemaValue2 = this.createConstructibleInstance(Schema.class);
        c.setSchemas(Collections.singletonMap("mySchemaKey2", schemaValue2));
        this.checkMapEntry(c.getSchemas(), "mySchemaKey2", schemaValue2);
        Assert.assertEquals((int)c.getSchemas().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addSchema("mySchema", schemaValue));
        this.checkMapEntry(c.getSchemas(), "mySchema", schemaValue);
        Assert.assertEquals((int)c.getSchemas().size(), (int)2, (String)"The map is expected to contain two entries.");
        Schema otherSchemaValue = this.createConstructibleInstance(Schema.class);
        this.checkMapImmutable(c, Components::getSchemas, "otherSchema", otherSchemaValue);
        this.checkNullValueInAdd(() -> ((Components)c).getSchemas(), (arg_0, arg_1) -> ((Components)c).addSchema(arg_0, arg_1), "someSchema", schemaValue);
        String securitySchemeKey = "mySecurityScheme";
        SecurityScheme securitySchemeValue = this.createConstructibleInstance(SecurityScheme.class);
        this.checkSameObject(c, c.addSecurityScheme("mySecurityScheme", securitySchemeValue));
        this.checkMapEntry(c.getSecuritySchemes(), "mySecurityScheme", securitySchemeValue);
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeSecurityScheme("mySecurityScheme");
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)0, (String)"The map is expected to be empty.");
        String securitySchemeKey2 = "mySecuritySchemeKey2";
        SecurityScheme securitySchemeValue2 = this.createConstructibleInstance(SecurityScheme.class);
        c.setSecuritySchemes(Collections.singletonMap("mySecuritySchemeKey2", securitySchemeValue2));
        this.checkMapEntry(c.getSecuritySchemes(), "mySecuritySchemeKey2", securitySchemeValue2);
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(c, c.addSecurityScheme("mySecurityScheme", securitySchemeValue));
        this.checkMapEntry(c.getSecuritySchemes(), "mySecurityScheme", securitySchemeValue);
        Assert.assertEquals((int)c.getSecuritySchemes().size(), (int)2, (String)"The map is expected to contain two entries.");
        SecurityScheme otherSecuritySchemeValue = this.createConstructibleInstance(SecurityScheme.class);
        this.checkMapImmutable(c, Components::getSecuritySchemes, "otherSecurityScheme", otherSecuritySchemeValue);
        this.checkNullValueInAdd(() -> ((Components)c).getSecuritySchemes(), (arg_0, arg_1) -> ((Components)c).addSecurityScheme(arg_0, arg_1), "someSecurityScheme", securitySchemeValue);
    }

    @Test
    public void externalDocumentationTest() {
        this.processConstructible(ExternalDocumentation.class);
    }

    @Test
    public void openAPITest() {
        OpenAPI o = this.processConstructible(OpenAPI.class);
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        sr.addScheme("BasicAuth");
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeSecurityRequirement(sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)0, (String)"The list is expected to be empty.");
        SecurityRequirement sr2 = this.createConstructibleInstance(SecurityRequirement.class);
        sr2.addScheme("OAuth2", "read");
        o.setSecurity(Collections.singletonList(sr2));
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getSecurity(), sr2);
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        Assert.assertEquals((int)o.getSecurity().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getSecurity(), sr);
        SecurityRequirement otherSecurityRequirementValue = this.createConstructibleInstance(SecurityRequirement.class);
        otherSecurityRequirementValue.addScheme("OAuth2", "admin");
        this.checkListImmutable(o, OpenAPI::getSecurity, otherSecurityRequirementValue);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeServer(s);
        Assert.assertEquals((int)o.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        Server s2 = this.createConstructibleInstance(Server.class);
        o.setServers(Collections.singletonList(s2));
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getServers(), s2);
        this.checkSameObject(o, o.addServer(s));
        Assert.assertEquals((int)o.getSecurity().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getServers(), s);
        Server otherServer = this.createConstructibleInstance(Server.class);
        this.checkListImmutable(o, OpenAPI::getServers, otherServer);
        Tag t = this.createConstructibleInstance(Tag.class);
        this.checkSameObject(o, o.addTag(t));
        this.checkListEntry(o.getTags(), t);
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeTag(t);
        Assert.assertEquals((int)o.getTags().size(), (int)0, (String)"The list is expected to be empty.");
        Tag t2 = this.createConstructibleInstance(Tag.class);
        o.setTags(Collections.singletonList(t2));
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getTags(), t2);
        this.checkSameObject(o, o.addTag(t));
        Assert.assertEquals((int)o.getSecurity().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getTags(), t);
        Tag otherTag = this.createConstructibleInstance(Tag.class);
        this.checkListImmutable(o, OpenAPI::getTags, otherTag);
    }

    @Test
    public void operationTest() {
        Operation o = this.processConstructible(Operation.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(o, o.addParameter(p));
        this.checkListEntry(o.getParameters(), p);
        Assert.assertEquals((int)o.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeParameter(p);
        Assert.assertEquals((int)o.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        Parameter p2 = this.createConstructibleInstance(Parameter.class);
        o.setParameters(Collections.singletonList(p2));
        Assert.assertEquals((int)o.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getParameters(), p2);
        this.checkSameObject(o, o.addParameter(p));
        Assert.assertEquals((int)o.getParameters().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getParameters(), p);
        Parameter otherParameter = this.createConstructibleInstance(Parameter.class);
        this.checkListImmutable(o, Operation::getParameters, otherParameter);
        SecurityRequirement sr = this.createConstructibleInstance(SecurityRequirement.class);
        sr.addScheme("OAuth2", Arrays.asList("read", "write"));
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        this.checkListEntry(o.getSecurity(), sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeSecurityRequirement(sr);
        Assert.assertEquals((int)o.getSecurity().size(), (int)0, (String)"The list is expected to be empty.");
        SecurityRequirement sr2 = this.createConstructibleInstance(SecurityRequirement.class);
        sr2.addScheme("ApiKey");
        o.setSecurity(Collections.singletonList(sr2));
        Assert.assertEquals((int)o.getSecurity().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getSecurity(), sr2);
        this.checkSameObject(o, o.addSecurityRequirement(sr));
        Assert.assertEquals((int)o.getSecurity().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getSecurity(), sr);
        SecurityRequirement otherSecurityRequirement = this.createConstructibleInstance(SecurityRequirement.class);
        otherSecurityRequirement.addScheme("BasicAuth");
        this.checkListImmutable(o, Operation::getSecurity, otherSecurityRequirement);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(o, o.addServer(s));
        this.checkListEntry(o.getServers(), s);
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeServer(s);
        Assert.assertEquals((int)o.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        Server s2 = this.createConstructibleInstance(Server.class);
        o.setServers(Collections.singletonList(s2));
        Assert.assertEquals((int)o.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getServers(), s2);
        this.checkSameObject(o, o.addServer(s));
        Assert.assertEquals((int)o.getServers().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getServers(), s);
        Server otherServer = this.createConstructibleInstance(Server.class);
        this.checkListImmutable(o, Operation::getServers, otherServer);
        String tag = new String("myTag");
        this.checkSameObject(o, o.addTag(tag));
        this.checkListEntry(o.getTags(), tag);
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        o.removeTag(tag);
        Assert.assertEquals((int)o.getTags().size(), (int)0, (String)"The list is expected to be empty.");
        String tag2 = new String("myTag2");
        o.setTags(Collections.singletonList(tag2));
        Assert.assertEquals((int)o.getTags().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(o.getTags(), tag2);
        this.checkSameObject(o, o.addTag(tag));
        Assert.assertEquals((int)o.getTags().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(o.getTags(), tag);
        String otherTag = new String("otherTag");
        this.checkListImmutable(o, Operation::getTags, otherTag);
        String callbackKey = "myCallback";
        Callback callbackValue = this.createConstructibleInstance(Callback.class);
        this.checkSameObject(o, o.addCallback("myCallback", callbackValue));
        this.checkMapEntry(o.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)o.getCallbacks().size(), (int)1, (String)"The map is expected to contain one entry.");
        o.removeCallback("myCallback");
        Assert.assertEquals((int)o.getCallbacks().size(), (int)0, (String)"The map is expected to be empty.");
        String callbackKey2 = "myCallbackKey2";
        Callback callbackValue2 = this.createConstructibleInstance(Callback.class);
        o.setCallbacks(Collections.singletonMap("myCallbackKey2", callbackValue2));
        this.checkMapEntry(o.getCallbacks(), "myCallbackKey2", callbackValue2);
        Assert.assertEquals((int)o.getCallbacks().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(o, o.addCallback("myCallback", callbackValue));
        this.checkMapEntry(o.getCallbacks(), "myCallback", callbackValue);
        Assert.assertEquals((int)o.getCallbacks().size(), (int)2, (String)"The map is expected to contain two entries.");
        Callback otherCallback = this.createConstructibleInstance(Callback.class);
        this.checkMapImmutable(o, Operation::getCallbacks, "otherCallback", otherCallback);
        this.checkNullValueInAdd(() -> ((Operation)o).getCallbacks(), (arg_0, arg_1) -> ((Operation)o).addCallback(arg_0, arg_1), "someCallback", callbackValue);
    }

    @Test
    public void pathItemTest() {
        PathItem pi = this.processConstructible(PathItem.class);
        Parameter p = this.createConstructibleInstance(Parameter.class);
        this.checkSameObject(pi, pi.addParameter(p));
        this.checkListEntry(pi.getParameters(), p);
        Assert.assertEquals((int)pi.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        pi.removeParameter(p);
        Assert.assertEquals((int)pi.getParameters().size(), (int)0, (String)"The list is expected to be empty.");
        Parameter p2 = this.createConstructibleInstance(Parameter.class);
        pi.setParameters(Collections.singletonList(p2));
        Assert.assertEquals((int)pi.getParameters().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(pi.getParameters(), p2);
        this.checkSameObject(pi, pi.addParameter(p));
        Assert.assertEquals((int)pi.getParameters().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(pi.getParameters(), p);
        Parameter otherParameter = this.createConstructibleInstance(Parameter.class);
        this.checkListImmutable(pi, PathItem::getParameters, otherParameter);
        Server s = this.createConstructibleInstance(Server.class);
        this.checkSameObject(pi, pi.addServer(s));
        this.checkListEntry(pi.getServers(), s);
        Assert.assertEquals((int)pi.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        pi.removeServer(s);
        Assert.assertEquals((int)pi.getServers().size(), (int)0, (String)"The list is expected to be empty.");
        Server s2 = this.createConstructibleInstance(Server.class);
        pi.setServers(Collections.singletonList(s2));
        Assert.assertEquals((int)pi.getServers().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(pi.getServers(), s2);
        this.checkSameObject(pi, pi.addServer(s));
        Assert.assertEquals((int)pi.getServers().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(pi.getServers(), s);
        Server otherServer = this.createConstructibleInstance(Server.class);
        this.checkListImmutable(pi, PathItem::getServers, otherServer);
        Operation o1 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.GET(o1));
        this.checkSameObject(o1, pi.getGET());
        Operation o2 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.PUT(o2));
        this.checkSameObject(o2, pi.getPUT());
        Operation o3 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.POST(o3));
        this.checkSameObject(o3, pi.getPOST());
        Operation o4 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.DELETE(o4));
        this.checkSameObject(o4, pi.getDELETE());
        Operation o5 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.OPTIONS(o5));
        this.checkSameObject(o5, pi.getOPTIONS());
        Operation o6 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.HEAD(o6));
        this.checkSameObject(o6, pi.getHEAD());
        Operation o7 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.PATCH(o7));
        this.checkSameObject(o7, pi.getPATCH());
        Operation o8 = this.createConstructibleInstance(Operation.class);
        this.checkSameObject(pi, pi.TRACE(o8));
        this.checkSameObject(o8, pi.getTRACE());
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.GET, o1);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.PUT, o2);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.POST, o3);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.DELETE, o4);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.OPTIONS, o5);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.HEAD, o6);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.PATCH, o7);
        this.checkMapEntry(pi.getOperations(), PathItem.HttpMethod.TRACE, o8);
    }

    @Test
    public void pathsTest() {
        Paths p = this.processConstructible(Paths.class);
        String pathItemKey = "/myPathItem";
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        p.setPathItems(Collections.singletonMap("/myPathItem", pathItemValue));
        Assert.assertTrue((boolean)p.hasPathItem("/myPathItem"), (String)"/myPathItem is present in the map");
        Assert.assertEquals((int)p.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertSame((Object)p.getPathItem("/myPathItem"), (Object)pathItemValue, (String)"The value associated with the key: /myPathItem is expected to be the same one that was added.");
        this.checkMapEntry(p.getPathItems(), "/myPathItem", pathItemValue);
        String pathItemKey2 = "/myPathItem2";
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem2 is absent in the map");
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(p, p.addPathItem("/myPathItem2", pathItemValue2));
        Assert.assertTrue((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem2 is present in the map");
        Assert.assertEquals((int)p.getPathItems().size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertSame((Object)p.getPathItem("/myPathItem2"), (Object)pathItemValue2, (String)"The value associated with the key: /myPathItem2 is expected to be the same one that was added.");
        this.checkMapEntry(p.getPathItems(), "/myPathItem2", pathItemValue2);
        p.removePathItem("/myPathItem");
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem"), (String)"/myPathItem is absent in the map");
        Assert.assertEquals((int)p.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        p.removePathItem("/myPathItem2");
        Assert.assertFalse((boolean)p.hasPathItem("/myPathItem2"), (String)"/myPathItem is absent in the map");
        Assert.assertEquals((int)p.getPathItems().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        PathItem otherValue = this.createConstructibleInstance(PathItem.class);
        this.checkMapImmutable(p, Paths::getPathItems, "/otherPathItem", otherValue);
        this.checkNullValueInAdd(() -> ((Paths)p).getPathItems(), (arg_0, arg_1) -> ((Paths)p).addPathItem(arg_0, arg_1), "/other", otherValue);
    }

    @Test
    public void callbackTest() {
        Callback c = this.processConstructible(Callback.class);
        String pathItemKey = "myPathItem";
        PathItem pathItemValue = this.createConstructibleInstance(PathItem.class);
        c.setPathItems(Collections.singletonMap("myPathItem", pathItemValue));
        Assert.assertTrue((boolean)c.hasPathItem("myPathItem"), (String)"myPathItem is present in the map");
        Assert.assertEquals((int)c.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertSame((Object)c.getPathItem("myPathItem"), (Object)pathItemValue, (String)"The value associated with the key: myPathItem is expected to be the same one that was added.");
        this.checkMapEntry(c.getPathItems(), "myPathItem", pathItemValue);
        String pathItemKey2 = "myPathItem2";
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem2 is absent in the map");
        PathItem pathItemValue2 = this.createConstructibleInstance(PathItem.class);
        this.checkSameObject(c, c.addPathItem("myPathItem2", pathItemValue2));
        Assert.assertTrue((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem2 is present in the map");
        Assert.assertEquals((int)c.getPathItems().size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertSame((Object)c.getPathItem("myPathItem2"), (Object)pathItemValue2, (String)"The value associated with the key: myPathItem2 is expected to be the same one that was added.");
        this.checkMapEntry(c.getPathItems(), "myPathItem2", pathItemValue2);
        c.removePathItem("myPathItem");
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem"), (String)"myPathItem is absent in the map");
        Assert.assertEquals((int)c.getPathItems().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removePathItem("myPathItem2");
        Assert.assertFalse((boolean)c.hasPathItem("myPathItem2"), (String)"myPathItem is absent in the map");
        Assert.assertEquals((int)c.getPathItems().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        PathItem otherValue = this.createConstructibleInstance(PathItem.class);
        this.checkMapImmutable(c, Callback::getPathItems, "otherPathItem", otherValue);
        this.checkNullValueInAdd(() -> ((Callback)c).getPathItems(), (arg_0, arg_1) -> ((Callback)c).addPathItem(arg_0, arg_1), "other", otherValue);
    }

    @Test
    public void exampleTest() {
        this.processConstructible(Example.class);
    }

    @Test
    public void headerTest() {
        Header h = this.processConstructible(Header.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(h, h.addExample("myExample", exampleValue));
        this.checkMapEntry(h.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)h.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        h.removeExample("myExample");
        Assert.assertEquals((int)h.getExamples().size(), (int)0, (String)"The map is expected to be empty.");
        String exampleKey2 = "myExampleKey2";
        Example exampleValue2 = this.createConstructibleInstance(Example.class);
        h.setExamples(Collections.singletonMap("myExampleKey2", exampleValue2));
        this.checkMapEntry(h.getExamples(), "myExampleKey2", exampleValue2);
        Assert.assertEquals((int)h.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(h, h.addExample("myExample", exampleValue));
        this.checkMapEntry(h.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)h.getExamples().size(), (int)2, (String)"The map is expected to contain two entries.");
        Example otherExampleValue = this.createConstructibleInstance(Example.class);
        this.checkMapImmutable(h, Header::getExamples, "otherExample", otherExampleValue);
        this.checkNullValueInAdd(() -> ((Header)h).getExamples(), (arg_0, arg_1) -> ((Header)h).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void contactTest() {
        this.processConstructible(Contact.class);
    }

    @Test
    public void infoTest() {
        this.processConstructible(Info.class);
    }

    @Test
    public void licenseTest() {
        this.processConstructible(License.class);
    }

    @Test
    public void linkTest() {
        Link l = this.processConstructible(Link.class);
        String parameterKey = "myParameter";
        String parameterValue = "$request.parameter.id";
        this.checkSameObject(l, l.addParameter("myParameter", (Object)"$request.parameter.id"));
        this.checkMapEntry(l.getParameters(), "myParameter", "$request.parameter.id");
        Assert.assertEquals((int)l.getParameters().size(), (int)1, (String)"The map is expected to contain one entry.");
        l.removeParameter("myParameter");
        Assert.assertEquals((int)l.getParameters().size(), (int)0, (String)"The map is expected to be empty.");
        String parameterKey2 = "myParameterKey2";
        String parameterValue2 = "$request.parameter2.id";
        l.setParameters(Collections.singletonMap("myParameterKey2", "$request.parameter2.id"));
        this.checkMapEntry(l.getParameters(), "myParameterKey2", "$request.parameter2.id");
        Assert.assertEquals((int)l.getParameters().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(l, l.addParameter("myParameter", (Object)"$request.parameter.id"));
        this.checkMapEntry(l.getParameters(), "myParameter", "$request.parameter.id");
        Assert.assertEquals((int)l.getParameters().size(), (int)2, (String)"The map is expected to contain two entries.");
        Object otherExampleValue = new Object();
        this.checkMapImmutable(l, Link::getParameters, "otherParameter", otherExampleValue);
        this.checkNullValueInAdd(() -> ((Link)l).getParameters(), (arg_0, arg_1) -> ((Link)l).addParameter(arg_0, arg_1), "otherParameter", "$request.parameter.id");
    }

    @Test
    public void contentTest() {
        Content c = this.processConstructible(Content.class);
        String mediaTypeKey = "application/json";
        MediaType mediaTypeValue = this.createConstructibleInstance(MediaType.class);
        c.setMediaTypes(Collections.singletonMap("application/json", mediaTypeValue));
        Assert.assertTrue((boolean)c.hasMediaType("application/json"), (String)"application/json is present in the map");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertSame((Object)c.getMediaType("application/json"), (Object)mediaTypeValue, (String)"The value associated with the key: application/json is expected to be the same one that was added.");
        this.checkMapEntry(c.getMediaTypes(), "application/json", mediaTypeValue);
        String mediaTypeKey2 = "*/*";
        Assert.assertFalse((boolean)c.hasMediaType("*/*"), (String)"*/* is absent in the map");
        MediaType mediaTypeValue2 = this.createConstructibleInstance(MediaType.class);
        this.checkSameObject(c, c.addMediaType("*/*", mediaTypeValue2));
        Assert.assertTrue((boolean)c.hasMediaType("*/*"), (String)"*/* is present in the map");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertSame((Object)c.getMediaType("*/*"), (Object)mediaTypeValue2, (String)"The value associated with the key: */* is expected to be the same one that was added.");
        this.checkMapEntry(c.getMediaTypes(), "*/*", mediaTypeValue2);
        c.removeMediaType("application/json");
        Assert.assertFalse((boolean)c.hasMediaType("application/json"), (String)"application/json is absent in the map");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)1, (String)"The map is expected to contain one entry.");
        c.removeMediaType("*/*");
        Assert.assertFalse((boolean)c.hasMediaType("*/*"), (String)"application/json is absent in the map");
        Assert.assertEquals((int)c.getMediaTypes().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        MediaType otherValue = this.createConstructibleInstance(MediaType.class);
        this.checkMapImmutable(c, Content::getMediaTypes, "application/txt", otherValue);
    }

    @Test
    public void discriminatorTest() {
        Discriminator d = this.processConstructible(Discriminator.class);
        String key = "myKey";
        String value = new String("myValue");
        this.checkSameObject(d, d.addMapping("myKey", value));
        this.checkMapEntry(d.getMapping(), "myKey", value);
        Assert.assertEquals((int)d.getMapping().size(), (int)1, (String)"The map is expected to contain one entry.");
        d.removeMapping("myKey");
        Assert.assertEquals((int)d.getMapping().size(), (int)0, (String)"The map is expected to be empty.");
        String key2 = "myCallbackKey2";
        String value2 = new String("myValue2");
        d.setMapping(Collections.singletonMap("myCallbackKey2", value2));
        this.checkMapEntry(d.getMapping(), "myCallbackKey2", value2);
        Assert.assertEquals((int)d.getMapping().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(d, d.addMapping("myKey", value));
        this.checkMapEntry(d.getMapping(), "myKey", value);
        Assert.assertEquals((int)d.getMapping().size(), (int)2, (String)"The map is expected to contain two entries.");
        String otherValue = new String("otherValue");
        this.checkMapImmutable(d, Discriminator::getMapping, "otherValue", otherValue);
        this.checkNullValueInAdd(() -> ((Discriminator)d).getMapping(), (arg_0, arg_1) -> ((Discriminator)d).addMapping(arg_0, arg_1), "otherKey", value);
    }

    @Test
    public void encodingTest() {
        Encoding e = this.processConstructible(Encoding.class);
        String headerKey = "myHeaderKey";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(e, e.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(e.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)e.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        e.removeHeader("myHeaderKey");
        Assert.assertEquals((int)e.getHeaders().size(), (int)0, (String)"The map is expected to be empty.");
        String headerKey2 = "myHeaderKey2";
        Header headerValue2 = this.createConstructibleInstance(Header.class);
        e.setHeaders(Collections.singletonMap("myHeaderKey2", headerValue2));
        this.checkMapEntry(e.getHeaders(), "myHeaderKey2", headerValue2);
        Assert.assertEquals((int)e.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(e, e.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(e.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)e.getHeaders().size(), (int)2, (String)"The map is expected to contain two entries.");
        Header otherHeaderValue = this.createConstructibleInstance(Header.class);
        this.checkMapImmutable(e, Encoding::getHeaders, "otherHeader", otherHeaderValue);
        this.checkNullValueInAdd(() -> ((Encoding)e).getHeaders(), (arg_0, arg_1) -> ((Encoding)e).addHeader(arg_0, arg_1), "otherHeaderKey", headerValue);
    }

    @Test
    public void mediaTypeTest() {
        MediaType mt = this.processConstructible(MediaType.class);
        String encodingKey = "myEncoding";
        Encoding encodingValue = this.createConstructibleInstance(Encoding.class);
        this.checkSameObject(mt, mt.addEncoding("myEncoding", encodingValue));
        this.checkMapEntry(mt.getEncoding(), "myEncoding", encodingValue);
        Assert.assertEquals((int)mt.getEncoding().size(), (int)1, (String)"The map is expected to contain one entry.");
        mt.removeEncoding("myEncoding");
        Assert.assertEquals((int)mt.getEncoding().size(), (int)0, (String)"The map is expected to be empty.");
        String encodingKey2 = "myEncodingKey2";
        Encoding encodingValue2 = this.createConstructibleInstance(Encoding.class);
        mt.setEncoding(Collections.singletonMap("myEncodingKey2", encodingValue2));
        this.checkMapEntry(mt.getEncoding(), "myEncodingKey2", encodingValue2);
        Assert.assertEquals((int)mt.getEncoding().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(mt, mt.addEncoding("myEncoding", encodingValue));
        this.checkMapEntry(mt.getEncoding(), "myEncoding", encodingValue);
        Assert.assertEquals((int)mt.getEncoding().size(), (int)2, (String)"The map is expected to contain two entries.");
        Encoding otherEncodingValue = this.createConstructibleInstance(Encoding.class);
        this.checkMapImmutable(mt, MediaType::getEncoding, "otherEncoding", otherEncodingValue);
        this.checkNullValueInAdd(() -> ((MediaType)mt).getEncoding(), (arg_0, arg_1) -> ((MediaType)mt).addEncoding(arg_0, arg_1), "otherEncoding", encodingValue);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(mt, mt.addExample("myExample", exampleValue));
        this.checkMapEntry(mt.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)mt.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        mt.removeExample("myExample");
        Assert.assertEquals((int)mt.getExamples().size(), (int)0, (String)"The map is expected to be empty.");
        String exampleKey2 = "myExampleKey2";
        Example exampleValue2 = this.createConstructibleInstance(Example.class);
        mt.setExamples(Collections.singletonMap("myExampleKey2", exampleValue2));
        this.checkMapEntry(mt.getExamples(), "myExampleKey2", exampleValue2);
        Assert.assertEquals((int)mt.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(mt, mt.addExample("myExample", exampleValue));
        this.checkMapEntry(mt.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)mt.getExamples().size(), (int)2, (String)"The map is expected to contain two entries.");
        Example otherExampleValue = this.createConstructibleInstance(Example.class);
        this.checkMapImmutable(mt, MediaType::getExamples, "otherExample", otherExampleValue);
        this.checkNullValueInAdd(() -> ((MediaType)mt).getExamples(), (arg_0, arg_1) -> ((MediaType)mt).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void schemaTest() {
        Schema s = this.processConstructible(Schema.class);
        Schema ap = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.additionalPropertiesSchema(ap));
        this.checkSameObject(ap, s.getAdditionalPropertiesSchema());
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), null, (String)"AdditionalProperties (Boolean type) is expected to be null");
        this.checkSameObject(s, s.additionalPropertiesBoolean(Boolean.TRUE));
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), (Object)Boolean.TRUE, (String)"AdditionalProperties (Boolean type) is expected to be true");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        s.setAdditionalPropertiesBoolean(Boolean.FALSE);
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), (Object)Boolean.FALSE, (String)"AdditionalProperties (Boolean type) is expected to be false");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        s.setAdditionalPropertiesSchema(null);
        Assert.assertEquals((Object)s.getAdditionalPropertiesBoolean(), null, (String)"AdditionalProperties (Boolean type) is expected to be null");
        Assert.assertEquals((Object)s.getAdditionalPropertiesSchema(), null, (String)"AdditionalProperties (Schema type) is expected to be null");
        Schema allOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAllOf(allOf));
        this.checkListEntry(s.getAllOf(), allOf);
        Assert.assertEquals((int)s.getAllOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeAllOf(allOf);
        Assert.assertEquals((int)s.getAllOf().size(), (int)0, (String)"The list is expected to be empty.");
        Schema allOf2 = this.createConstructibleInstance(Schema.class);
        s.setAllOf(Collections.singletonList(allOf2));
        Assert.assertEquals((int)s.getAllOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(s.getAllOf(), allOf2);
        this.checkSameObject(s, s.addAllOf(allOf));
        Assert.assertEquals((int)s.getAllOf().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(s.getAllOf(), allOf);
        Schema otherAllOfValue = this.createConstructibleInstance(Schema.class);
        this.checkListImmutable(s, Schema::getAllOf, otherAllOfValue);
        Schema anyOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addAnyOf(anyOf));
        this.checkListEntry(s.getAnyOf(), anyOf);
        Assert.assertEquals((int)s.getAnyOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeAnyOf(anyOf);
        Assert.assertEquals((int)s.getAnyOf().size(), (int)0, (String)"The list is expected to be empty.");
        Schema anyOf2 = this.createConstructibleInstance(Schema.class);
        s.setAnyOf(Collections.singletonList(anyOf2));
        Assert.assertEquals((int)s.getAnyOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(s.getAnyOf(), anyOf2);
        this.checkSameObject(s, s.addAnyOf(anyOf));
        Assert.assertEquals((int)s.getAnyOf().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(s.getAnyOf(), anyOf);
        Schema otherAnyOfValue = this.createConstructibleInstance(Schema.class);
        this.checkListImmutable(s, Schema::getAnyOf, otherAnyOfValue);
        String enumeration = new String("enumValue");
        this.checkSameObject(s, s.addEnumeration((Object)enumeration));
        this.checkListEntry(s.getEnumeration(), enumeration);
        Assert.assertEquals((int)s.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeEnumeration((Object)enumeration);
        Assert.assertEquals((int)s.getEnumeration().size(), (int)0, (String)"The list is expected to be empty.");
        String enumeration2 = new String("enumValue2");
        s.setEnumeration(Collections.singletonList(enumeration2));
        Assert.assertEquals((int)s.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(s.getEnumeration(), enumeration2);
        this.checkSameObject(s, s.addEnumeration((Object)enumeration));
        Assert.assertEquals((int)s.getEnumeration().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(s.getEnumeration(), enumeration);
        String otherEnumerationValue = new String("otherValue");
        this.checkListImmutable(s, Schema::getEnumeration, otherEnumerationValue);
        Schema oneOf = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addOneOf(oneOf));
        this.checkListEntry(s.getOneOf(), oneOf);
        Assert.assertEquals((int)s.getOneOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeOneOf(oneOf);
        Assert.assertEquals((int)s.getOneOf().size(), (int)0, (String)"The list is expected to be empty.");
        Schema oneOf2 = this.createConstructibleInstance(Schema.class);
        s.setOneOf(Collections.singletonList(oneOf2));
        Assert.assertEquals((int)s.getOneOf().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(s.getOneOf(), oneOf2);
        this.checkSameObject(s, s.addOneOf(oneOf));
        Assert.assertEquals((int)s.getOneOf().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(s.getOneOf(), oneOf);
        Schema otherOneOfValue = this.createConstructibleInstance(Schema.class);
        this.checkListImmutable(s, Schema::getOneOf, otherOneOfValue);
        String propertySchemaKey = "myPropertySchemaKey";
        Schema propertySchemaValue = this.createConstructibleInstance(Schema.class);
        this.checkSameObject(s, s.addProperty("myPropertySchemaKey", propertySchemaValue));
        this.checkMapEntry(s.getProperties(), "myPropertySchemaKey", propertySchemaValue);
        Assert.assertEquals((int)s.getProperties().size(), (int)1, (String)"The map is expected to contain one entry.");
        s.removeProperty("myPropertySchemaKey");
        Assert.assertEquals((int)s.getProperties().size(), (int)0, (String)"The map is expected to be empty.");
        String propertySchemaKey2 = "myPropertySchemaKey2";
        Schema propertySchemaValue2 = this.createConstructibleInstance(Schema.class);
        s.setProperties(Collections.singletonMap("myPropertySchemaKey2", propertySchemaValue2));
        this.checkMapEntry(s.getProperties(), "myPropertySchemaKey2", propertySchemaValue2);
        Assert.assertEquals((int)s.getProperties().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(s, s.addProperty("myPropertySchemaKey", propertySchemaValue));
        this.checkMapEntry(s.getProperties(), "myPropertySchemaKey", propertySchemaValue);
        Assert.assertEquals((int)s.getProperties().size(), (int)2, (String)"The map is expected to contain two entries.");
        Schema otherPropertyValue = this.createConstructibleInstance(Schema.class);
        this.checkMapImmutable(s, Schema::getProperties, "otherPropertyKey", otherPropertyValue);
        this.checkNullValueInAdd(() -> ((Schema)s).getProperties(), (arg_0, arg_1) -> ((Schema)s).addProperty(arg_0, arg_1), "otherProperty", propertySchemaValue);
        String required = new String("required");
        this.checkSameObject(s, s.addRequired(required));
        this.checkListEntry(s.getRequired(), required);
        Assert.assertEquals((int)s.getRequired().size(), (int)1, (String)"The list is expected to contain one entry.");
        s.removeRequired(required);
        Assert.assertEquals((int)s.getRequired().size(), (int)0, (String)"The list is expected to be empty.");
        String required2 = new String("required2");
        s.setRequired(Collections.singletonList(required2));
        Assert.assertEquals((int)s.getRequired().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(s.getRequired(), required2);
        this.checkSameObject(s, s.addRequired(required));
        Assert.assertEquals((int)s.getRequired().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(s.getRequired(), required);
        String otherRequiredValue = new String("otherRequired");
        this.checkListImmutable(s, Schema::getEnumeration, otherRequiredValue);
    }

    @Test
    public void xmlTest() {
        this.processConstructible(XML.class);
    }

    @Test
    public void parameterTest() {
        Parameter p = this.processConstructible(Parameter.class);
        String exampleKey = "myExample";
        Example exampleValue = this.createConstructibleInstance(Example.class);
        this.checkSameObject(p, p.addExample("myExample", exampleValue));
        this.checkMapEntry(p.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)p.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        p.removeExample("myExample");
        Assert.assertEquals((int)p.getExamples().size(), (int)0, (String)"The map is expected to be empty.");
        String exampleKey2 = "myExampleKey2";
        Example exampleValue2 = this.createConstructibleInstance(Example.class);
        p.setExamples(Collections.singletonMap("myExampleKey2", exampleValue2));
        this.checkMapEntry(p.getExamples(), "myExampleKey2", exampleValue2);
        Assert.assertEquals((int)p.getExamples().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(p, p.addExample("myExample", exampleValue));
        this.checkMapEntry(p.getExamples(), "myExample", exampleValue);
        Assert.assertEquals((int)p.getExamples().size(), (int)2, (String)"The map is expected to contain two entries.");
        Example otherExampleValue = this.createConstructibleInstance(Example.class);
        this.checkMapImmutable(p, Parameter::getExamples, "otherExample", otherExampleValue);
        this.checkNullValueInAdd(() -> ((Parameter)p).getExamples(), (arg_0, arg_1) -> ((Parameter)p).addExample(arg_0, arg_1), "otherExample", exampleValue);
    }

    @Test
    public void requestBodyTest() {
        this.processConstructible(RequestBody.class);
    }

    @Test
    public void apiResponseTest() {
        APIResponse response = this.processConstructible(APIResponse.class);
        String headerKey = "myHeaderKey";
        Header headerValue = this.createConstructibleInstance(Header.class);
        this.checkSameObject(response, response.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(response.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)response.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        response.removeHeader("myHeaderKey");
        Assert.assertEquals((int)response.getHeaders().size(), (int)0, (String)"The map is expected to be empty.");
        String headerKey2 = "myHeaderKey2";
        Header headerValue2 = this.createConstructibleInstance(Header.class);
        response.setHeaders(Collections.singletonMap("myHeaderKey2", headerValue2));
        this.checkMapEntry(response.getHeaders(), "myHeaderKey2", headerValue2);
        Assert.assertEquals((int)response.getHeaders().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(response, response.addHeader("myHeaderKey", headerValue));
        this.checkMapEntry(response.getHeaders(), "myHeaderKey", headerValue);
        Assert.assertEquals((int)response.getHeaders().size(), (int)2, (String)"The map is expected to contain two entries.");
        Header otherHeaderValue = this.createConstructibleInstance(Header.class);
        this.checkMapImmutable(response, APIResponse::getHeaders, "otherHeader", otherHeaderValue);
        this.checkNullValueInAdd(() -> ((APIResponse)response).getHeaders(), (arg_0, arg_1) -> ((APIResponse)response).addHeader(arg_0, arg_1), "some-header", headerValue);
        String linkKey = "myLinkKey";
        Link linkValue = this.createConstructibleInstance(Link.class);
        this.checkSameObject(response, response.addLink("myLinkKey", linkValue));
        this.checkMapEntry(response.getLinks(), "myLinkKey", linkValue);
        Assert.assertEquals((int)response.getLinks().size(), (int)1, (String)"The map is expected to contain one entry.");
        response.removeLink("myLinkKey");
        Assert.assertEquals((int)response.getLinks().size(), (int)0, (String)"The map is expected to be empty.");
        Link otherLinkValue = this.createConstructibleInstance(Link.class);
        String linkKey2 = "myLinkKey2";
        Link linkValue2 = this.createConstructibleInstance(Link.class);
        response.setLinks(Collections.singletonMap("myLinkKey2", linkValue2));
        this.checkMapEntry(response.getLinks(), "myLinkKey2", linkValue2);
        Assert.assertEquals((int)response.getLinks().size(), (int)1, (String)"The map is expected to contain one entry.");
        this.checkSameObject(response, response.addLink("myLinkKey", linkValue));
        this.checkMapEntry(response.getLinks(), "myLinkKey", linkValue);
        Assert.assertEquals((int)response.getLinks().size(), (int)2, (String)"The map is expected to contain two entries.");
        this.checkMapImmutable(response, APIResponse::getLinks, "otherLink", otherLinkValue);
        this.checkNullValueInAdd(() -> ((APIResponse)response).getLinks(), (arg_0, arg_1) -> ((APIResponse)response).addLink(arg_0, arg_1), "someLinkKey", linkValue);
    }

    @Test
    public void apiResponsesTest() {
        APIResponses responses = this.processConstructible(APIResponses.class);
        String responseKey = "200";
        APIResponse pathItemValue = this.createConstructibleInstance(APIResponse.class);
        responses.setAPIResponses(Collections.singletonMap("200", pathItemValue));
        Assert.assertTrue((boolean)responses.hasAPIResponse("200"), (String)"200 is present in the map");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertSame((Object)responses.getAPIResponse("200"), (Object)pathItemValue, (String)"The value associated with the key: 200 is expected to be the same one that was added.");
        this.checkMapEntry(responses.getAPIResponses(), "200", pathItemValue);
        String responseKey2 = "4XX";
        Assert.assertFalse((boolean)responses.hasAPIResponse("4XX"), (String)"4XX is absent in the map");
        APIResponse pathItemValue2 = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(responses, responses.addAPIResponse("4XX", pathItemValue2));
        Assert.assertTrue((boolean)responses.hasAPIResponse("4XX"), (String)"4XX is present in the map");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertSame((Object)responses.getAPIResponse("4XX"), (Object)pathItemValue2, (String)"The value associated with the key: 4XX is expected to be the same one that was added.");
        this.checkMapEntry(responses.getAPIResponses(), "4XX", pathItemValue2);
        responses.removeAPIResponse("200");
        Assert.assertFalse((boolean)responses.hasAPIResponse("200"), (String)"200 is absent in the map");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        responses.removeAPIResponse("4XX");
        Assert.assertFalse((boolean)responses.hasAPIResponse("4XX"), (String)"200 is absent in the map");
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        APIResponse otherValue = this.createConstructibleInstance(APIResponse.class);
        this.checkMapImmutable(responses, APIResponses::getAPIResponses, "500", otherValue);
        Assert.assertNull((Object)responses.getDefaultValue(), (String)"No default value expected.");
        String responseKey3 = "default";
        APIResponse responseValue3 = this.createConstructibleInstance(APIResponse.class);
        this.checkSameObject(responses, responses.addAPIResponse("default", responseValue3));
        this.checkMapEntry(responses.getAPIResponses(), "default", responseValue3);
        this.checkSameObject(responseValue3, responses.getDefaultValue());
        Assert.assertEquals((int)responses.getAPIResponses().size(), (int)1, (String)"The map is expected to contain one entry.");
        responses.setDefaultValue(null);
        Assert.assertNull((Object)responses.getAPIResponse("default"), (String)"No default value expected.");
        Assert.assertNull((Object)responses.getDefaultValue(), (String)"No default value expected.");
        APIResponse responseValue4 = this.createConstructibleInstance(APIResponse.class);
        responses.setDefaultValue(responseValue4);
        this.checkMapEntry(responses.getAPIResponses(), "default", responseValue4);
        this.checkSameObject(responseValue4, responses.getDefaultValue());
        this.checkNullValueInAdd(() -> ((APIResponses)responses).getAPIResponses(), (arg_0, arg_1) -> ((APIResponses)responses).addAPIResponse(arg_0, arg_1), "4XX", otherValue);
    }

    @Test
    public void oAuthFlowTest() {
        OAuthFlow o = this.processConstructible(OAuthFlow.class);
        String key = "myKey";
        String value = new String("myValue");
        o.setScopes(Collections.singletonMap("myKey", value));
        Map scopes = o.getScopes();
        Assert.assertEquals((int)scopes.size(), (int)1, (String)"The list is expected to contain one entry.");
        Assert.assertTrue((boolean)scopes.containsKey("myKey"), (String)"The map is expected to contain a 'myKey' entry.");
        Assert.assertEquals((String)((String)scopes.get("myKey")), (String)value, (String)"The value corresponding to the 'myKey' is wrong.");
        o.setScopes((Map)null);
        Assert.assertNull((Object)o.getScopes(), (String)"The value is expected to be null.");
    }

    @Test
    public void oAuthFlowsTest() {
        this.processConstructible(OAuthFlows.class);
    }

    @Test
    public void securityRequirementTest() {
        SecurityRequirement sr = this.processConstructible(SecurityRequirement.class);
        String schemeKey = "myScheme";
        ArrayList schemeValue = new ArrayList();
        sr.setSchemes(Collections.singletonMap("myScheme", schemeValue));
        Assert.assertTrue((boolean)sr.hasScheme("myScheme"), (String)"myScheme is present in the map");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertSame((Object)sr.getScheme("myScheme"), schemeValue, (String)"The value associated with the key: myScheme is expected to be the same one that was added.");
        this.checkMapEntry(sr.getSchemes(), "myScheme", schemeValue);
        String schemeKey2 = "myScheme2";
        Assert.assertFalse((boolean)sr.hasScheme("myScheme2"), (String)"myScheme2 is absent in the map");
        ArrayList schemeValue2 = new ArrayList();
        this.checkSameObject(sr, sr.addScheme("myScheme2", schemeValue2));
        Assert.assertTrue((boolean)sr.hasScheme("myScheme2"), (String)"myScheme2 is present in the map");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)2, (String)"The map is expected to contain two entries.");
        Assert.assertSame((Object)sr.getScheme("myScheme2"), schemeValue2, (String)"The value associated with the key: myScheme2 is expected to be the same one that was added.");
        this.checkMapEntry(sr.getSchemes(), "myScheme2", schemeValue2);
        sr.removeScheme("myScheme");
        Assert.assertFalse((boolean)sr.hasScheme("myScheme"), (String)"myScheme is absent in the map");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)1, (String)"The map is expected to contain one entry.");
        sr.removeScheme("myScheme2");
        Assert.assertFalse((boolean)sr.hasScheme("myScheme2"), (String)"myScheme is absent in the map");
        Assert.assertEquals((int)sr.getSchemes().size(), (int)0, (String)"The map is expected to contain 0 entries.");
        ArrayList otherValue = new ArrayList();
        this.checkMapImmutable(sr, SecurityRequirement::getSchemes, "otherScheme", otherValue);
        String schemeKey3 = "myScheme3";
        sr.addScheme("myScheme3", (String)null);
        Assert.assertTrue((boolean)sr.hasScheme("myScheme3"), (String)"Expected myScheme3 to be present");
        List schemeValue3 = Collections.emptyList();
        Assert.assertEquals((Collection)sr.getScheme("myScheme3"), schemeValue3, (String)"The value associated with the key: myScheme3 is expected to be an empty list.");
        String schemeKey4 = "myScheme3";
        sr.addScheme("myScheme3", (List)null);
        Assert.assertTrue((boolean)sr.hasScheme("myScheme3"), (String)"Expected myScheme3 to be present");
        List schemeValue4 = Collections.emptyList();
        Assert.assertEquals((Collection)sr.getScheme("myScheme3"), schemeValue4, (String)"The value associated with the key: myScheme3 is expected to be an empty list.");
    }

    @Test
    public void securitySchemeTest() {
        this.processConstructible(SecurityScheme.class);
    }

    @Test
    public void serverTest() {
        Server server = this.processConstructible(Server.class);
        ServerVariable sv1 = this.createConstructibleInstance(ServerVariable.class);
        server.setVariables(Collections.singletonMap("var1", sv1));
        Map variables = server.getVariables();
        Assert.assertEquals((int)variables.size(), (int)1, (String)"The map is expected to contain one entry.");
        Assert.assertTrue((boolean)variables.containsKey("var1"), (String)"The map is expected to contain a 'var1' entry.");
        Assert.assertEquals(variables.get("var1"), (Object)sv1, (String)"The value corresponding to the 'var1' is wrong.");
        this.checkMapEntry(server.getVariables(), "var1", sv1);
        ServerVariable sv2 = this.createConstructibleInstance(ServerVariable.class);
        this.checkMapImmutable(server, Server::getVariables, "sv2", sv2);
        ServerVariable sv3 = this.createConstructibleInstance(ServerVariable.class);
        this.checkNullValueInAdd(() -> ((Server)server).getVariables(), (arg_0, arg_1) -> ((Server)server).addVariable(arg_0, arg_1), "sv3", sv3);
        server.setVariables((Map)null);
        Assert.assertNull((Object)server.getVariables(), (String)"The value is expected to be null.");
    }

    @Test
    public void serverVariableTest() {
        ServerVariable sv = this.processConstructible(ServerVariable.class);
        String enumeration = new String("enumValue");
        this.checkSameObject(sv, sv.addEnumeration(enumeration));
        this.checkListEntry(sv.getEnumeration(), enumeration);
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        sv.removeEnumeration(enumeration);
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)0, (String)"The list is expected to be empty.");
        String enumeration2 = new String("enumValue2");
        sv.setEnumeration(Collections.singletonList(enumeration2));
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)1, (String)"The list is expected to contain one entry.");
        this.checkListEntry(sv.getEnumeration(), enumeration2);
        this.checkSameObject(sv, sv.addEnumeration(enumeration));
        Assert.assertEquals((int)sv.getEnumeration().size(), (int)2, (String)"The list is expected to contain two entries.");
        this.checkListEntry(sv.getEnumeration(), enumeration);
        String otherEnumerationValue = new String("otherValue");
        this.checkListImmutable(sv, ServerVariable::getEnumeration, otherEnumerationValue);
    }

    @Test
    public void tagTest() {
        this.processConstructible(Tag.class);
    }

    private <T extends Constructible> T processConstructible(Class<T> clazz) {
        Object o = this.createConstructibleInstance(clazz);
        if (o instanceof Extensible && Extensible.class.isAssignableFrom(clazz)) {
            this.processExtensible((Extensible)o);
        }
        if (o instanceof Reference && Reference.class.isAssignableFrom(clazz)) {
            this.processReference((Reference)o);
        }
        Map<String, Property> properties = this.collectProperties(clazz);
        properties.values().stream().filter(p -> p.isComplete()).forEach(p -> this.processConstructibleProperty((Constructible)o, (Property)p, clazz));
        return o;
    }

    private <T extends Constructible> T createConstructibleInstance(Class<T> clazz) {
        Constructible o1 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o1, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o1), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Constructible o2 = OASFactory.createObject(clazz);
        Assert.assertNotNull((Object)o2, (String)("The return value of OASFactory.createObject(" + clazz.getName() + ") must not be null."));
        Assert.assertTrue((boolean)clazz.isInstance(o2), (String)("The return value of OASFactory.createObject() is expected to be an instance of: " + clazz.getName()));
        Assert.assertNotSame((Object)o2, (Object)o1, (String)("OASFactory.createObject(" + clazz.getName() + ") is expected to create a new object on each invocation."));
        return (T)o1;
    }

    private void processExtensible(Extensible<?> e) {
        String extensionName1 = "x-" + e.getClass().getName() + "-1";
        Object obj1 = new Object();
        String extensionName2 = "x-" + e.getClass().getName() + "-2";
        Object obj2 = new Object();
        e.addExtension(extensionName1, obj1);
        e.addExtension(extensionName2, obj2);
        Map map = e.getExtensions();
        Assert.assertEquals((int)map.size(), (int)2, (String)"The extensions map is expected to contain two entries.");
        Assert.assertTrue((boolean)map.containsKey(extensionName1), (String)("The extensions map is expected to contain the key: " + extensionName1));
        Assert.assertTrue((boolean)map.containsKey(extensionName2), (String)("The extensions map is expected to contain the key: " + extensionName2));
        Assert.assertSame(map.get(extensionName1), (Object)obj1, (String)("The value associated with the key: " + extensionName1 + " is expected to be the same one that was added."));
        Assert.assertSame(map.get(extensionName2), (Object)obj2, (String)("The value associated with the key: " + extensionName2 + " is expected to be the same one that was added."));
        e.removeExtension(extensionName1);
        Assert.assertEquals((int)e.getExtensions().size(), (int)1, (String)"The extensions map is expected to contain one entry.");
        HashMap newMap = new HashMap();
        e.setExtensions(newMap);
        Map map2 = e.getExtensions();
        Assert.assertEquals((int)map2.size(), (int)0, (String)"The extensions map is expected to contain no entries.");
        Assert.assertEquals((Map)map2, newMap, (String)"The return value of getExtensions() is expected to be the same value that was set.");
        Map<String, Integer> newOtherMap = Collections.singletonMap("x-test", 42);
        e.setExtensions(newOtherMap);
        Map map3 = e.getExtensions();
        Assert.assertEquals((int)map3.size(), (int)1, (String)"The extensions map is expected to contain one entry.");
        Assert.assertEquals((Map)map3, newOtherMap, (String)"The return value of getExtensions() is expected to be the same value that was set.");
        e.addExtension(extensionName1, obj1);
        Assert.assertEquals((int)e.getExtensions().size(), (int)2, (String)"The extensions map is expected to contain two entries.");
        this.checkMapImmutable(e, Extensible::getExtensions, "x-other", new Object());
    }

    private void processReference(Reference<?> r) {
        String myRef1 = this.createReference(r, "myRef1");
        r.setRef(myRef1);
        Assert.assertEquals((String)r.getRef(), (String)myRef1, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef2";
            String myRef2 = this.createReference(r, "myRef2");
            r.setRef("myRef2");
            Assert.assertEquals((String)r.getRef(), (String)myRef2, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
        String myRef3 = this.createReference(r, "myRef3");
        Reference self = r.ref(myRef3);
        Assert.assertSame((Object)self, r, (String)"The return value of ref() is expected to return the current instance.");
        Assert.assertEquals((String)r.getRef(), (String)myRef3, (String)"The return value of getRef() is expected to be equal to the value that was set.");
        if (!(r instanceof PathItem)) {
            String shortName = "myRef4";
            String myRef4 = this.createReference(r, "myRef4");
            Reference self2 = r.ref("myRef4");
            Assert.assertSame((Object)self2, r, (String)"The return value of ref() is expected to return the current instance.");
            Assert.assertEquals((String)r.getRef(), (String)myRef4, (String)"The return value of getRef() is expected to be a fully expanded name.");
        }
    }

    private void processConstructibleProperty(Constructible o, Property p, Class<?> enclosingInterface) {
        Object value1 = this.getInstanceOf(p.getType(), false);
        p.invokeSetter(o, value1);
        if (!(p.isPrimitive() || p.isCompatible(Map.class) || p.isCompatible(List.class))) {
            Assert.assertSame((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
        } else {
            Assert.assertEquals((Object)p.invokeGetter(o), (Object)value1, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
        }
        if (p.hasBuilder()) {
            Object value2 = this.getInstanceOf(p.getType(), true);
            Object self = p.invokeBuilder(o, value2);
            Assert.assertSame((Object)self, (Object)o, (String)("The return value of the builder method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            if (!(p.isPrimitive() || p.isCompatible(Map.class) || p.isCompatible(List.class))) {
                Assert.assertSame((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be the same as the value that was set."));
            } else {
                Assert.assertEquals((Object)p.invokeGetter(o), (Object)value2, (String)("The return value of the getter method for property \"" + p.getName() + "\" of interface \"" + enclosingInterface.getName() + "\" is expected to be equal to the value that was set."));
            }
        }
    }

    private Object getInstanceOf(Class<?> clazz, boolean alternateEnumValue) {
        if (Constructible.class.isAssignableFrom(clazz)) {
            return this.createConstructibleInstance(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            ?[] enumConstants = clazz.getEnumConstants();
            if (enumConstants != null && enumConstants.length > 0) {
                if (alternateEnumValue && enumConstants.length > 1) {
                    return enumConstants[1];
                }
                return enumConstants[0];
            }
        } else {
            if (clazz == List.class) {
                return new ArrayList();
            }
            if (clazz == Map.class) {
                return new HashMap();
            }
            if (clazz == String.class) {
                return new String("value");
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return new Boolean(true);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return new Byte(1);
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return new Short(1);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return new Integer(1);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return new Long(1L);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return new Float(1.0f);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return new Double(1.0);
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                return new Character('a');
            }
            if (clazz == BigInteger.class) {
                return new BigInteger("1");
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal("1.0");
            }
            if (clazz == Object.class) {
                return new String("object");
            }
        }
        return null;
    }

    private String createReference(Reference<?> r, String v) {
        StringBuilder sb = new StringBuilder();
        if (r instanceof APIResponse) {
            sb.append("#/components/responses/");
        } else if (r instanceof Callback) {
            sb.append("#/components/callbacks/");
        } else if (r instanceof Example) {
            sb.append("#/components/examples/");
        } else if (r instanceof Header) {
            sb.append("#/components/headers/");
        } else if (r instanceof Link) {
            sb.append("#/components/links/");
        } else if (r instanceof Parameter) {
            sb.append("#/components/parameters/");
        } else if (r instanceof PathItem) {
            sb.append("http://www.abc.def.ghi/");
        } else if (r instanceof RequestBody) {
            sb.append("#/components/requestBodies/");
        } else if (r instanceof Schema) {
            sb.append("#/components/schemas/");
        } else if (r instanceof SecurityScheme) {
            sb.append("#/components/securitySchemes/");
        }
        sb.append(v);
        return sb.toString();
    }

    private Map<String, Property> collectProperties(Class<?> clazz) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Method[] methods = clazz.getDeclaredMethods();
        Arrays.stream(methods).forEach(m -> {
            Class<?> returnType = m.getReturnType();
            int parameterCount = m.getParameterCount();
            String name = m.getName();
            if (returnType == clazz) {
                if (parameterCount == 1) {
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addBuilder((Method)m);
                    }
                }
            } else if (returnType == Void.TYPE) {
                if (name.startsWith("set") && parameterCount == 1) {
                    name = Introspector.decapitalize(name.substring(3));
                    Class<?> type = m.getParameterTypes()[0];
                    Property p = (Property)properties.get(name);
                    if (p == null) {
                        p = new Property(name, type);
                        properties.put(name, p);
                    }
                    if (p.isCompatible(type)) {
                        p.addSetter((Method)m);
                    }
                }
            } else if (name.startsWith("get") && parameterCount == 0) {
                name = Introspector.decapitalize(name.substring(3));
                Class<?> type = returnType;
                Property p = (Property)properties.get(name);
                if (p == null) {
                    p = new Property(name, type);
                    properties.put(name, p);
                }
                if (p.isCompatible(type)) {
                    p.addGetter((Method)m);
                }
            }
        });
        return properties;
    }

    private <K, T> void checkMapEntry(Map<K, T> map, K key, T value) {
        Assert.assertNotNull(map, (String)"The map must not be null.");
        Assert.assertTrue((boolean)map.containsKey(key), (String)("The map is expected to contain the key: " + key));
        Assert.assertSame(map.get(key), value, (String)("The value associated with the key: " + key + " is expected to be the same one that was added."));
    }

    private <O, K, T> void checkMapImmutable(O container, Function<O, Map<K, T>> mapGetter, K key, T otherValue) {
        Map<K, T> map = mapGetter.apply(container);
        Assert.assertNotNull(map, (String)"The map must not be null.");
        Assert.assertFalse((boolean)map.containsKey(key), (String)("The map is expected to not contain the key: " + key));
        int originalSize = map.size();
        try {
            map.put(key, otherValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<K, T> map2 = mapGetter.apply(container);
        Assert.assertNotNull(map2, (String)"The map must not be null.");
        Assert.assertFalse((boolean)map2.containsKey(key), (String)("The map is expected to not contain the key: " + key));
        Assert.assertEquals((int)map2.size(), (int)originalSize, (String)("The map is expected to have a size of " + originalSize));
    }

    private <O, T> void checkNullValueInAdd(Supplier<Map<String, T>> mapGetter, BiFunction<String, T, O> mapAdd, String key, T value) {
        try {
            mapAdd.apply(key, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to not contain the key: " + key));
        mapAdd.apply(key, (String)value);
        Assert.assertTrue((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to contain the key: " + key));
        try {
            mapAdd.apply(key, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)mapGetter.get().containsKey(key), (String)("The map is expected to contain the key: " + key));
    }

    private <T> void checkListEntry(List<T> list, T value) {
        Assert.assertNotNull(list, (String)"The list must not be null.");
        Assert.assertTrue((boolean)list.stream().anyMatch(v -> v == value), (String)("The list is expected to contain the value: " + value));
    }

    private <O, V> void checkListImmutable(O container, Function<O, List<V>> listGetter, V otherValue) {
        List<V> list = listGetter.apply(container);
        Assert.assertNotNull(list, (String)"The list must not be null.");
        Assert.assertFalse((boolean)list.contains(otherValue), (String)("The list is expected to not contain the value: " + otherValue));
        int originalSize = list.size();
        try {
            list.add(otherValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<V> map2 = listGetter.apply(container);
        Assert.assertNotNull(map2, (String)"The list must not be null.");
        Assert.assertFalse((boolean)map2.contains(otherValue), (String)("The list is expected to not contain the key: " + otherValue));
        Assert.assertEquals((int)map2.size(), (int)originalSize, (String)("The list is expected to have a size of " + originalSize));
    }

    private <T> void checkSameObject(T expected, T actual) {
        Assert.assertSame(actual, expected, (String)"Expecting same object.");
    }

    static final class Property {
        private final String name;
        private final Class<?> type;
        private Method getter;
        private Method setter;
        private Method builder;

        public Property(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public void addGetter(Method getter) {
            this.getter = getter;
        }

        public void addSetter(Method setter) {
            this.setter = setter;
        }

        public void addBuilder(Method builder) {
            this.builder = builder;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean hasBuilder() {
            return this.builder != null;
        }

        public Object invokeGetter(Object target) {
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of getter method \"" + this.getter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public void invokeSetter(Object target, Object value) {
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of setter method \"" + this.setter.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public Object invokeBuilder(Object target, Object value) {
            try {
                return this.builder.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Assert.fail((String)("Invocation of builder method \"" + this.builder.getName() + "\" failed: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }

        public boolean isCompatible(Class<?> type) {
            return this.type == type;
        }

        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        public boolean isComplete() {
            return this.getter != null && this.setter != null;
        }
    }
}

