/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.RestAssured;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.tck.utils.YamlToJsonConverterServlet;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class AppTestBase
extends Arquillian {
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9080;
    private static String serverUrl;
    private static String username;
    private static String password;
    private static Map<String, String> headers;

    @Deployment(name="proxy")
    public static WebArchive createProxy() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"proxy.war")).addClass(YamlToJsonConverterServlet.class)).addAsLibraries(new File[]{new File("./lib/httpclient-4.5.2.jar")})).addAsLibraries(new File[]{new File("./lib/httpcore-4.4.4.jar")})).addAsLibraries(new File[]{new File("./lib/jackson-core-2.8.6.jar")})).addAsLibraries(new File[]{new File("./lib/jackson-dataformat-yaml-2.8.6.jar")})).addAsLibraries(new File[]{new File("./lib/jackson-databind-2.8.6.jar")})).addAsLibraries(new File[]{new File("./lib/jackson-annotations-2.8.0.jar")})).addAsLibraries(new File[]{new File("./lib/snakeyaml-1.17.jar")})).addAsLibraries(new File[]{new File("./lib/commons-logging-1.2.jar")})).addAsLibraries(new File[]{new File("./lib/commons-lang3-3.4.jar")});
    }

    @BeforeClass
    public static void setUp() throws MalformedURLException {
        serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 9080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 9080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        username = System.getProperty("test.user");
        password = System.getProperty("test.pwd");
        if (username != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)username, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
        RestAssured.defaultParser = Parser.JSON;
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            serverUrl = "http://localhost:9080";
        }
        headers.put("x-tck-serverurl", serverUrl);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            headers.put("x-tck-username", username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            headers.put("x-tck-password", password);
        }
    }

    public ValidatableResponse callEndpoint(String type) {
        ValidatableResponse vr = "JSON".equals(type) ? (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(APPLICATION_JSON).when().get("/openapi", new Object[0])).then()).statusCode(200) : (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().headers(headers).when().get("/proxy", new Object[0])).then()).statusCode(200);
        return vr;
    }

    @DataProvider(name="formatProvider")
    public Object[][] provide() throws Exception {
        return new Object[][]{{"JSON"}, {"YAML"}};
    }

    static {
        headers = new HashMap<String, String>();
    }
}

