/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@Deprecated
@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Property Resource Shape", describes={"http://open-services.net/ns/core#Property"})
public final class Property
extends AbstractResource
implements Comparable<Property> {
    private static final QName PROPERTY_ALLOWED_VALUE = new QName("http://open-services.net/ns/core#", "allowedValue");
    private static final QName PROPERTY_DEFAULT_VALUE = new QName("http://open-services.net/ns/core#", "defaultValue");
    private final List<URI> range = new ArrayList<URI>();
    private URI allowedValuesRef;
    private String description;
    private Boolean hidden;
    private Integer maxSize;
    private Boolean memberProperty;
    private String name;
    private Occurs occurs;
    private Boolean readOnly;
    private Representation representation;
    private String title;
    private URI valueShape;
    private ValueType valueType;

    public Property() {
    }

    public Property(String name, Occurs occurs, ValueType valueType) {
        this();
        this.name = name;
        this.occurs = occurs;
        this.valueType = valueType;
    }

    public void addRange(URI range) {
        this.range.add(range);
    }

    @Override
    public int compareTo(Property o) {
        return this.name.compareTo(o.getName());
    }

    @OslcDescription(value="Resource with allowed values for the property being defined")
    @OslcName(value="allowedValues")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#allowedValues")
    @OslcRange(value={"http://open-services.net/ns/core#AllowedValues"})
    @OslcReadOnly
    @OslcTitle(value="Allowed Value Reference")
    @OslcValueShape(value="resourceShapes/allowedValues")
    public URI getAllowedValuesRef() {
        return this.allowedValuesRef;
    }

    public Object getDefaultValueObject() {
        return this.getExtendedProperties().get(PROPERTY_DEFAULT_VALUE);
    }

    @Deprecated
    public String getDefaultValue() {
        Object o = this.getExtendedProperties().get(PROPERTY_DEFAULT_VALUE);
        return o instanceof String ? (String)o : null;
    }

    @OslcDescription(value="Description of the property. SHOULD include only content that is valid and suitable inside an XHTML <div> element")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcReadOnly
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="For String properties only, specifies maximum characters allowed. If not set, then there is no maximum or maximum is specified elsewhere")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#maxSize")
    @OslcReadOnly
    @OslcTitle(value="Maximum Size")
    public Integer getMaxSize() {
        return this.maxSize;
    }

    @OslcDescription(value="Name of property being defined, i.e. second part of property's Prefixed Name")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#name")
    @OslcReadOnly
    @OslcTitle(value="Name")
    public String getName() {
        return this.name;
    }

    @OslcAllowedValue(value={"http://open-services.net/ns/core#Exactly-one", "http://open-services.net/ns/core#Zero-or-one", "http://open-services.net/ns/core#Zero-or-many", "http://open-services.net/ns/core#One-or-many"})
    @OslcDescription(value="MUST be either http://open-services.net/ns/core#Exactly-one, http://open-services.net/ns/core#Zero-or-one, http://open-services.net/ns/core#Zero-or-many or http://open-services.net/ns/core#One-or-many")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#occurs")
    @OslcReadOnly
    @OslcTitle(value="Occurs")
    public URI getOccurs() {
        if (this.occurs != null) {
            try {
                return new URI(this.occurs.toString());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @OslcDescription(value="For properties with a resource value-type, Providers MAY also specify the range of possible resource classes allowed, each specified by URI. The default range is http://open-services.net/ns/core#Any")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#range")
    @OslcReadOnly
    @OslcTitle(value="Ranges")
    public URI[] getRange() {
        return this.range.toArray(new URI[this.range.size()]);
    }

    @OslcAllowedValue(value={"http://open-services.net/ns/core#Reference", "http://open-services.net/ns/core#Inline", "http://open-services.net/ns/core#Either"})
    @OslcDescription(value="Should be http://open-services.net/ns/core#Reference, http://open-services.net/ns/core#Inline or http://open-services.net/ns/core#Either")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#representation")
    @OslcReadOnly
    @OslcTitle(value="Representation")
    public URI getRepresentation() {
        if (this.representation != null) {
            try {
                return new URI(this.representation.toString());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @OslcDescription(value="Title of the property. SHOULD include only content that is valid and suitable inside an XHTML <div> element")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="if the value-type is a resource type, then Property MAY provide a shape value to indicate the Resource Shape that applies to the resource")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#valueShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcReadOnly
    @OslcTitle(value="Value Shape")
    public URI getValueShape() {
        return this.valueShape;
    }

    @OslcAllowedValue(value={"http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/2001/XMLSchema#decimal", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#float", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", "http://open-services.net/ns/core#Resource", "http://open-services.net/ns/core#LocalResource", "http://open-services.net/ns/core#AnyResource"})
    @OslcDescription(value="See list of allowed values for oslc:valueType")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#valueType")
    @OslcReadOnly
    @OslcTitle(value="Value Type")
    public URI getValueType() {
        if (this.valueType != null) {
            try {
                return new URI(this.valueType.toString());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @OslcDescription(value="A hint that indicates that property MAY be hidden when presented in a user interface")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#hidden")
    @OslcReadOnly
    @OslcTitle(value="Hidden")
    public Boolean isHidden() {
        return this.hidden;
    }

    @OslcDescription(value="If set to true, this indicates that the property is a membership property, as described in the Query Syntax Specification: Member List Patterns. This is useful when the resource whose shape is being defined is viewed as a container of other resources. For example, look at the last example in Appendix B's RDF/XML Representation Examples: Specifying the shape of a query result, where blog:comment is defined as a membership property and comment that matches the query is returned as value of that property.")
    @OslcName(value="isMemberProperty")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#isMemberProperty")
    @OslcReadOnly
    @OslcTitle(value="Is Member Property")
    public Boolean isMemberProperty() {
        return this.memberProperty;
    }

    @OslcDescription(value="true if the property is read-only. If not set, or set to false, then the property is writable. Providers SHOULD declare a property read-only when changes to the value of that property will not be accepted on PUT. Consumers should note that the converse does not apply: Providers MAY reject a change to the value of a writable property.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#readOnly")
    @OslcReadOnly
    @OslcTitle(value="Read Only")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setAllowedValuesRef(URI allowedValuesRef) {
        this.allowedValuesRef = allowedValuesRef != null ? allowedValuesRef : null;
    }

    public void setDefaultValue(Object defaultValue) {
        if (defaultValue == null) {
            this.getExtendedProperties().remove(PROPERTY_DEFAULT_VALUE);
        } else {
            this.getExtendedProperties().put(PROPERTY_DEFAULT_VALUE, defaultValue);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public void setMemberProperty(Boolean memberProperty) {
        this.memberProperty = memberProperty;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOccurs(Occurs occurs) {
        this.occurs = occurs;
    }

    public void setOccurs(URI occurs) {
        this.occurs = occurs != null ? Occurs.fromString((String)occurs.toString()) : null;
    }

    public void setRange(URI[] ranges) {
        this.range.clear();
        if (ranges != null) {
            this.range.addAll(Arrays.asList(ranges));
        }
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public void setRepresentation(URI representation) {
        this.representation = representation != null ? Representation.fromString((String)representation.toString()) : null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValueShape(URI valueShape) {
        this.valueShape = valueShape;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setValueType(URI valueType) {
        this.valueType = valueType != null ? ValueType.fromString((String)valueType.toString()) : null;
    }

    public Collection<?> getAllowedValuesCollection() {
        Collection allowedValues = (Collection)this.getExtendedProperties().get(PROPERTY_ALLOWED_VALUE);
        if (allowedValues == null) {
            return Collections.emptyList();
        }
        return allowedValues;
    }

    public void setAllowedValuesCollection(Collection<?> values) {
        if (values == null) {
            this.getExtendedProperties().remove(PROPERTY_ALLOWED_VALUE);
        } else {
            this.getExtendedProperties().put(PROPERTY_ALLOWED_VALUE, values);
        }
    }

    @Deprecated
    public void addAllowedValue(String allowedValue) {
        ArrayList<String> newValues = new ArrayList<String>();
        Collection allowedValues = (Collection)this.getExtendedProperties().get(PROPERTY_ALLOWED_VALUE);
        if (allowedValues != null) {
            newValues.addAll(allowedValues);
        }
        newValues.add(allowedValue);
        this.setAllowedValuesCollection(newValues);
    }

    @Deprecated
    public String[] getAllowedValues() {
        ArrayList<String> stringValues = new ArrayList<String>();
        Collection values = (Collection)this.getExtendedProperties().get(PROPERTY_ALLOWED_VALUE);
        if (values == null) {
            return new String[0];
        }
        for (Object o : values) {
            if (!(o instanceof String)) continue;
            stringValues.add((String)o);
        }
        return stringValues.toArray(new String[stringValues.size()]);
    }

    @Deprecated
    public void setAllowedValues(String[] allowedValues) {
        this.getExtendedProperties().put(PROPERTY_ALLOWED_VALUE, allowedValues);
    }
}

