/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import java.lang.reflect.Type;

public class JsonRpcMethod {
    private final String methodName;
    private final Type parameterType;
    private final Type returnType;
    private final boolean isNotification;

    private JsonRpcMethod(String methodName, Type parameterType, Type returnType, boolean isNotification) {
        this.methodName = methodName;
        this.parameterType = parameterType;
        this.returnType = returnType;
        this.isNotification = isNotification;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isNotification() {
        return this.isNotification;
    }

    public static JsonRpcMethod notification(String name, Type parameterType) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new JsonRpcMethod(name, parameterType, (Type)((Object)Void.class), true);
    }

    public static JsonRpcMethod request(String name, Type parameterType, Type returnType) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new JsonRpcMethod(name, parameterType, returnType, false);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isNotification) {
            builder.append("JsonRpcMethod (notification) {\n");
        } else {
            builder.append("JsonRpcMethod (request) {\n");
        }
        builder.append("\tmethodName: ").append(this.methodName).append('\n');
        if (this.parameterType != null) {
            builder.append("\tparameterType: ").append(this.parameterType).append('\n');
        }
        if (this.returnType != null) {
            builder.append("\treturnType: ").append(this.returnType).append('\n');
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNotification ? 1231 : 1237);
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.parameterType == null ? 0 : this.parameterType.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRpcMethod other = (JsonRpcMethod)obj;
        if (this.isNotification != other.isNotification) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.parameterType == null ? other.parameterType != null : !this.parameterType.equals(other.parameterType)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

