/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.pgm.opt.SubcommandHandler;
import org.eclipse.jgit.util.IO;
import org.kohsuke.args4j.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIGitCommand {
    @Argument(index=0, metaVar="metaVar_command", required=true, handler=SubcommandHandler.class)
    private TextBuiltin subcommand;
    @Argument(index=1, metaVar="metaVar_arg")
    private List<String> arguments = new ArrayList<String>();

    public TextBuiltin getSubcommand() {
        return this.subcommand;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public static List<String> execute(String str, Repository db) throws Exception {
        try {
            return IO.readLines((String)new String(CLIGitCommand.rawExecute(str, db)));
        }
        catch (Die e) {
            return IO.readLines((String)MessageFormat.format(CLIText.get().fatalError, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rawExecute(String str, Repository db) throws Exception {
        String[] args = CLIGitCommand.split(str);
        if (!args[0].equalsIgnoreCase("git") || args.length < 2) {
            throw new IllegalArgumentException("Expected 'git <command> [<args>]', was:" + str);
        }
        String[] argv = new String[args.length - 1];
        System.arraycopy(args, 1, argv, 0, args.length - 1);
        CLIGitCommand bean = new CLIGitCommand();
        CmdLineParser clp = new CmdLineParser((Object)bean);
        clp.parseArgument(argv);
        TextBuiltin cmd = bean.getSubcommand();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cmd.outs = baos;
        if (cmd.requiresRepository()) {
            cmd.init(db, null);
        } else {
            cmd.init(null, null);
        }
        try {
            cmd.execute(bean.getArguments().toArray(new String[bean.getArguments().size()]));
        }
        finally {
            if (cmd.outw != null) {
                cmd.outw.flush();
            }
        }
        return baos.toByteArray();
    }

    static String[] split(String commandLine) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inquote = false;
        boolean inDblQuote = false;
        StringBuilder r = new StringBuilder();
        int ip = 0;
        block6: while (ip < commandLine.length()) {
            char b = commandLine.charAt(ip++);
            switch (b) {
                case '\t': 
                case ' ': {
                    if (inquote || inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    if (r.length() <= 0) continue block6;
                    list.add(r.toString());
                    r = new StringBuilder();
                    continue block6;
                }
                case '\"': {
                    if (inquote) {
                        r.append(b);
                        continue block6;
                    }
                    inDblQuote = !inDblQuote;
                    continue block6;
                }
                case '\'': {
                    if (inDblQuote) {
                        r.append(b);
                        continue block6;
                    }
                    inquote = !inquote;
                    continue block6;
                }
                case '\\': {
                    if (inquote || ip == commandLine.length()) {
                        r.append(b);
                        continue block6;
                    }
                    r.append(commandLine.charAt(ip++));
                    continue block6;
                }
            }
            r.append(b);
        }
        if (r.length() > 0) {
            list.add(r.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

