/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CLIGitCommand;
import org.junit.Assert;
import org.junit.Before;

public class CLIRepositoryTestCase
extends LocalDiskRepositoryTestCase {
    protected Repository db;
    protected File trash;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.db = this.createWorkRepository();
        this.trash = this.db.getWorkTree();
    }

    protected String[] execute(String ... cmds) throws Exception {
        ArrayList<String> result = new ArrayList<String>(cmds.length);
        for (String cmd : cmds) {
            result.addAll(CLIGitCommand.execute(cmd, this.db));
        }
        return result.toArray(new String[0]);
    }

    protected File writeTrashFile(String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, (String)name, (String)data);
    }

    protected String read(File file) throws IOException {
        return JGitTestUtil.read((File)file);
    }

    protected void deleteTrashFile(String name) throws IOException {
        JGitTestUtil.deleteTrashFile((Repository)this.db, (String)name);
    }

    protected String[] executeAndPrint(String ... cmds) throws Exception {
        String[] lines;
        for (String line : lines = this.execute(cmds)) {
            System.out.println(line);
        }
        return lines;
    }

    protected String[] executeAndPrintTestCode(String ... cmds) throws Exception {
        String[] lines = this.execute(cmds);
        String cmdString = this.cmdString(cmds);
        if (lines.length == 0) {
            System.out.println("\t\tassertTrue(execute(" + cmdString + ").length == 0);");
        } else {
            System.out.println("\t\tassertArrayOfLinesEquals(new String[] { //");
            System.out.print("\t\t\t\t\t\t\"" + this.escapeJava(lines[0]));
            for (int i = 1; i < lines.length; ++i) {
                System.out.println("\", //");
                System.out.print("\t\t\t\t\t\t\"" + this.escapeJava(lines[i]));
            }
            System.out.println("\" //");
            System.out.println("\t\t\t\t}, execute(" + cmdString + ")); //");
        }
        return lines;
    }

    protected String cmdString(String ... cmds) {
        if (cmds.length == 0) {
            return "";
        }
        if (cmds.length == 1) {
            return "\"" + this.escapeJava(cmds[0]) + "\"";
        }
        StringBuilder sb = new StringBuilder(this.cmdString(cmds[0]));
        for (int i = 1; i < cmds.length; ++i) {
            sb.append(", ");
            sb.append(this.cmdString(cmds[i]));
        }
        return sb.toString();
    }

    protected String escapeJava(String line) {
        return line.replaceAll("\"", "\\\\\"").replaceAll("\\\\", "\\\\\\").replaceAll("\t", "\\\\t");
    }

    protected void assertArrayOfLinesEquals(String[] expected, String[] actual) {
        Assert.assertEquals((Object)CLIRepositoryTestCase.toText(expected), (Object)CLIRepositoryTestCase.toText(actual));
    }

    private static String toText(String[] lines) {
        StringBuilder b = new StringBuilder();
        for (String s : lines) {
            b.append(s);
            b.append('\n');
        }
        return b.toString();
    }
}

