/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class ServletWebSocketRequest
extends UpgradeRequest {
    private Map<String, String> cookieMap;
    private HttpServletRequest req;

    public ServletWebSocketRequest(HttpServletRequest request) {
        super(request.getRequestURI());
        this.req = request;
        this.setMethod(request.getMethod());
        this.setHttpVersion(request.getProtocol());
        this.cookieMap = new HashMap<String, String>();
        for (Cookie cookie : request.getCookies()) {
            this.cookieMap.put(cookie.getName(), cookie.getValue());
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration valuesEnum = request.getHeaders(name);
            ArrayList values = new ArrayList();
            while (valuesEnum.hasMoreElements()) {
                values.add(valuesEnum.nextElement());
            }
            this.setHeader(name, values);
        }
        Enumeration protocols = request.getHeaders("Sec-WebSocket-Protocol");
        ArrayList<String> subProtocols = new ArrayList<String>();
        Object protocol = null;
        while (protocol == null && protocols != null && protocols.hasMoreElements()) {
            String candidate = (String)protocols.nextElement();
            for (String p : this.parseProtocols(candidate)) {
                subProtocols.add(p);
            }
        }
        this.setSubProtocols(subProtocols);
        Enumeration e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            Iterator extTokenIter = QuoteUtil.splitAt((String)((String)e.nextElement()), (String)",");
            while (extTokenIter.hasNext()) {
                String extToken = (String)extTokenIter.next();
                ExtensionConfig config = ExtensionConfig.parse((String)extToken);
                this.addExtensions(new ExtensionConfig[]{config});
            }
        }
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }
}

