/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.core.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private final WebSocketServerFactory webSocketFactory;

    public WebSocketHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.configurePolicy(policy);
        this.webSocketFactory = new WebSocketServerFactory(policy);
        this.addBean(this.webSocketFactory);
    }

    public abstract void configure(WebSocketServerFactory var1);

    public void configurePolicy(WebSocketPolicy policy) {
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.configure(this.webSocketFactory);
    }

    public WebSocketServerFactory getWebSocketFactory() {
        return this.webSocketFactory;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.webSocketFactory.isUpgradeRequest(request, response)) {
            if (this.webSocketFactory.acceptWebSocket(request, response)) {
                baseRequest.setHandled(true);
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    public static class Simple
    extends WebSocketHandler {
        private Class<?> websocketPojo;

        public Simple(Class<?> websocketClass) {
            this.websocketPojo = websocketClass;
        }

        @Override
        public void configure(WebSocketServerFactory factory) {
            factory.register(this.websocketPojo);
        }
    }
}

