/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.websocket.core.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class ServletWebSocketRequest
extends HttpServletRequestWrapper
implements UpgradeRequest {
    private List<String> subProtocols = new ArrayList<String>();
    private List<ExtensionConfig> extensions;

    public ServletWebSocketRequest(HttpServletRequest request) {
        super(request);
        Enumeration protocols = request.getHeaders("Sec-WebSocket-Protocol");
        Object protocol = null;
        while (protocol == null && protocols != null && protocols.hasMoreElements()) {
            String candidate = (String)protocols.nextElement();
            for (String p : this.parseProtocols(candidate)) {
                this.subProtocols.add(p);
            }
        }
        this.extensions = new ArrayList<ExtensionConfig>();
        Enumeration e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer((String)e.nextElement(), ",");
            while (tok.hasMoreTokens()) {
                this.extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
            }
        }
    }

    public Map<String, String> getCookieMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Cookie cookie : super.getCookies()) {
            ret.put(cookie.getName(), cookie.getValue());
        }
        return ret;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public String getHost() {
        return this.getHeader("Host");
    }

    public String getHttpEndPointName() {
        return this.getRequestURI();
    }

    public String getOrigin() {
        String origin = this.getHeader("Origin");
        if (origin == null) {
            origin = this.getHeader("Sec-WebSocket-Origin");
        }
        return origin;
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public boolean hasSubProtocol(String test) {
        return this.subProtocols.contains(test);
    }

    public boolean isOrigin(String test) {
        return test.equalsIgnoreCase(this.getOrigin());
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public void setSubProtocols(String protocol) {
    }
}

