/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import jakarta.servlet.ServletContext;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.server.internal.UpgradeRequestAdapter;
import org.eclipse.jetty.websocket.server.internal.UpgradeResponseAdapter;
import org.eclipse.jetty.websocket.util.server.internal.FrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeResponse;

public class JettyServerFrameHandlerFactory
extends JettyWebSocketFrameHandlerFactory
implements FrameHandlerFactory,
LifeCycle.Listener {
    public static JettyServerFrameHandlerFactory getFactory(ServletContext context) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)context, (String)"JettyServerFrameHandlerFactory");
        return (JettyServerFrameHandlerFactory)((Object)contextHandler.getBean(JettyServerFrameHandlerFactory.class));
    }

    public JettyServerFrameHandlerFactory(WebSocketContainer container) {
        super(container);
    }

    public FrameHandler newFrameHandler(Object websocketPojo, ServletUpgradeRequest upgradeRequest, ServletUpgradeResponse upgradeResponse) {
        JettyWebSocketFrameHandler frameHandler = super.newJettyFrameHandler(websocketPojo);
        frameHandler.setUpgradeRequest((UpgradeRequest)new UpgradeRequestAdapter(upgradeRequest));
        frameHandler.setUpgradeResponse((UpgradeResponse)new UpgradeResponseAdapter(upgradeResponse));
        return frameHandler;
    }

    public void lifeCycleStopping(LifeCycle context) {
        ContextHandler contextHandler = (ContextHandler)context;
        JettyServerFrameHandlerFactory factory = (JettyServerFrameHandlerFactory)((Object)contextHandler.getBean(JettyServerFrameHandlerFactory.class));
        if (factory != null) {
            contextHandler.removeBean((Object)factory);
            LifeCycle.stop((Object)((Object)factory));
        }
    }
}

