/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeRequest;

public class UpgradeRequestAdapter
implements UpgradeRequest {
    private final ServletUpgradeRequest servletRequest;

    public UpgradeRequestAdapter(ServletUpgradeRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void addExtensions(ExtensionConfig ... configs) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void addExtensions(String ... configs) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public List<HttpCookie> getCookies() {
        return this.servletRequest.getCookies();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.servletRequest.getExtensions().stream().map(ext -> new JettyExtensionConfig(ext.getName(), ext.getParameters())).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.servletRequest.getHeader(name);
    }

    public int getHeaderInt(String name) {
        return this.servletRequest.getHeaderInt(name);
    }

    public Map<String, List<String>> getHeaders() {
        return this.servletRequest.getHeadersMap();
    }

    public List<String> getHeaders(String name) {
        return this.servletRequest.getHeaders(name);
    }

    public String getHost() {
        return this.servletRequest.getHost();
    }

    public String getHttpVersion() {
        return this.servletRequest.getHttpVersion();
    }

    public String getMethod() {
        return this.servletRequest.getMethod();
    }

    public String getOrigin() {
        return this.servletRequest.getOrigin();
    }

    public Map<String, List<String>> getParameterMap() {
        return this.servletRequest.getParameterMap();
    }

    public String getProtocolVersion() {
        return this.servletRequest.getProtocolVersion();
    }

    public String getQueryString() {
        return this.servletRequest.getQueryString();
    }

    public URI getRequestURI() {
        return this.servletRequest.getRequestURI();
    }

    public Object getSession() {
        return this.servletRequest.getSession();
    }

    public List<String> getSubProtocols() {
        return this.servletRequest.getSubProtocols();
    }

    public Principal getUserPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    public boolean hasSubProtocol(String test) {
        return this.servletRequest.hasSubProtocol(test);
    }

    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    public void setCookies(List<HttpCookie> cookies) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setHeader(String name, List<String> values) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setHeaders(Map<String, List<String>> headers) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setSession(Object session) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setSubProtocols(List<String> protocols) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }

    public void setSubProtocols(String ... protocols) {
        throw new UnsupportedOperationException("Not supported from Servlet API");
    }
}

