/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;

@ManagedObject
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
WebSocketConnection,
IncomingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private ExtensionFactory extensionFactory;
    private boolean active = false;
    private long maximumMessageSize;
    private String protocolVersion;
    private long timeout;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        MultiMap params = new MultiMap();
        String query = requestURI.getQuery();
        if (StringUtil.isNotBlank((String)query)) {
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (Charset)StringUtil.__UTF8_CHARSET, (int)-1);
        }
        for (String name : params.keySet()) {
            List valueList = params.getValues(name);
            String[] valueArr = new String[valueList.size()];
            valueArr = valueList.toArray(valueArr);
            this.parameterMap.put(name, valueArr);
        }
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public void close(CloseStatus closeStatus) throws IOException {
        this.connection.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)this.incomingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append('\n');
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)this.outgoingHandler).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append('\n');
        }
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getIdleTimeout() {
        return this.timeout;
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public RemoteEndpoint getRemote() {
        if (!this.isOpen()) {
            throw new WebSocketException("Session has not been opened yet");
        }
        return this.remote;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public String getSubProtocol() {
        return this.upgradeResponse.getAcceptedSubProtocol();
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public void incomingError(WebSocketException e) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.websocket.incomingError(e);
    }

    public void incomingFrame(Frame frame) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.incomingHandler.incomingFrame(frame);
    }

    public boolean isOpen() {
        return this.active;
    }

    public boolean isSecure() {
        return this.getRequestURI().getScheme().equalsIgnoreCase("wss");
    }

    public void open() {
        if (this.isOpen()) {
            throw new WebSocketException("Cannot Open WebSocketSession, Already open");
        }
        this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler);
        this.active = true;
        this.websocket.openSession(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", new Object[]{this.dump()});
        }
    }

    public void ping(ByteBuffer buf) throws IOException {
        this.remote.sendPing(buf);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setIdleTimeout(long seconds) {
        this.timeout = seconds;
    }

    public void setMaximumMessageSize(long length) {
        this.maximumMessageSize = length;
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    public SuspendToken suspend() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    public Future<Void> write(byte[] buf, int offset, int len) {
        return this.remote.sendBytesByFuture(ByteBuffer.wrap(buf, offset, len));
    }

    public Future<Void> write(ByteBuffer buffer) {
        return this.remote.sendBytesByFuture(buffer);
    }

    public Future<Void> write(String message) {
        return this.remote.sendStringByFuture(message);
    }
}

