/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.websocket.EncodeException;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendHandler;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.FailedFuture;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.eclipse.jetty.websocket.common.message.MessageWriter;

public class WebSocketRemoteEndpoint
implements RemoteEndpoint<Object> {
    private static final Logger LOG = Log.getLogger(WebSocketRemoteEndpoint.class);
    public final LogicalConnection connection;
    public final OutgoingFrames outgoing;
    public MessageOutputStream stream;
    public MessageWriter writer;

    public WebSocketRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoing) {
        if (connection == null) {
            throw new IllegalArgumentException("LogicalConnection cannot be null");
        }
        this.connection = connection;
        this.outgoing = outgoing;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.connection.getRemoteAddress();
    }

    public OutputStream getSendStream() throws IOException {
        if (this.isWriterActive()) {
            throw new IOException("Cannot get OutputStream while Writer is open");
        }
        if (this.isStreamActive()) {
            LOG.debug("getSendStream() -> (existing) {}", new Object[]{this.stream});
            return this.stream;
        }
        this.stream = new MessageOutputStream(this.connection, this.outgoing);
        LOG.debug("getSendStream() -> (new) {}", new Object[]{this.stream});
        return this.stream;
    }

    public Writer getSendWriter() throws IOException {
        if (this.isStreamActive()) {
            throw new IOException("Cannot get Writer while OutputStream is open");
        }
        if (this.isWriterActive()) {
            LOG.debug("getSendWriter() -> (existing) {}", new Object[]{this.writer});
            return this.writer;
        }
        this.writer = new MessageWriter(this.connection, this.outgoing);
        LOG.debug("getSendWriter() -> (new) {}", new Object[]{this.writer});
        return this.writer;
    }

    private boolean isStreamActive() {
        if (this.stream == null) {
            return false;
        }
        return !this.stream.isClosed();
    }

    private boolean isWriterActive() {
        if (this.writer == null) {
            return false;
        }
        return !this.writer.isClosed();
    }

    private Future<SendResult> sendAsyncFrame(WebSocketFrame frame) {
        try {
            this.connection.assertOutputOpen();
            return this.outgoing.outgoingFrame((Frame)frame);
        }
        catch (IOException e) {
            SendHandler handler = frame.getSendHandler();
            return new FailedFuture(handler, e);
        }
    }

    public void sendBytes(ByteBuffer data) throws IOException {
        this.connection.assertOutputOpen();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytes({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(data);
        this.outgoing.outgoingFrame((Frame)frame);
    }

    public Future<SendResult> sendBytes(ByteBuffer data, SendHandler completion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytes({}, {})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data), completion});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(data);
        frame.setSendHandler(completion);
        return this.sendAsyncFrame(frame);
    }

    private void sendFrame(Frame frame) {
        try {
            this.outgoing.outgoingFrame(frame);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void sendObject(Object o) throws IOException, EncodeException {
    }

    public Future<SendResult> sendObject(Object o, SendHandler handler) {
        return null;
    }

    public void sendPartialBytes(ByteBuffer partialByte, boolean isLast) throws IOException {
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(partialByte).setFin(isLast);
        this.outgoing.outgoingFrame((Frame)frame);
    }

    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        WebSocketFrame frame = WebSocketFrame.text(fragment).setFin(isLast);
        this.outgoing.outgoingFrame((Frame)frame);
    }

    public void sendPing(ByteBuffer applicationData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ping with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        WebSocketFrame frame = WebSocketFrame.ping().setPayload(applicationData);
        this.sendFrame(frame);
    }

    public void sendPong(ByteBuffer applicationData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pong with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        WebSocketFrame frame = WebSocketFrame.pong().setPayload(applicationData);
        this.sendFrame(frame);
    }

    public void sendString(String text) throws IOException {
        WebSocketFrame frame = WebSocketFrame.text(text);
        this.outgoing.outgoingFrame((Frame)frame);
    }

    public Future<SendResult> sendString(String text, SendHandler completion) {
        WebSocketFrame frame = WebSocketFrame.text(text);
        frame.setSendHandler(completion);
        return this.sendAsyncFrame(frame);
    }
}

