/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.WebSocketClientSelectorManager;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;

public class ConnectionManager
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(ConnectionManager.class);
    private final Queue<WebSocketSession> sessions = new ConcurrentLinkedQueue<WebSocketSession>();
    private final WebSocketClient client;
    private WebSocketClientSelectorManager selector;

    public static InetSocketAddress toSocketAddress(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Cannot get InetSocketAddress of non-absolute URIs");
        }
        int port = uri.getPort();
        String scheme = uri.getScheme().toLowerCase(Locale.ENGLISH);
        if ("ws".equals(scheme)) {
            if (port == -1) {
                port = 80;
            }
        } else if ("wss".equals(scheme)) {
            if (port == -1) {
                port = 443;
            }
        } else {
            throw new IllegalArgumentException("Only support ws:// and wss:// URIs");
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    public ConnectionManager(WebSocketClient client) {
        this.client = client;
    }

    public void addSession(WebSocketSession session) {
        this.sessions.add(session);
    }

    private void shutdownAllConnections() {
        for (WebSocketSession session : this.sessions) {
            if (session.getConnection() == null) continue;
            try {
                session.getConnection().close(1001, "Shutdown");
            }
            catch (Throwable t) {
                LOG.debug("During Shutdown All Connections", t);
            }
        }
    }

    public ConnectPromise connect(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
        URI toUri = request.getRequestURI();
        String hostname = toUri.getHost();
        if (this.isVirtualConnectionPossibleTo(hostname)) {
            return new VirtualConnect(client, driver, request);
        }
        return new PhysicalConnect(client, driver, request);
    }

    protected void doStart() throws Exception {
        this.selector = this.newWebSocketClientSelectorManager(this.client);
        this.selector.setSslContextFactory(this.client.getSslContextFactory());
        this.selector.setConnectTimeout(this.client.getConnectTimeout());
        this.addBean((Object)this.selector);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.shutdownAllConnections();
        this.sessions.clear();
        super.doStop();
        this.removeBean((Object)this.selector);
    }

    public WebSocketClientSelectorManager getSelector() {
        return this.selector;
    }

    public Collection<WebSocketSession> getSessions() {
        return Collections.unmodifiableCollection(this.sessions);
    }

    public boolean isVirtualConnectionPossibleTo(String hostname) {
        return false;
    }

    protected WebSocketClientSelectorManager newWebSocketClientSelectorManager(WebSocketClient client) {
        return new WebSocketClientSelectorManager(client);
    }

    public void removeSession(WebSocketSession session) {
        this.sessions.remove(session);
    }

    private class VirtualConnect
    extends ConnectPromise {
        public VirtualConnect(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
            super(client, driver, request);
        }

        @Override
        public void run() {
            this.failed((Throwable)new WebSocketException("MUX Not yet supported"));
        }
    }

    private class PhysicalConnect
    extends ConnectPromise {
        private SocketAddress bindAddress;

        public PhysicalConnect(WebSocketClient client, EventDriver driver, ClientUpgradeRequest request) {
            super(client, driver, request);
            this.bindAddress = client.getBindAddress();
        }

        @Override
        public void run() {
            SocketChannel channel = null;
            try {
                channel = SocketChannel.open();
                if (this.bindAddress != null) {
                    channel.bind(this.bindAddress);
                }
                URI wsUri = this.getRequest().getRequestURI();
                channel.socket().setTcpNoDelay(true);
                channel.configureBlocking(false);
                InetSocketAddress address = ConnectionManager.toSocketAddress(wsUri);
                channel.connect(address);
                ConnectionManager.this.getSelector().connect(channel, this);
            }
            catch (Throwable t) {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException ignore) {
                        LOG.ignore((Throwable)ignore);
                    }
                }
                this.failed(t);
            }
        }
    }
}

