/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketClientConnection.class);
    private final ConnectPromise connectPromise;
    private final Masker masker;
    private boolean connected;

    public WebSocketClientConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise) {
        super(endp, executor, connectPromise.getClient().getScheduler(), connectPromise.getClient().getPolicy(), connectPromise.getClient().getBufferPool());
        this.connectPromise = connectPromise;
        this.connected = false;
        this.masker = connectPromise.getMasker();
        assert (this.masker != null);
    }

    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public void onClose() {
        super.onClose();
        ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
        connectionManager.removeSession(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            WebSocketSession session = this.getSession();
            ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
            connectionManager.addSession(session);
            this.connectPromise.onOpen(session);
            this.connected = true;
        }
        super.onOpen();
    }

    public void outgoingFrame(Frame frame, WriteCallback callback) {
        if (frame instanceof WebSocketFrame) {
            if (this.masker == null) {
                ProtocolException ex = new ProtocolException("Must set a Masker");
                LOG.warn((Throwable)ex);
                if (callback != null) {
                    callback.writeFailed((Throwable)ex);
                }
                return;
            }
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback);
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

