/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.HttpResponseHeaderParser;
import org.eclipse.jetty.websocket.client.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;

public class UpgradeConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(UpgradeConnection.class);
    private final ByteBufferPool bufferPool;
    private final ConnectPromise connectPromise;
    private final HttpResponseHeaderParser parser;
    private ClientUpgradeRequest request;

    public UpgradeConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise) {
        super(endp, executor);
        this.connectPromise = connectPromise;
        this.bufferPool = connectPromise.getClient().getBufferPool();
        this.parser = new HttpResponseHeaderParser();
        try {
            this.request = connectPromise.getRequest();
        }
        catch (ClassCastException e) {
            connectPromise.failed(new RuntimeException("Invalid Upgrade Request structure", e));
        }
    }

    public void disconnect(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", new Object[]{endPoint});
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", new Object[]{endPoint});
            endPoint.close();
        }
    }

    private void notifyConnect(ClientUpgradeResponse response) {
        this.connectPromise.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear((ByteBuffer)buffer);
        boolean readMore = false;
        try {
            readMore = this.read(buffer);
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore) {
            this.fillInterested();
        }
    }

    public void onOpen() {
        super.onOpen();
        this.getExecutor().execute(new SendUpgradeRequest());
    }

    private boolean read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            ClientUpgradeResponse resp;
            do {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return true;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return false;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Filled {} bytes - {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)buffer)});
            } while ((resp = this.parser.parse(buffer)) == null);
            this.validateResponse(resp);
            this.notifyConnect(resp);
            this.upgradeConnection(resp);
            return false;
        }
        catch (IOException e) {
            this.connectPromise.failed(e);
            this.disconnect(false);
            return false;
        }
        catch (UpgradeException e) {
            this.connectPromise.failed(e);
            this.disconnect(false);
            return false;
        }
    }

    private void upgradeConnection(ClientUpgradeResponse response) {
        EndPoint endp = this.getEndPoint();
        Executor executor = this.getExecutor();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, executor, this.connectPromise);
        EventDriver websocket = this.connectPromise.getDriver();
        WebSocketPolicy policy = this.connectPromise.getClient().getPolicy();
        WebSocketSession session = new WebSocketSession(this.request.getRequestURI(), websocket, (LogicalConnection)connection);
        session.setPolicy(policy);
        session.setUpgradeResponse((UpgradeResponse)response);
        connection.setSession(session);
        ExtensionStack extensionStack = new ExtensionStack(this.connectPromise.getClient().getExtensionFactory());
        extensionStack.negotiate(response.getExtensions());
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames((IncomingFrames)extensionStack);
        extensionStack.setNextIncoming((IncomingFrames)session);
        session.setOutgoingHandler((OutgoingFrames)extensionStack);
        extensionStack.setNextOutgoing((OutgoingFrames)connection);
        endp.setConnection((Connection)connection);
        connection.onOpen();
    }

    private void validateResponse(ClientUpgradeResponse response) {
        String reqKey = this.request.getKey();
        String expectedHash = AcceptHash.hashKey((String)reqKey);
        response.validateWebSocketHash(expectedHash);
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        List extValues = response.getHeaders("Sec-WebSocket-Extensions");
        if (extValues != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
                }
            }
        }
        response.setExtensions(extensions);
    }

    public class SendUpgradeRequest
    extends FutureCallback
    implements Runnable {
        @Override
        public void run() {
            URI uri = UpgradeConnection.this.connectPromise.getRequest().getRequestURI();
            UpgradeConnection.this.request.setRequestURI(uri);
            String rawRequest = UpgradeConnection.this.request.generate();
            ByteBuffer buf = BufferUtil.toBuffer((String)rawRequest, (Charset)StringUtil.__UTF8_CHARSET);
            UpgradeConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{buf});
        }

        public void succeeded() {
            super.succeeded();
            UpgradeConnection.this.fillInterested();
        }
    }
}

