/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.WebSocketClientFactory;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final WebSocketClientFactory factory;
    private final DefaultWebSocketClient client;
    private final Masker masker;
    private boolean connected;

    public WebSocketClientConnection(EndPoint endp, Executor executor, DefaultWebSocketClient client) {
        super(endp, executor, client.getFactory().getScheduler(), client.getPolicy(), client.getFactory().getBufferPool());
        this.client = client;
        this.factory = client.getFactory();
        this.connected = false;
        this.masker = client.getMasker();
    }

    public DefaultWebSocketClient getClient() {
        return this.client;
    }

    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            this.factory.sessionOpened(this.getSession());
            this.connected = true;
        }
        super.onOpen();
    }

    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        return super.outgoingFrame(frame);
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

