/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class ClientUpgradeRequest
implements UpgradeRequest {
    public static final String COOKIE_DELIM = "\"\\\n\r\t\f\b%+ ;=";
    private final String key;

    public ClientUpgradeRequest() {
        byte[] bytes = new byte[16];
        new Random().nextBytes(bytes);
        this.key = new String(B64Code.encode((byte[])bytes));
    }

    public String generate(URI uri) {
        StringBuilder request = new StringBuilder(512);
        request.append("GET ");
        if (StringUtil.isBlank((String)uri.getPath())) {
            request.append("/");
        } else {
            request.append(uri.getPath());
        }
        if (StringUtil.isNotBlank((String)uri.getRawQuery())) {
            request.append("?").append(uri.getRawQuery());
        }
        request.append(" HTTP/1.1\r\n");
        request.append("Host: ").append(uri.getHost());
        if (uri.getPort() > 0) {
            request.append(':').append(uri.getPort());
        }
        request.append("\r\n");
        request.append("Upgrade: websocket\r\n");
        request.append("Connection: Upgrade\r\n");
        request.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
        if (StringUtil.isNotBlank((String)this.getOrigin())) {
            request.append("Origin: ").append(this.getOrigin()).append("\r\n");
        }
        request.append("Sec-WebSocket-Version: 13\r\n");
        Map<String, String> cookies = this.getCookieMap();
        if (cookies != null && cookies.size() > 0) {
            for (String cookie : cookies.keySet()) {
                request.append("Cookie: ");
                request.append(QuotedStringTokenizer.quoteIfNeeded((String)cookie, (String)COOKIE_DELIM));
                request.append("=");
                request.append(QuotedStringTokenizer.quoteIfNeeded((String)cookies.get(cookie), (String)COOKIE_DELIM));
                request.append("\r\n");
            }
        }
        request.append("\r\n");
        return request.toString();
    }

    public Map<String, String> getCookieMap() {
        return null;
    }

    public List<ExtensionConfig> getExtensions() {
        return null;
    }

    public String getHeader(String name) {
        return null;
    }

    public String getHost() {
        return null;
    }

    public String getHttpEndPointName() {
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getOrigin() {
        return null;
    }

    public List<String> getSubProtocols() {
        return null;
    }

    public boolean hasSubProtocol(String test) {
        return false;
    }

    public boolean isOrigin(String test) {
        return false;
    }

    public void setSubProtocols(String string) {
    }
}

