/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.server.ContainerDefaultConfigurator;

public class AnnotatedServerEndpointConfig
implements ServerEndpointConfig {
    private final Class<?> endpointClass;
    private final String path;
    private final List<Class<? extends Decoder>> decoders;
    private final List<Class<? extends Encoder>> encoders;
    private final ServerEndpointConfig.Configurator configurator;
    private final List<String> subprotocols;
    private Map<String, Object> userProperties;
    private List<Extension> extensions;

    public AnnotatedServerEndpointConfig(JavaxWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno) throws DeploymentException {
        this(containerScope, endpointClass, anno, null);
    }

    public AnnotatedServerEndpointConfig(JavaxWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno, EndpointConfig baseConfig) throws DeploymentException {
        ServerEndpointConfig baseServerConfig = null;
        if (baseConfig instanceof ServerEndpointConfig) {
            baseServerConfig = (ServerEndpointConfig)baseConfig;
        }
        this.decoders = baseConfig != null && baseConfig.getDecoders() != null && baseConfig.getDecoders().size() > 0 ? Collections.unmodifiableList(baseConfig.getDecoders()) : Collections.unmodifiableList(Arrays.asList(anno.decoders()));
        this.encoders = baseConfig != null && baseConfig.getEncoders() != null && baseConfig.getEncoders().size() > 0 ? Collections.unmodifiableList(baseConfig.getEncoders()) : Collections.unmodifiableList(Arrays.asList(anno.encoders()));
        this.subprotocols = baseServerConfig != null && baseServerConfig.getSubprotocols() != null && baseServerConfig.getSubprotocols().size() > 0 ? Collections.unmodifiableList(baseServerConfig.getSubprotocols()) : Collections.unmodifiableList(Arrays.asList(anno.subprotocols()));
        this.path = baseServerConfig != null && baseServerConfig.getPath() != null && baseServerConfig.getPath().length() > 0 ? baseServerConfig.getPath() : anno.value();
        this.extensions = new ArrayList<Extension>();
        this.endpointClass = endpointClass;
        this.userProperties = new HashMap<String, Object>();
        if (baseConfig != null && baseConfig.getUserProperties() != null && baseConfig.getUserProperties().size() > 0) {
            this.userProperties.putAll(baseConfig.getUserProperties());
        }
        ServerEndpointConfig.Configurator rawConfigurator = this.getConfigurator(baseServerConfig, anno);
        this.configurator = (ServerEndpointConfig.Configurator)containerScope.getObjectFactory().decorate((Object)rawConfigurator);
    }

    private ServerEndpointConfig.Configurator getConfigurator(ServerEndpointConfig baseServerConfig, ServerEndpoint anno) throws DeploymentException {
        ServerEndpointConfig.Configurator ret = null;
        if (baseServerConfig != null) {
            ret = baseServerConfig.getConfigurator();
        }
        if (anno != null) {
            if (anno.configurator() == ServerEndpointConfig.Configurator.class) {
                if (ret == null) {
                    return new ContainerDefaultConfigurator();
                }
                return ret;
            }
            try {
                return (ServerEndpointConfig.Configurator)anno.configurator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                StringBuilder err = new StringBuilder();
                err.append("Unable to instantiate ServerEndpoint.configurator() of ");
                err.append(anno.configurator().getName());
                err.append(" defined as annotation in ");
                err.append(anno.getClass().getName());
                throw new DeploymentException(err.toString(), (Throwable)e);
            }
        }
        return ret;
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        return this.configurator;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.decoders;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.encoders;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedServerEndpointConfig that = (AnnotatedServerEndpointConfig)o;
        if (this.endpointClass != null ? !this.endpointClass.equals(that.endpointClass) : that.endpointClass != null) {
            return false;
        }
        return this.path != null ? this.path.equals(that.path) : that.path == null;
    }

    public int hashCode() {
        int result = this.endpointClass != null ? this.endpointClass.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotatedServerEndpointConfig[endpointClass=");
        builder.append(this.endpointClass);
        builder.append(",path=");
        builder.append(this.path);
        builder.append(",decoders=");
        builder.append(this.decoders);
        builder.append(",encoders=");
        builder.append(this.encoders);
        builder.append(",subprotocols=");
        builder.append(this.subprotocols);
        builder.append(",extensions=");
        builder.append(this.extensions);
        builder.append("]");
        return builder.toString();
    }
}

