/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeRequest;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeResponse;
import org.eclipse.jetty.websocket.jsr356.server.PathParamServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.pathmap.WebSocketPathSpec;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class JsrCreator
implements WebSocketCreator {
    public static final String PROP_REMOTE_ADDRESS = "javax.websocket.endpoint.remoteAddress";
    public static final String PROP_LOCAL_ADDRESS = "javax.websocket.endpoint.localAddress";
    public static final String PROP_LOCALES = "javax.websocket.upgrade.locales";
    private static final Logger LOG = Log.getLogger(JsrCreator.class);
    private final ServerEndpointMetadata metadata;
    private final ExtensionFactory extensionFactory;

    public JsrCreator(ServerEndpointMetadata metadata, ExtensionFactory extensionFactory) {
        this.metadata = metadata;
        this.extensionFactory = extensionFactory;
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        List requested;
        JsrHandshakeRequest jsrHandshakeRequest = new JsrHandshakeRequest(req);
        JsrHandshakeResponse jsrHandshakeResponse = new JsrHandshakeResponse((UpgradeResponse)resp);
        ServerEndpointConfig config = this.metadata.getConfig();
        config = new BasicServerEndpointConfig(config);
        Map userProperties = config.getUserProperties();
        userProperties.put(PROP_LOCAL_ADDRESS, req.getLocalSocketAddress());
        userProperties.put(PROP_REMOTE_ADDRESS, req.getRemoteSocketAddress());
        userProperties.put(PROP_LOCALES, Collections.list(req.getLocales()));
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (!configurator.checkOrigin(req.getOrigin())) {
            block13: {
                try {
                    resp.sendForbidden("Origin mismatch");
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug("Unable to send error response", (Throwable)e);
                }
            }
            return null;
        }
        List supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = req.getSubProtocols());
        if (StringUtil.isNotBlank((String)subprotocol)) {
            resp.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<JsrExtension> installedExtensions = new ArrayList<JsrExtension>();
        for (String extName : this.extensionFactory.getAvailableExtensions().keySet()) {
            installedExtensions.add(new JsrExtension(extName));
        }
        ArrayList<JsrExtension> requestedExts = new ArrayList<JsrExtension>();
        for (ExtensionConfig reqCfg : req.getExtensions()) {
            requestedExts.add(new JsrExtension(reqCfg));
        }
        List usedExtensions = configurator.getNegotiatedExtensions(installedExtensions, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (usedExtensions != null) {
            for (Extension used : usedExtensions) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        resp.setExtensions(configs);
        PathSpec pathSpec = jsrHandshakeRequest.getRequestPathSpec();
        if (pathSpec instanceof WebSocketPathSpec) {
            WebSocketPathSpec wspathSpec = (WebSocketPathSpec)pathSpec;
            String requestPath = req.getRequestPath();
            config = new PathParamServerEndpointConfig(config, wspathSpec, requestPath);
        }
        configurator.modifyHandshake(config, (HandshakeRequest)jsrHandshakeRequest, (HandshakeResponse)jsrHandshakeResponse);
        try {
            Class endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            return new EndpointInstance(endpoint, (EndpointConfig)config, (EndpointMetadata)this.metadata);
        }
        catch (InstantiationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to create websocket: " + config.getEndpointClass().getName(), (Throwable)e);
            }
            return null;
        }
    }

    public String toString() {
        return String.format("%s[metadata=%s]", this.getClass().getName(), this.metadata);
    }
}

