/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;

public class StringMessageSink
extends AbstractMessageSink {
    private static final Logger LOG = Log.getLogger(StringMessageSink.class);
    private Utf8StringBuilder utf;
    private int size = 0;

    public StringMessageSink(JavaxWebSocketSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                this.size += payload.remaining();
                if (this.session.getMaxTextMessageBufferSize() > 0 && this.size > this.session.getMaxTextMessageBufferSize()) {
                    throw new MessageTooLargeException(String.format("Binary message too large: (actual) %,d > (configured max text buffer size) %,d", this.size, this.session.getMaxTextMessageBufferSize()));
                }
                if (this.utf == null) {
                    this.utf = new Utf8StringBuilder(1024);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Raw Payload {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                }
                this.utf.append(payload);
            }
            if (frame.isFin()) {
                if (this.utf != null) {
                    this.methodHandle.invoke(this.utf.toString());
                } else {
                    this.methodHandle.invoke("");
                }
                this.size = 0;
                this.utf = null;
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

