/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.io.Reader;
import org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnMessage;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;
import org.eclipse.jetty.websocket.jsr356.decoders.BooleanDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.ByteDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.CharacterDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.DoubleDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.FloatDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.IntegerDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.LongDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.ReaderDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.ShortDecoder;
import org.eclipse.jetty.websocket.jsr356.decoders.StringDecoder;

public class JsrParamIdText
extends JsrParamIdOnMessage
implements IJsrParamId {
    public static final IJsrParamId INSTANCE = new JsrParamIdText();

    private boolean isMessageRoleAssigned(JsrCallable callable) {
        if (callable instanceof OnMessageCallable) {
            OnMessageCallable onmessage = (OnMessageCallable)callable;
            return onmessage.isMessageRoleAssigned();
        }
        return false;
    }

    @Override
    public boolean process(Param param, JsrCallable callable) throws InvalidSignatureException {
        if (super.process(param, callable)) {
            return true;
        }
        if (param.type.isAssignableFrom(String.class)) {
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(StringDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Boolean.class)) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(BooleanDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Byte.class) || param.type == Byte.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(ByteDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Character.class) || param.type == Character.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(CharacterDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Double.class) || param.type == Double.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(DoubleDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Float.class) || param.type == Float.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(FloatDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Integer.class) || param.type == Integer.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(IntegerDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Long.class) || param.type == Long.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(LongDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Short.class) || param.type == Short.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecoderClass(ShortDecoder.class);
            return true;
        }
        if (param.type.isAssignableFrom(Reader.class)) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT_STREAM);
            callable.setDecoderClass(ReaderDecoder.class);
            return true;
        }
        if (param.type == Boolean.TYPE) {
            if (this.isMessageRoleAssigned(callable)) {
                param.bind(Param.Role.MESSAGE_PARTIAL_FLAG);
            } else {
                param.bind(Param.Role.MESSAGE_TEXT);
                callable.setDecoderClass(BooleanDecoder.class);
            }
            return true;
        }
        return false;
    }
}

