/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.git;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.toolchain.version.git.GitCommit;
import org.eclipse.jetty.toolchain.version.git.GitOutputParser;
import org.eclipse.jetty.toolchain.version.issues.IssueParser;

public class GitLogParser
implements GitOutputParser {
    private static final String AUTHOR_DATE = "#AUTHOR_DATE#:";
    private static final String AUTHOR_NAME = "#AUTHOR_NAME#:";
    private static final String BODY = "#BODY#:";
    private static final String COMMIT_ID = "#COMMIT_ID#:";
    private static final String COMMITTER_DATE = "#COMMITTER_DATE#:";
    private static final String COMMITTER_NAME = "#COMMITTER_NAME#:";
    private static final String END = "####";
    private static final String SUBJECT = "#SUBJECT#:";
    private State state = null;
    private GitCommit activeCommit;
    private final List<GitCommit> commits = new ArrayList<GitCommit>();

    public String getFormat() {
        StringBuilder fmt = new StringBuilder();
        fmt.append("--pretty=format:");
        fmt.append(COMMIT_ID).append("%H%n");
        fmt.append(AUTHOR_NAME).append("%an%n");
        fmt.append(AUTHOR_DATE).append("%ai%n");
        fmt.append(COMMITTER_NAME).append("%cn%n");
        fmt.append(COMMITTER_DATE).append("%ci%n");
        fmt.append(SUBJECT).append("%s%n");
        fmt.append(BODY).append("%b%n");
        fmt.append(END);
        return fmt.toString();
    }

    public GitCommit getGitCommitLog(int index) {
        return this.commits.get(index);
    }

    public List<GitCommit> getGitCommitLogs() {
        return this.commits;
    }

    @Override
    public void parseEnd() {
        IssueParser issueparser = new IssueParser();
        for (GitCommit commit : this.commits) {
            HashSet<String> issueIds = new HashSet<String>();
            issueparser.findPossibleIssueIds(commit.getSubject(), issueIds);
            for (String line : commit.getBody()) {
                issueparser.findPossibleIssueIds(line, issueIds);
            }
            commit.setIssueIds(issueIds);
        }
    }

    @Override
    public void parseLine(int linenum, String line) throws ParseException {
        if (line.startsWith(COMMIT_ID)) {
            this.activeCommit = new GitCommit();
            this.commits.add(this.activeCommit);
            this.state = State.HEADERS;
            this.activeCommit.setCommitId(line.substring(COMMIT_ID.length()));
            return;
        }
        if (this.activeCommit == null) {
            throw new ParseException("Unexpected Git Log line: " + line, 0);
        }
        switch (this.state) {
            case HEADERS: {
                if (line.startsWith(AUTHOR_NAME)) {
                    this.activeCommit.setAuthorName(line.substring(AUTHOR_NAME.length()));
                    break;
                }
                if (line.startsWith(AUTHOR_DATE)) {
                    this.activeCommit.parseAuthorDate(line.substring(AUTHOR_DATE.length()));
                    break;
                }
                if (line.startsWith(COMMITTER_NAME)) {
                    this.activeCommit.setCommitterName(line.substring(COMMITTER_NAME.length()));
                    break;
                }
                if (line.startsWith(COMMITTER_DATE)) {
                    this.activeCommit.parseCommitterDate(line.substring(COMMITTER_DATE.length()));
                    break;
                }
                if (line.startsWith(SUBJECT)) {
                    this.activeCommit.setSubject(line.substring(SUBJECT.length()));
                    break;
                }
                if (line.startsWith(BODY)) {
                    this.activeCommit.addBodyLine(line.substring(BODY.length()));
                    this.state = State.BODY;
                    break;
                }
                if (!line.startsWith(END)) break;
                this.state = State.FILES;
                break;
            }
            case BODY: {
                if (line.startsWith(END)) {
                    this.state = State.FILES;
                }
                this.activeCommit.addBodyLine(line.trim());
                break;
            }
            case FILES: {
                String filename = line.trim();
                if (!StringUtils.isNotBlank((CharSequence)filename)) break;
                this.activeCommit.addFilename(filename);
            }
        }
    }

    @Override
    public void parseStart() {
        this.commits.clear();
    }

    static enum State {
        HEADERS,
        BODY,
        FILES;

    }
}

