/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.toolchain.version.AbstractVersionMojo;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.git.GitCommand;
import org.eclipse.jetty.toolchain.version.git.GitFilter;
import org.eclipse.jetty.toolchain.version.issues.GitHubIssueResolver;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHLabel;

public class UpdateVersionTextMojo
extends AbstractVersionMojo {
    protected String version;
    protected String versionTextKey;
    protected String versionTagKey;
    protected boolean sortExisting = false;
    protected boolean refreshTags = false;
    protected boolean updateDate = false;
    protected boolean copyGenerated;
    protected boolean attachArtifact;
    protected File versionTextOutputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.hasVersionTextFile("update-version-text")) {
            return;
        }
        if (!this.hasCredentialsFile("update-version-text")) {
            return;
        }
        try {
            String currentTagId;
            String commitMessage = "Updating VERSION.txt";
            VersionPattern verTextPattern = new VersionPattern(this.versionTextKey);
            VersionPattern verTagPattern = new VersionPattern(this.versionTagKey);
            VersionText versionText = new VersionText(verTextPattern);
            versionText.read(this.versionTextInputFile);
            versionText.setSortExisting(this.sortExisting);
            String updateVersionText = verTextPattern.toVersionId(this.version);
            String updateVersionGit = verTagPattern.toVersionId(this.version);
            this.getLog().debug((CharSequence)("raw version = " + this.version));
            this.getLog().debug((CharSequence)("updateVersionText (as it appears in VERSION.txt) = " + updateVersionText));
            this.getLog().debug((CharSequence)("updateVersionGit (as it appears to git tags) = " + updateVersionGit));
            Release rel = versionText.findRelease(updateVersionText);
            if (rel == null) {
                rel = new Release(updateVersionText);
                this.getLog().debug((CharSequence)("Not Found, creating new rel = " + rel));
            } else {
                this.getLog().debug((CharSequence)("Using existing rel = " + rel));
            }
            this.getLog().info((CharSequence)("Updating version section: " + this.version));
            String priorTextVersion = versionText.getPriorVersion(updateVersionText);
            if (priorTextVersion == null) {
                priorTextVersion = versionText.getReleases().get(0).getVersion();
            }
            this.getLog().debug((CharSequence)("Prior version in VERSION.txt is " + priorTextVersion));
            GitFilter gitFilter = new GitFilter();
            for (String filenameExclude : this.filenameExcludes) {
                gitFilter.addFilenameExclude(filenameExclude);
            }
            GitCommand git = new GitCommand();
            git.setWorkDir(this.basedir);
            git.setLog(this.getLog());
            git.setFilter(gitFilter);
            if (this.refreshTags) {
                this.getLog().info((CharSequence)"Fetching git tags from remote ...");
                if (!git.fetchTags()) {
                    throw new MojoFailureException("Unable to fetch git tags?");
                }
            }
            if (!verTextPattern.isMatch(priorTextVersion)) {
                StringBuilder err = new StringBuilder();
                err.append("Prior version [").append(priorTextVersion);
                err.append("] is not a valid version identifier.");
                err.append(" Does not conform to expected pattern [");
                err.append(this.versionTextKey).append("]");
                throw new MojoExecutionException(err.toString());
            }
            String priorGitVersion = verTextPattern.getLastVersion(this.versionTagKey);
            String priorTagId = git.findTagMatching(priorGitVersion);
            String currentCommitId = "HEAD";
            if (priorTagId == null) {
                this.getLog().warn((CharSequence)("Unable to find git tag id for prior version id [" + priorGitVersion + "] (defined in VERSION.txt as [" + priorTextVersion + "])"));
                this.getLog().info((CharSequence)("Adding empty version section to top for version id [" + updateVersionText + "]"));
                this.updateVersionText(versionText, rel, updateVersionText, priorTagId, currentCommitId, currentCommitId);
                return;
            }
            this.getLog().debug((CharSequence)("Tag for prior version [" + priorGitVersion + "] is " + priorTagId));
            String priorCommitId = git.getTagCommitId(priorTagId);
            this.getLog().debug((CharSequence)("Commit ID from [" + priorTagId + "]: " + priorCommitId));
            if (this.refreshTags && (currentTagId = git.findTagMatching(updateVersionText)) != null) {
                currentCommitId = git.getTagCommitId(currentTagId);
            }
            this.getLog().debug((CharSequence)("Commit ID to [" + updateVersionText + "]: " + currentCommitId));
            git.populateIssuesForRange(priorCommitId, currentCommitId, rel);
            int problemCount = this.resolveIssueSubjects(rel);
            if (problemCount > 0) {
                this.getLog().warn((CharSequence)("Encounter [" + problemCount + "] issue(s) with potential problems. A manual review of the changes to " + this.versionTextOutputFile + " is strongly recommended!"));
            }
            if (rel.getReleasedOn() == null && this.updateDate) {
                rel.setReleasedOn(new Date());
            }
            this.updateVersionText(versionText, rel, updateVersionText, priorTagId, currentCommitId, currentCommitId);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to generate replacement VERSION.txt", (Throwable)e);
        }
    }

    protected void updateVersionText(VersionText versionText, Release rel, String updateVersionText, String priorTagId, String priorCommitId, String currentCommitId) throws MojoFailureException, IOException {
        versionText.replaceOrPrepend(rel);
        this.generateVersion(versionText);
        String commitMessage = "Updating version " + updateVersionText + " in VERSION.txt";
        this.getLog().info((CharSequence)("Update complete. Here's your git command. (Copy/Paste)\ngit commit -m \"" + commitMessage + "\" " + this.versionTextInputFile.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int resolveIssueSubjects(Release rel) {
        GitHubIssueResolver issueResolver = new GitHubIssueResolver();
        ArrayList<Issue> filtered = new ArrayList<Issue>();
        int problemCount = 0;
        try {
            issueResolver.init(this.getLog());
            for (Issue issue : rel.getIssues()) {
                String issueRef = issue.getId();
                try {
                    this.getLog().debug((CharSequence)("Resolving Subject for Issue " + issueRef));
                    GHIssue ghissue = issueResolver.getIssue(issueRef);
                    if (ghissue == null) {
                        this.getLog().info((CharSequence)("Unable to find GitHub Issue " + issueRef));
                        ++problemCount;
                        continue;
                    }
                    if (ghissue.isPullRequest()) {
                        this.getLog().info((CharSequence)("Filtering Pull Request: " + issue.getId()));
                        filtered.add(issue);
                        continue;
                    }
                    if (this.hasLabel(ghissue, "Documentation") && ghissue.getLabels().size() == 1) {
                        this.getLog().info((CharSequence)("Filtering 'Documentation' only tagged issue: " + ghissue.getTitle()));
                        filtered.add(issue);
                        continue;
                    }
                    if (this.hasLabel(ghissue, "Invalid") && ghissue.getLabels().size() == 1) {
                        this.getLog().info((CharSequence)("Filtering 'Invalid' only tagged issue: " + ghissue.getTitle()));
                        filtered.add(issue);
                        continue;
                    }
                    issue.setText(ghissue.getTitle());
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to obtain Subject for Issue " + issueRef), (Throwable)e);
                }
                catch (NumberFormatException e) {
                    this.getLog().warn((CharSequence)("Bad Issue # crept in: " + e.getMessage()));
                }
                if (issue.getSyntax() != IssueSyntax.BAD) continue;
                this.getLog().warn((CharSequence)("Issue with bad syntax needs review: " + issue.getId()));
                ++problemCount;
            }
            rel.dropIssues(filtered);
        }
        catch (IOException e) {
            this.getLog().warn((Throwable)e);
        }
        finally {
            issueResolver.destroy();
        }
        return problemCount;
    }

    private boolean hasLabel(GHIssue ghissue, String labelText) {
        try {
            Collection labels = ghissue.getLabels();
            if (labels == null) {
                return false;
            }
            for (GHLabel ghlabel : labels) {
                if (!ghlabel.getName().equalsIgnoreCase(labelText)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void generateVersion(VersionText versionText) throws MojoFailureException, IOException {
        this.ensureDirectoryExists(this.versionTextOutputFile.getCanonicalFile().getParentFile());
        versionText.write(this.versionTextOutputFile);
        this.getLog().debug((CharSequence)("New VERSION.txt written at " + this.versionTextOutputFile.getAbsolutePath()));
        if (this.attachArtifact) {
            this.getLog().info((CharSequence)"Attaching generated VERSION.txt");
            this.getLog().debug((CharSequence)("Classifier = " + this.classifier));
            this.getLog().debug((CharSequence)("Type = " + this.type));
            this.projectHelper.attachArtifact(this.project, this.type, this.classifier, this.versionTextOutputFile);
        }
        if (this.copyGenerated) {
            this.getLog().info((CharSequence)"Copying generated VERSION.txt over input VERSION.txt");
            FileUtils.copyFile((File)this.versionTextOutputFile, (File)this.versionTextInputFile);
        }
    }
}

