/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.UpdateVersionTextMojo;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueComparator;

public class EffectiveMojo
extends UpdateVersionTextMojo {
    private File versionTagOutputFile;

    @Override
    protected void updateVersionText(VersionText versionText, Release rel, String updateVersionText, String priorTagId, String priorCommitId, String currentCommitId) throws MojoFailureException, IOException {
        if (!this.hasCredentialsFile("effective")) {
            return;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        issues.addAll(rel.getIssues());
        Collections.sort(issues, new IssueComparator());
        System.out.printf("Update Version: %s%n", updateVersionText);
        System.out.printf("Changes from %s [%s]%n", priorTagId, priorCommitId);
        System.out.printf("          to %s%n", currentCommitId);
        System.out.println();
        for (Issue issue : issues) {
            System.out.println(issue);
        }
        if (this.versionTagOutputFile != null) {
            try (FileWriter writer = new FileWriter(this.versionTagOutputFile);
                 PrintWriter out = new PrintWriter(writer);){
                for (Issue issue : issues) {
                    out.println(issue);
                }
            }
        }
    }
}

