/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.websocket.WebSocketBuffers;

public class WebSocketGenerator {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private Buffer _buffer;

    public WebSocketGenerator(WebSocketBuffers buffers, EndPoint endp) {
        this._buffers = buffers;
        this._endp = endp;
    }

    public synchronized void addFrame(byte frame, byte[] content, int blockFor) throws IOException {
        this.addFrame(frame, content, 0, content.length, blockFor);
    }

    public synchronized void addFrame(byte frame, byte[] content, int offset, int length, int blockFor) throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getDirectBuffer();
        }
        if ((frame & 0x80) == 128) {
            if (length > 0x200000) {
                throw new IllegalArgumentException("too big");
            }
            int length_bytes = length > 16384 ? 3 : (length > 128 ? 2 : 1);
            int needed = length + 1 + length_bytes;
            this.checkSpace(needed, blockFor);
            this._buffer.put(frame);
            switch (length_bytes) {
                case 3: {
                    this._buffer.put((byte)(0x80 | length >> 14));
                }
                case 2: {
                    this._buffer.put((byte)(0x80 | 0x7F & length >> 7));
                }
                case 1: {
                    this._buffer.put((byte)(0x7F & length));
                }
            }
            this._buffer.put(content, offset, length);
        } else {
            int needed = length + 2;
            this.checkSpace(needed, blockFor);
            this._buffer.put(frame);
            this._buffer.put(content, offset, length);
            this._buffer.put((byte)-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFrame(byte frame, String content, int blockFor) throws IOException {
        Buffer byte_buffer = this._buffers.getBuffer();
        try {
            byte[] array = byte_buffer.array();
            int chars = content.length();
            int bytes = 0;
            int limit = array.length - 6;
            for (int i = 0; i < chars; ++i) {
                char code = content.charAt(i);
                if (bytes >= limit) {
                    throw new IllegalArgumentException("frame too large");
                }
                if ((code & 0xFFFFFF80) == 0) {
                    array[bytes++] = (byte)code;
                    continue;
                }
                if ((code & 0xFFFFF800) == 0) {
                    array[bytes++] = (byte)(0xC0 | code >> 6);
                    array[bytes++] = (byte)(0x80 | code & 0x3F);
                    continue;
                }
                if ((code & 0xFFFF0000) == 0) {
                    array[bytes++] = (byte)(0xE0 | code >> 12);
                    array[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code & 0x3F);
                    continue;
                }
                if ((code & 0xFF200000) == 0) {
                    array[bytes++] = (byte)(0xF0 | code >> 18);
                    array[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code & 0x3F);
                    continue;
                }
                if ((code & 0xF4000000) == 0) {
                    array[bytes++] = (byte)(0xF8 | code >> 24);
                    array[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code & 0x3F);
                    continue;
                }
                if ((code & Integer.MIN_VALUE) == 0) {
                    array[bytes++] = (byte)(0xFC | code >> 30);
                    array[bytes++] = (byte)(0x80 | code >> 24 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                    array[bytes++] = (byte)(0x80 | code & 0x3F);
                    continue;
                }
                array[bytes++] = 63;
            }
            this.addFrame(frame, array, 0, bytes, blockFor);
        }
        finally {
            this._buffers.returnBuffer(byte_buffer);
        }
    }

    private void checkSpace(int needed, long blockFor) throws IOException {
        int space = this._buffer.space();
        if (space < needed) {
            if (this._endp.isBlocking()) {
                this.flushBuffer();
                this._buffer.compact();
                space = this._buffer.space();
            } else {
                this.flushBuffer();
                this._buffer.compact();
                space = this._buffer.space();
                if (space < needed && this._buffer.length() > 0 && this._endp.blockWritable(blockFor)) {
                    this.flushBuffer();
                    this._buffer.compact();
                    space = this._buffer.space();
                }
            }
            if (space < needed) {
                this._endp.close();
                throw new IOException("Full Timeout");
            }
        }
    }

    public synchronized int flush(long blockFor) {
        return 0;
    }

    public synchronized int flush() throws IOException {
        int flushed = this.flushBuffer();
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return flushed;
    }

    private int flushBuffer() throws IOException {
        if (!this._endp.isOpen()) {
            return -1;
        }
        if (this._buffer != null) {
            int flushed = this._endp.flush(this._buffer);
            if (flushed > 0) {
                this._buffer.skip(flushed);
            }
            return flushed;
        }
        return 0;
    }

    public synchronized boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }
}

