/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.plugins.MavenService;
import org.eclipse.jetty.plugins.model.Plugin;
import org.eclipse.jetty.plugins.util.MavenUtils;
import org.eclipse.jetty.plugins.util.RepositoryParser;
import org.eclipse.jetty.plugins.util.StreamUtils;

public class HttpMavenService
implements MavenService {
    private static final String REPOSITORY_URL = "http://repo2.maven.org/maven2/";
    private static final String[] GROUP_IDS = new String[]{"org/eclipse/jetty", "org/mortbay/jetty"};
    private static final String VERSION = "9.0.0-SNAPSHOT";
    private boolean _searchRemoteRepository = true;
    private boolean _searchLocalRepository = false;
    private String _localRepository = MavenUtils.getLocalRepositoryLocation();
    private String _repositoryUrl = "http://repo2.maven.org/maven2/";
    private String[] _groupIds = GROUP_IDS;
    private String _version = "9.0.0-SNAPSHOT";

    @Override
    public Set<String> listAvailablePlugins() {
        System.out.println("Using local repo: " + this._searchLocalRepository + " remote repo: " + this._searchRemoteRepository);
        HashSet<String> availablePlugins = new HashSet<String>();
        if (this._searchRemoteRepository) {
            availablePlugins.addAll(this.getListOfRemotePlugins());
        }
        if (this._searchLocalRepository) {
            availablePlugins.addAll(this.getListOfLocalPlugins());
        }
        return availablePlugins;
    }

    private Set<String> getListOfLocalPlugins() {
        HashSet<String> availablePlugins = new HashSet<String>();
        File localMavenRepository = new File(this._localRepository);
        if (!localMavenRepository.exists()) {
            System.out.println("Can't find local repo: " + localMavenRepository);
            return availablePlugins;
        }
        System.out.println("Using local repository: " + localMavenRepository);
        for (String groupId : this._groupIds) {
            File file = new File(this._localRepository + groupId);
            if (!file.exists()) break;
            Object[] localMavenModuleList = file.list();
            System.out.println("Trying the following modules: " + Arrays.toString(localMavenModuleList));
            for (Object potentialPlugin : localMavenModuleList) {
                File pluginFile = new File(this._localRepository + this.getPluginPath(groupId, (String)potentialPlugin));
                if (!pluginFile.exists()) continue;
                availablePlugins.add((String)potentialPlugin);
            }
        }
        return availablePlugins;
    }

    private Set<String> getListOfRemotePlugins() {
        HashSet<String> availablePlugins = new HashSet<String>();
        String moduleListing = this.fetchDirectoryListingOfJettyModules();
        List<String> modules = RepositoryParser.parseLinksInDirectoryListing(moduleListing);
        for (String module : modules) {
            String listing = this.fetchModuleDirectoryListing(module);
            if (!RepositoryParser.isModuleAPlugin(listing)) continue;
            availablePlugins.add(module);
        }
        return availablePlugins;
    }

    private String fetchDirectoryListingOfJettyModules() {
        try {
            StringBuilder directoryListing = new StringBuilder();
            for (String groupId : this._groupIds) {
                URL url = new URL(this._repositoryUrl + groupId);
                URLConnection connection = url.openConnection();
                InputStream inputStream = connection.getInputStream();
                directoryListing.append(StreamUtils.inputStreamToString(inputStream));
            }
            return directoryListing.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String fetchModuleDirectoryListing(String module) {
        for (String groupId : this._groupIds) {
            try {
                URL configJar = new URL(this._repositoryUrl + this.getModulePath(groupId, module));
                URLConnection connection = configJar.openConnection();
                InputStream inputStream = connection.getInputStream();
                return StreamUtils.inputStreamToString(inputStream);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        return "not a plugin";
    }

    @Override
    public Plugin getPlugin(String pluginName) {
        File pluginJar = this.getPluginFile(pluginName);
        return new Plugin(pluginName, pluginJar);
    }

    private String getPluginPath(String groupId, String pluginName) {
        return this.getModulePath(groupId, pluginName) + pluginName + "-" + this._version + "-plugin.zip";
    }

    private String getModulePath(String groupId, String pluginName) {
        return groupId + "/" + pluginName + "/" + this._version + "/";
    }

    private File getPluginFile(String pluginName) {
        for (String groupId : this._groupIds) {
            File pluginFile = new File(MavenUtils.getLocalRepositoryLocation() + this.getPluginPath(groupId, pluginName));
            if (pluginFile.exists()) {
                return pluginFile;
            }
            String urlString = this._repositoryUrl + this.getPluginPath(groupId, pluginName);
            String fileName = urlString.substring(urlString.lastIndexOf("/") + 1);
            try {
                return this.getPluginFileFromRemoteLocation(urlString, fileName);
            }
            catch (IOException e) {
                System.out.println("Couldn't find plugin: " + pluginName + " at repo: " + this._repositoryUrl + ". " + "Probably trying other repo. Reason: " + e.getMessage());
            }
        }
        throw new IllegalStateException("Plugin: " + pluginName + "  not found at any configured repo.");
    }

    private File getPluginFileFromRemoteLocation(String urlString, String fileName) throws IOException {
        int len;
        URL url = new URL(urlString);
        URLConnection connection = url.openConnection();
        InputStream inputStream = connection.getInputStream();
        File tempFile = new File(System.getProperty("java.io.tmpdir"), fileName);
        FileOutputStream out = new FileOutputStream(tempFile);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        inputStream.close();
        return tempFile;
    }

    @Override
    public void setGroupId(String groupId) {
        this._groupIds = new String[]{groupId.replace(".", "/")};
    }

    public void setLocalRepository(String localRepository) {
        this._localRepository = localRepository;
    }

    @Override
    public void setRepositoryUrl(String repositoryUrl) {
        this._repositoryUrl = repositoryUrl;
    }

    @Override
    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public void setSearchRemoteRepository(boolean searchRemoteRepository) {
        this._searchRemoteRepository = searchRemoteRepository;
    }

    @Override
    public void setSearchLocalRepository(boolean searchLocalRepository) {
        this._searchLocalRepository = searchLocalRepository;
    }
}

