/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class PostConstructAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;
    protected LifeCycleCallbackCollection _callbacks;

    public PostConstructAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
        this._callbacks = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
    }

    @Override
    public void doHandle(Class clazz) {
        if (Util.isServletType(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PostConstruct.class)) continue;
                if (m.getParameterTypes().length != 0) {
                    throw new IllegalStateException(m + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(m + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(m + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " is static");
                }
                MetaData metaData = (MetaData)this._context.getAttribute("org.eclipse.jetty.metaData");
                MetaData.Origin origin = metaData.getOrigin("post-construct");
                if (origin != null && (origin == MetaData.Origin.WebXml || origin == MetaData.Origin.WebDefaults || origin == MetaData.Origin.WebOverride)) {
                    return;
                }
                PostConstructCallback callback = new PostConstructCallback();
                callback.setTarget(clazz.getName(), m.getName());
                this._callbacks.add((LifeCycleCallback)callback);
            }
        }
    }
}

