/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public ResourcesAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        if (values != null && values.size() == 1) {
            List list = (List)values.get(0).getValue();
            for (AnnotationParser.ListValue resource : list) {
                List<AnnotationParser.Value> resourceValues = resource.getList();
                String name = null;
                String mappedName = null;
                for (AnnotationParser.Value v : resourceValues) {
                    if ("name".equals(v.getName())) {
                        name = (String)v.getValue();
                        continue;
                    }
                    if (!"mappedName".equals(v.getName())) continue;
                    mappedName = (String)v.getValue();
                }
                if (name == null) {
                    Log.warn((String)("Skipping Resources(Resource) annotation with no name on class " + className));
                    continue;
                }
                try {
                    if (NamingEntryUtil.bindToENC((Object)this._wac, name, mappedName) || NamingEntryUtil.bindToENC((Object)this._wac.getServer(), (String)name, mappedName)) continue;
                    Log.warn((String)("Skipping Resources(Resource) annotation on " + className + " for name " + name + ": No resource bound at " + (mappedName == null ? name : mappedName)));
                }
                catch (NamingException e) {
                    Log.warn((Throwable)e);
                }
            }
        } else {
            Log.warn((String)("Skipping empty or incorrect Resources annotation on " + className));
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@Resources not applicable for fields: " + className + "." + fieldName));
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@Resources not applicable for methods: " + className + "." + methodName));
    }
}

