/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.annotations.AnnotationFinder;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.IntrospectionUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class AnnotationProcessor {
    AnnotationFinder _finder;
    ClassLoader _loader;
    RunAsCollection _runAs;
    InjectionCollection _injections;
    LifeCycleCallbackCollection _callbacks;
    List _servlets;
    List _filters;
    List _listeners;
    List _servletMappings;
    List _filterMappings;
    Map _pojoInstances = new HashMap();
    WebAppContext _webApp;
    private static Class[] __envEntryTypes = new Class[]{String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class};

    public AnnotationProcessor(WebAppContext webApp, AnnotationFinder finder, RunAsCollection runAs, InjectionCollection injections, LifeCycleCallbackCollection callbacks, List servlets, List filters, List listeners, List servletMappings, List filterMappings) {
        this._webApp = webApp;
        this._finder = finder;
        this._runAs = runAs;
        this._injections = injections;
        this._callbacks = callbacks;
        this._servlets = servlets;
        this._filters = filters;
        this._listeners = listeners;
        this._servletMappings = servletMappings;
        this._filterMappings = filterMappings;
    }

    public void process() throws Exception {
        this.processServlets();
        this.processFilters();
        this.processListeners();
        this.processRunAsAnnotations();
        this.processLifeCycleCallbackAnnotations();
        this.processResourcesAnnotations();
        this.processResourceAnnotations();
    }

    public void processServlets() throws Exception {
    }

    public void processFilters() throws Exception {
    }

    public void processListeners() throws Exception {
    }

    public List getServlets() {
        return this._servlets;
    }

    public List getServletMappings() {
        return this._servletMappings;
    }

    public List getFilters() {
        return this._filters;
    }

    public List getFilterMappings() {
        return this._filterMappings;
    }

    public List getListeners() {
        return this._listeners;
    }

    public void processRunAsAnnotations() throws Exception {
        for (Class<?> clazz : this._finder.getClassesForAnnotation(javax.annotation.security.RunAs.class)) {
            String role;
            if (!Servlet.class.isAssignableFrom(clazz) && !this._pojoInstances.containsKey(clazz)) {
                Log.debug((String)("Ignoring runAs notation on on-servlet class " + clazz.getName()));
                continue;
            }
            javax.annotation.security.RunAs runAs = clazz.getAnnotation(javax.annotation.security.RunAs.class);
            if (runAs == null || (role = runAs.value()) == null) continue;
            RunAs ra = new RunAs();
            ra.setTargetClass(clazz);
            ra.setRoleName(role);
            this._runAs.add(ra);
        }
    }

    public void processLifeCycleCallbackAnnotations() throws Exception {
        this.processPostConstructAnnotations();
        this.processPreDestroyAnnotations();
    }

    private void processPostConstructAnnotations() throws Exception {
        for (Method m : this._finder.getMethodsForAnnotation(PostConstruct.class)) {
            if (!this.isServletType(m.getDeclaringClass())) {
                Log.debug((String)("Ignoring " + m.getName() + " as non-servlet type"));
                continue;
            }
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PostConstructCallback callback = new PostConstructCallback();
            callback.setTargetClass(m.getDeclaringClass());
            callback.setTarget(m);
            this._callbacks.add((LifeCycleCallback)callback);
        }
    }

    public void processPreDestroyAnnotations() throws Exception {
        for (Method m : this._finder.getMethodsForAnnotation(PreDestroy.class)) {
            if (!this.isServletType(m.getDeclaringClass())) {
                Log.debug((String)("Ignoring " + m.getName() + " as non-servlet type"));
                continue;
            }
            if (m.getParameterTypes().length != 0) {
                throw new IllegalStateException(m + " has parameters");
            }
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalStateException(m + " is not void");
            }
            if (m.getExceptionTypes().length != 0) {
                throw new IllegalStateException(m + " throws checked exceptions");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " is static");
            }
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTargetClass(m.getDeclaringClass());
            callback.setTarget(m);
            this._callbacks.add((LifeCycleCallback)callback);
        }
    }

    public void processResourcesAnnotations() throws Exception {
        List<Class<?>> classes = this._finder.getClassesForAnnotation(Resources.class);
        for (Class<?> clazz : classes) {
            Resource[] resArray;
            if (!this.isServletType(clazz)) {
                Log.debug((String)("Ignoring @Resources annotation on on-servlet type class " + clazz.getName()));
                continue;
            }
            Resources resources = clazz.getAnnotation(Resources.class);
            if (resources == null || (resArray = resources.value()) == null || resArray.length == 0) continue;
            for (int j = 0; j < resArray.length; ++j) {
                String name = resArray[j].name();
                String mappedName = resArray[j].mappedName();
                Resource.AuthenticationType auth = resArray[j].authenticationType();
                Class type = resArray[j].type();
                boolean shareable = resArray[j].shareable();
                if (name == null || name.trim().equals("")) {
                    throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
                }
                try {
                    if (NamingEntryUtil.bindToENC((Object)this._webApp, (String)name, (String)mappedName) || NamingEntryUtil.bindToENC((Object)this._webApp.getServer(), (String)name, (String)mappedName)) continue;
                    throw new IllegalStateException("No resource bound at " + (mappedName == null ? name : mappedName));
                }
                catch (NamingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public void processResourceAnnotations() throws Exception {
        this.processClassResourceAnnotations();
        this.processMethodResourceAnnotations();
        this.processFieldResourceAnnotations();
    }

    public void processClassResourceAnnotations() throws Exception {
        List<Class<?>> classes = this._finder.getClassesForAnnotation(Resource.class);
        for (Class<?> clazz : classes) {
            if (!this.isServletType(clazz)) {
                Log.debug((String)("Ignoring @Resource annotation on on-servlet type class " + clazz.getName()));
                continue;
            }
            Resource resource = clazz.getAnnotation(Resource.class);
            if (resource == null) continue;
            String name = resource.name();
            String mappedName = resource.mappedName();
            Resource.AuthenticationType auth = resource.authenticationType();
            Class type = resource.type();
            boolean shareable = resource.shareable();
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (NamingEntryUtil.bindToENC((Object)this._webApp, (String)name, (String)mappedName) || NamingEntryUtil.bindToENC((Object)this._webApp.getServer(), (String)name, (String)mappedName)) continue;
                throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void processMethodResourceAnnotations() throws Exception {
        List<Method> methods = this._finder.getMethodsForAnnotation(Resource.class);
        for (Method m : methods) {
            if (!this.isServletType(m.getDeclaringClass())) {
                Log.debug((String)("Ignoring @Resource annotation on on-servlet type method " + m.getName()));
                continue;
            }
            Resource resource = m.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalStateException(m + " cannot be static");
            }
            if (!IntrospectionUtil.isJavaBeanCompliantSetter((Method)m)) {
                throw new IllegalStateException(m + " is not a java bean compliant setter method");
            }
            String name = m.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            name = m.getDeclaringClass().getCanonicalName() + "/" + name;
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Class<?> type = m.getParameterTypes()[0];
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with method param=" + type + " for " + m);
            }
            Injection webXmlInjection = this._injections.getInjection(m.getDeclaringClass(), (Member)m);
            if (webXmlInjection == null) {
                try {
                    boolean bound = NamingEntryUtil.bindToENC((Object)this._webApp, (String)name, (String)mappedName);
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC((Object)this._webApp.getServer(), (String)name, (String)mappedName);
                    }
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                    }
                    if (!bound) {
                        try {
                            InitialContext ic = new InitialContext();
                            String nameInEnvironment = mappedName != null ? mappedName : name;
                            ic.lookup("java:comp/env/" + nameInEnvironment);
                            bound = true;
                        }
                        catch (NameNotFoundException e) {
                            bound = false;
                        }
                    }
                    if (bound) {
                        Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                        Injection injection = new Injection();
                        injection.setTargetClass(m.getDeclaringClass());
                        injection.setJndiName(name);
                        injection.setMappingName(mappedName);
                        injection.setTarget((Member)m);
                        this._injections.add(injection);
                        continue;
                    }
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
                catch (NamingException e) {
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            Object value = webXmlInjection.lookupInjectedValue();
            if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
            throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
        }
    }

    public void processFieldResourceAnnotations() throws Exception {
        List<Field> fields = this._finder.getFieldsForAnnotation(Resource.class);
        for (Field f : fields) {
            if (!this.isServletType(f.getDeclaringClass())) {
                Log.debug((String)("Ignoring @Resource annotation on on-servlet type field " + f.getName()));
                continue;
            }
            Resource resource = f.getAnnotation(Resource.class);
            if (resource == null) continue;
            if (Modifier.isStatic(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be static");
            }
            if (Modifier.isFinal(f.getModifiers())) {
                throw new IllegalStateException(f + " cannot be final");
            }
            String name = f.getDeclaringClass().getCanonicalName() + "/" + f.getName();
            name = resource.name() != null && !resource.name().trim().equals("") ? resource.name() : name;
            Class<?> type = f.getType();
            if (resource.type() != null && !resource.type().equals(Object.class) && !IntrospectionUtil.isTypeCompatible(type, (Class)resource.type(), (boolean)false)) {
                throw new IllegalStateException("@Resource incompatible type=" + resource.type() + " with field type =" + f.getType());
            }
            String mappedName = resource.mappedName() != null && !resource.mappedName().trim().equals("") ? resource.mappedName() : null;
            Resource.AuthenticationType auth = resource.authenticationType();
            boolean shareable = resource.shareable();
            Injection webXmlInjection = this._injections.getInjection(f.getDeclaringClass(), (Member)f);
            if (webXmlInjection == null) {
                try {
                    boolean bound = NamingEntryUtil.bindToENC((Object)this._webApp, (String)name, (String)mappedName);
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC((Object)this._webApp.getServer(), (String)name, (String)mappedName);
                    }
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                    }
                    if (!bound) {
                        try {
                            InitialContext ic = new InitialContext();
                            String nameInEnvironment = mappedName != null ? mappedName : name;
                            ic.lookup("java:comp/env/" + nameInEnvironment);
                            bound = true;
                        }
                        catch (NameNotFoundException e) {
                            bound = false;
                        }
                    }
                    if (bound) {
                        Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                        Injection injection = new Injection();
                        injection.setTargetClass(f.getDeclaringClass());
                        injection.setJndiName(name);
                        injection.setMappingName(mappedName);
                        injection.setTarget((Member)f);
                        this._injections.add(injection);
                        continue;
                    }
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
                catch (NamingException e) {
                    if (AnnotationProcessor.isEnvEntryType(type)) continue;
                    throw new IllegalStateException(e);
                }
            }
            Object value = webXmlInjection.lookupInjectedValue();
            if (IntrospectionUtil.isTypeCompatible(type, value.getClass(), (boolean)false)) continue;
            throw new IllegalStateException("Type of field=" + type + " is not compatible with Resource type=" + value.getClass());
        }
    }

    private boolean isServletType(Class c) {
        boolean isServlet = false;
        if (Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || this._pojoInstances.get(c) != null) {
            isServlet = true;
        }
        return isServlet;
    }

    private Object getPojoInstanceFor(Class clazz) throws InstantiationException, IllegalAccessException {
        Object instance = this._pojoInstances.get(clazz);
        if (instance == null) {
            instance = clazz.newInstance();
            this._pojoInstances.put(clazz, instance);
        }
        return instance;
    }

    private static boolean isEnvEntryType(Class type) {
        boolean result = false;
        for (int i = 0; i < __envEntryTypes.length && !result; ++i) {
            result = type.equals(__envEntryTypes[i]);
        }
        return result;
    }

    protected static String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }
}

