/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Queue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.ConcurrentArrayQueue;

public class HTTP2ServerConnection
extends HTTP2Connection {
    private final Queue<HttpChannelOverHTTP2> channels = new ConcurrentArrayQueue();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, Parser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, parser, session, inputBufferSize);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    public void onOpen() {
        super.onOpen();
        this.notifyAccept(this.getSession());
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept((Session)session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", new Object[]{frame, stream});
        }
        HttpChannelOverHTTP2 channel = this.provideHttpChannel(connector, stream);
        Runnable task = channel.onRequest(frame);
        this.offerTask(task, false);
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", new Object[]{request, stream});
        }
        HttpChannelOverHTTP2 channel = this.provideHttpChannel(connector, stream);
        Runnable task = channel.onPushRequest(request);
        this.offerTask(task, true);
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.channels.poll();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", new Object[]{channel, this});
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = new ServerHttpChannelOverHTTP2(connector, this.httpConfig, this.getEndPoint(), transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", new Object[]{channel, this});
            }
        }
        stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, (Object)channel);
        return channel;
    }

    private class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2 {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        public void onCompleted() {
            super.onCompleted();
            this.recycle();
            HTTP2ServerConnection.this.channels.offer(this);
        }
    }
}

