/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.FlowControl;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ServerSession
extends HTTP2Session
implements ServerParser.Listener {
    private static final Logger LOG = Log.getLogger(HTTP2ServerSession.class);
    private final ServerSessionListener listener;

    public HTTP2ServerSession(Scheduler scheduler, EndPoint endPoint, Generator generator, ServerSessionListener listener, FlowControl flowControl) {
        super(scheduler, endPoint, generator, (Session.Listener)listener, flowControl, 2);
        this.listener = listener;
    }

    public boolean onPreface() {
        Map<Integer, Integer> settings = this.notifyPreface((Session)this);
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        SettingsFrame frame = new SettingsFrame(settings, false);
        this.control(null, (Callback)Callback.Adapter.INSTANCE, (Frame)frame, Frame.EMPTY_ARRAY);
        return false;
    }

    public boolean onHeaders(HeadersFrame frame) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest()) {
            IStream stream = this.createRemoteStream(frame.getStreamId());
            if (stream != null) {
                stream.updateClose(frame.isEndStream(), false);
                stream.process((Frame)frame, (Callback)Callback.Adapter.INSTANCE);
                Stream.Listener listener = this.notifyNewStream((Stream)stream, frame);
                stream.setListener(listener);
                if (stream.isClosed()) {
                    this.removeStream(stream, false);
                }
            }
        } else {
            this.onConnectionFailure(2, "invalid_request");
        }
        return false;
    }

    public boolean onPushPromise(PushPromiseFrame frame) {
        this.onConnectionFailure(1, "push_promise");
        return false;
    }

    private Map<Integer, Integer> notifyPreface(Session session) {
        try {
            return this.listener.onPreface(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return null;
        }
    }
}

