/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpInputOverHTTP2;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final Callback commitCallback = new CommitCallback();
    private final Connector connector;
    private final HttpConfiguration httpConfiguration;
    private final EndPoint endPoint;
    private final IStream stream;
    private final MetaData.Request request;

    public HttpTransportOverHTTP2(Connector connector, HttpConfiguration httpConfiguration, EndPoint endPoint, IStream stream, MetaData.Request request) {
        this.connector = connector;
        this.httpConfiguration = httpConfiguration;
        this.endPoint = endPoint;
        this.stream = stream;
        this.request = request;
    }

    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(this.request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (info != null) {
            if (this.commit.compareAndSet(false, true)) {
                if (hasContent) {
                    this.commit(info, false, this.commitCallback);
                    this.send(content, lastContent, callback);
                } else {
                    this.commit(info, lastContent, callback);
                }
            } else {
                callback.failed((Throwable)new IllegalStateException("committed"));
            }
        } else if (hasContent || lastContent) {
            this.send(content, lastContent, callback);
        } else {
            callback.succeeded();
        }
    }

    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", new Object[]{request});
            }
            return;
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, (MetaData)request), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(HttpTransportOverHTTP2.this.connector, HttpTransportOverHTTP2.this.httpConfiguration, HttpTransportOverHTTP2.this.endPoint, (IStream)pushStream, request);
                HttpInputOverHTTP2 input = new HttpInputOverHTTP2();
                HttpChannelOverHTTP2 channel = new HttpChannelOverHTTP2(HttpTransportOverHTTP2.this.connector, HttpTransportOverHTTP2.this.httpConfiguration, HttpTransportOverHTTP2.this.endPoint, transport, (HttpInput)input, pushStream);
                pushStream.setAttribute(IStream.CHANNEL_ATTRIBUTE, (Object)channel);
                channel.onPushRequest(request);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        });
    }

    private void commit(HttpGenerator.ResponseInfo info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}:{}{} {}{}{}", new Object[]{this.stream.getId(), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getHttpFields()});
        }
        MetaData.Response metaData = new MetaData.Response(HttpVersion.HTTP_2, info.getStatus(), info.getHttpFields());
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), (MetaData)metaData, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}: {} content bytes{}", new Object[]{this.stream.getId(), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, lastContent);
        this.stream.data(frame, callback);
    }

    public void completed() {
    }

    public void abort(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{} aborted", (long)this.stream.getId());
        }
        if (!this.stream.isReset()) {
            this.stream.reset(new ResetFrame(this.stream.getId(), 2), (Callback)Callback.Adapter.INSTANCE);
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{} committed", (long)HttpTransportOverHTTP2.this.stream.getId());
            }
        }

        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " failed to commit", x);
            }
        }
    }
}

