/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class HttpTransportOverFCGI
implements HttpTransport {
    private final ServerGenerator generator;
    private final Flusher flusher;
    private final int request;
    private volatile boolean head;

    public HttpTransportOverFCGI(ByteBufferPool byteBufferPool, Flusher flusher, int request) {
        this.generator = new ServerGenerator(byteBufferPool);
        this.flusher = flusher;
        this.request = request;
    }

    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        this.head = info.isHead();
        boolean head = this.head;
        if (head) {
            if (lastContent) {
                Generator.Result headersResult = this.generator.generateResponseHeaders(this.request, info.getStatus(), info.getReason(), info.getHttpFields(), (Callback)new Callback.Adapter());
                Generator.Result contentResult = this.generator.generateResponseContent(this.request, BufferUtil.EMPTY_BUFFER, lastContent, callback);
                this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
            } else {
                Generator.Result headersResult = this.generator.generateResponseHeaders(this.request, info.getStatus(), info.getReason(), info.getHttpFields(), callback);
                this.flusher.flush(new Generator.Result[]{headersResult});
            }
        } else {
            Generator.Result headersResult = this.generator.generateResponseHeaders(this.request, info.getStatus(), info.getReason(), info.getHttpFields(), (Callback)new Callback.Adapter());
            Generator.Result contentResult = this.generator.generateResponseContent(this.request, content, lastContent, callback);
            this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
        }
    }

    public void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (this.head) {
            if (lastContent) {
                Generator.Result result = this.generator.generateResponseContent(this.request, BufferUtil.EMPTY_BUFFER, lastContent, callback);
                this.flusher.flush(new Generator.Result[]{result});
            } else {
                callback.succeeded();
            }
        } else {
            Generator.Result result = this.generator.generateResponseContent(this.request, content, lastContent, callback);
            this.flusher.flush(new Generator.Result[]{result});
        }
    }

    public void completed() {
    }

    public void abort() {
    }
}

