/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.proxy;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpClientTransportOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ProcessorUtils;

public class FastCGIProxyServlet
extends AsyncProxyServlet.Transparent {
    public static final String SCRIPT_ROOT_INIT_PARAM = "scriptRoot";
    public static final String SCRIPT_PATTERN_INIT_PARAM = "scriptPattern";
    public static final String ORIGINAL_URI_ATTRIBUTE_INIT_PARAM = "originalURIAttribute";
    public static final String ORIGINAL_QUERY_ATTRIBUTE_INIT_PARAM = "originalQueryAttribute";
    public static final String FASTCGI_HTTPS_INIT_PARAM = "fastCGI.HTTPS";
    public static final String FASTCGI_ENV_NAMES_INIT_PARAM = "fastCGI.envNames";
    private static final String REMOTE_ADDR_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".remoteAddr";
    private static final String REMOTE_PORT_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".remotePort";
    private static final String SERVER_NAME_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverName";
    private static final String SERVER_ADDR_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverAddr";
    private static final String SERVER_PORT_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverPort";
    private static final String SCHEME_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".scheme";
    private static final String REQUEST_URI_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".requestURI";
    private static final String REQUEST_QUERY_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".requestQuery";
    private Pattern scriptPattern;
    private String originalURIAttribute;
    private String originalQueryAttribute;
    private boolean fcgiHTTPS;
    private Set<String> fcgiEnvNames;

    public void init() throws ServletException {
        super.init();
        String value = this.getInitParameter(SCRIPT_PATTERN_INIT_PARAM);
        if (value == null) {
            value = "(.+?\\.php)";
        }
        this.scriptPattern = Pattern.compile(value);
        this.originalURIAttribute = this.getInitParameter(ORIGINAL_URI_ATTRIBUTE_INIT_PARAM);
        this.originalQueryAttribute = this.getInitParameter(ORIGINAL_QUERY_ATTRIBUTE_INIT_PARAM);
        this.fcgiHTTPS = Boolean.parseBoolean(this.getInitParameter(FASTCGI_HTTPS_INIT_PARAM));
        this.fcgiEnvNames = Collections.emptySet();
        String envNames = this.getInitParameter(FASTCGI_ENV_NAMES_INIT_PARAM);
        if (envNames != null) {
            this.fcgiEnvNames = Stream.of(envNames.split(",")).map(String::trim).collect(Collectors.toSet());
        }
    }

    protected HttpClient newHttpClient() {
        ClientConnector connector;
        ServletConfig config = this.getServletConfig();
        String scriptRoot = config.getInitParameter(SCRIPT_ROOT_INIT_PARAM);
        if (scriptRoot == null) {
            throw new IllegalArgumentException("Mandatory parameter 'scriptRoot' not configured");
        }
        String unixDomainPath = config.getInitParameter("unixDomainPath");
        if (unixDomainPath != null) {
            connector = ClientConnector.forUnixDomain((Path)Path.of(unixDomainPath, new String[0]));
        } else {
            int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
            String value = config.getInitParameter("selectors");
            if (value != null) {
                selectors = Integer.parseInt(value);
            }
            connector = new ClientConnector();
            connector.setSelectors(selectors);
        }
        return new HttpClient((HttpClientTransport)new ProxyHttpClientTransportOverFCGI(connector, scriptRoot));
    }

    protected void sendProxyRequest(HttpServletRequest request, HttpServletResponse proxyResponse, Request proxyRequest) {
        List cookies;
        proxyRequest.attribute(REMOTE_ADDR_ATTRIBUTE, (Object)request.getRemoteAddr());
        proxyRequest.attribute(REMOTE_PORT_ATTRIBUTE, (Object)String.valueOf(request.getRemotePort()));
        proxyRequest.attribute(SERVER_NAME_ATTRIBUTE, (Object)request.getServerName());
        proxyRequest.attribute(SERVER_ADDR_ATTRIBUTE, (Object)request.getLocalAddr());
        proxyRequest.attribute(SERVER_PORT_ATTRIBUTE, (Object)String.valueOf(request.getLocalPort()));
        proxyRequest.attribute(SCHEME_ATTRIBUTE, (Object)request.getScheme());
        Object originalURI = null;
        String originalQuery = null;
        if (this.originalURIAttribute != null) {
            originalURI = (String)request.getAttribute(this.originalURIAttribute);
        }
        if (originalURI != null && this.originalQueryAttribute != null && (originalQuery = (String)request.getAttribute(this.originalQueryAttribute)) != null) {
            originalURI = (String)originalURI + "?" + originalQuery;
        }
        if (originalURI == null) {
            String originalPath = (String)request.getAttribute("javax.servlet.forward.request_uri");
            originalQuery = (String)request.getAttribute("javax.servlet.forward.query_string");
            if (originalPath == null) {
                originalPath = (String)request.getAttribute("javax.servlet.include.request_uri");
                originalQuery = (String)request.getAttribute("javax.servlet.include.query_string");
            }
            if (originalPath != null) {
                originalURI = originalPath;
                if (originalQuery != null) {
                    originalURI = (String)originalURI + "?" + originalQuery;
                }
            }
        }
        if (originalURI != null) {
            proxyRequest.attribute(REQUEST_URI_ATTRIBUTE, originalURI);
        }
        if (originalQuery != null) {
            proxyRequest.attribute(REQUEST_QUERY_ATTRIBUTE, (Object)originalQuery);
        }
        if (!proxyRequest.getHeaders().contains(HttpHeader.HOST)) {
            Object server = request.getServerName();
            int port = request.getServerPort();
            if (!this.getHttpClient().isDefaultPort(request.getScheme(), port)) {
                server = (String)server + ":" + port;
            }
            String host = server;
            proxyRequest.headers(headers -> headers.put(HttpHeader.HOST, host).put(HttpHeader.X_FORWARDED_HOST, host));
        }
        if ((cookies = proxyRequest.getHeaders().getValuesList(HttpHeader.COOKIE)).size() > 1) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < cookies.size(); ++i) {
                if (i > 0) {
                    builder.append("; ");
                }
                String cookie = (String)cookies.get(i);
                builder.append(cookie);
            }
            proxyRequest.headers(headers -> headers.put(HttpHeader.COOKIE, builder.toString()));
        }
        super.sendProxyRequest(request, proxyResponse, proxyRequest);
    }

    protected void customizeFastCGIHeaders(Request proxyRequest, HttpFields.Mutable fastCGIHeaders) {
        URI proxyRequestURI;
        for (String envName : this.fcgiEnvNames) {
            String envValue = System.getenv(envName);
            if (envValue == null) continue;
            fastCGIHeaders.put(envName, envValue);
        }
        fastCGIHeaders.remove("HTTP_PROXY");
        fastCGIHeaders.put("REMOTE_ADDR", (String)proxyRequest.getAttributes().get(REMOTE_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("REMOTE_PORT", (String)proxyRequest.getAttributes().get(REMOTE_PORT_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_NAME", (String)proxyRequest.getAttributes().get(SERVER_NAME_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_ADDR", (String)proxyRequest.getAttributes().get(SERVER_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_PORT", (String)proxyRequest.getAttributes().get(SERVER_PORT_ATTRIBUTE));
        if (this.fcgiHTTPS || HttpScheme.HTTPS.is((String)proxyRequest.getAttributes().get(SCHEME_ATTRIBUTE))) {
            fastCGIHeaders.put("HTTPS", "on");
        }
        String rawPath = (proxyRequestURI = proxyRequest.getURI()) == null ? proxyRequest.getPath() : proxyRequestURI.getRawPath();
        String rawQuery = proxyRequestURI == null ? null : proxyRequestURI.getRawQuery();
        Object requestURI = (String)proxyRequest.getAttributes().get(REQUEST_URI_ATTRIBUTE);
        if (requestURI == null) {
            requestURI = rawPath;
            if (rawQuery != null) {
                requestURI = (String)requestURI + "?" + rawQuery;
            }
        }
        fastCGIHeaders.put("REQUEST_URI", (String)requestURI);
        String requestQuery = (String)proxyRequest.getAttributes().get(REQUEST_QUERY_ATTRIBUTE);
        if (requestQuery != null) {
            fastCGIHeaders.put("QUERY_STRING", requestQuery);
        }
        String scriptName = rawPath;
        Matcher matcher = this.scriptPattern.matcher(rawPath);
        if (matcher.matches()) {
            scriptName = matcher.group(1);
            if (matcher.groupCount() > 1) {
                fastCGIHeaders.put("PATH_INFO", matcher.group(2));
            }
        }
        fastCGIHeaders.put("SCRIPT_NAME", scriptName);
        String root = fastCGIHeaders.get("DOCUMENT_ROOT");
        fastCGIHeaders.put("SCRIPT_FILENAME", root + scriptName);
    }

    private class ProxyHttpClientTransportOverFCGI
    extends HttpClientTransportOverFCGI {
        private ProxyHttpClientTransportOverFCGI(ClientConnector connector, String scriptRoot) {
            super(connector, scriptRoot);
        }

        protected void customize(Request request, HttpFields.Mutable fastCGIHeaders) {
            super.customize(request, fastCGIHeaders);
            FastCGIProxyServlet.this.customizeFastCGIHeaders(request, fastCGIHeaders);
            if (FastCGIProxyServlet.this._log.isDebugEnabled()) {
                TreeMap<String, String> fcgi = new TreeMap<String, String>();
                for (HttpField field : fastCGIHeaders) {
                    fcgi.put(field.getName(), field.getValue());
                }
                String eol = System.lineSeparator();
                FastCGIProxyServlet.this._log.debug("FastCGI variables {}{}", (Object)eol, (Object)fcgi.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(eol)));
            }
        }
    }
}

